/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackTools {
    private static final String CALLER = "Bio-Formats";

    private LogbackTools() {
    }

    public static synchronized boolean isEnabled() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = root.getLoggerContext();
        return ConfigurationWatchListUtil.getMainWatchURL((Context)loggerContext) != null || loggerContext.getProperty("caller").equals(CALLER);
    }

    public static synchronized void setRootLevel(String level) {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.toLevel((String)level));
    }

    public static synchronized boolean enableLogging() {
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext context = root.getLoggerContext();
        if (!root.iteratorForAppenders().hasNext()) {
            context.reset();
            context.putProperty("caller", CALLER);
            PatternLayoutEncoder layout = new PatternLayoutEncoder();
            layout.setContext((Context)context);
            layout.setPattern("%m%n");
            layout.start();
            ConsoleAppender appender = new ConsoleAppender();
            appender.setContext((Context)context);
            appender.setEncoder((Encoder)layout);
            appender.start();
            root.addAppender((Appender)appender);
        } else {
            Appender defaultAppender = (Appender)root.iteratorForAppenders().next();
            if (defaultAppender instanceof ConsoleAppender) {
                context.reset();
                context.putProperty("caller", CALLER);
                PatternLayoutEncoder layout = new PatternLayoutEncoder();
                layout.setContext((Context)context);
                layout.setPattern("%m%n");
                layout.start();
                defaultAppender.setContext((Context)context);
                ((ConsoleAppender)defaultAppender).setEncoder((Encoder)layout);
                defaultAppender.start();
                root.addAppender(defaultAppender);
            }
        }
        return true;
    }

    public static synchronized void enableIJLogging(boolean debug, Appender<ILoggingEvent> appender) {
        try {
            Logger logger = LoggerFactory.getLogger((String)"ROOT");
            if (!(logger instanceof ch.qos.logback.classic.Logger)) {
                return;
            }
            ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)logger;
            if (debug) {
                root.setLevel(Level.DEBUG);
            }
            appender.setContext((Context)root.getLoggerContext());
            root.addAppender(appender);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

