/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr.chunk;

import com.bc.zarr.Compressor;
import com.bc.zarr.CompressorFactory;
import com.bc.zarr.DataType;
import com.bc.zarr.ZarrUtils;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Byte;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Double;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Float;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Integer;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Long;
import com.bc.zarr.chunk.ChunkReaderWriterImpl_Short;
import com.bc.zarr.storage.Store;
import com.bc.zarr.ucar.NetCDF_Util;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import ucar.ma2.Array;

public abstract class ChunkReaderWriter {
    protected final Compressor compressor;
    final int[] chunkShape;
    protected final Number fill;
    protected final Store store;
    protected final ByteOrder order;
    private final int size;

    ChunkReaderWriter(ByteOrder order, Compressor compressor, int[] chunkShape, Number fill, Store store) {
        this.compressor = compressor != null ? compressor : CompressorFactory.nullCompressor;
        this.chunkShape = Arrays.copyOf(chunkShape, chunkShape.length);
        this.fill = fill;
        this.size = ZarrUtils.computeSizeInteger(chunkShape);
        this.store = store;
        this.order = order;
    }

    public static ChunkReaderWriter create(Compressor compressor, DataType dataType, ByteOrder order, int[] chunkShape, Number fill, Store store) {
        if (dataType == DataType.f8) {
            return new ChunkReaderWriterImpl_Double(order, compressor, chunkShape, fill, store);
        }
        if (dataType == DataType.f4) {
            return new ChunkReaderWriterImpl_Float(order, compressor, chunkShape, fill, store);
        }
        if (dataType == DataType.i8) {
            return new ChunkReaderWriterImpl_Long(order, compressor, chunkShape, fill, store);
        }
        if (dataType == DataType.i4 || dataType == DataType.u4) {
            return new ChunkReaderWriterImpl_Integer(order, compressor, chunkShape, fill, store);
        }
        if (dataType == DataType.i2 || dataType == DataType.u2) {
            return new ChunkReaderWriterImpl_Short(order, compressor, chunkShape, fill, store);
        }
        if (dataType == DataType.i1 || dataType == DataType.u1) {
            return new ChunkReaderWriterImpl_Byte(compressor, chunkShape, fill, store);
        }
        throw new IllegalStateException();
    }

    public abstract Array read(String var1) throws IOException;

    public abstract void write(String var1, Array var2) throws IOException;

    protected Array createFilled(ucar.ma2.DataType dataType) {
        return NetCDF_Util.createFilledArray(dataType, this.chunkShape, this.fill);
    }

    protected int getSize() {
        return this.size;
    }
}

