/*
 * Decompiled with CFR 0.152.
 */
package thredds.featurecollection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionType;
import thredds.featurecollection.TimeUnitConverter;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.DateExtractor;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.DateExtractorNone;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class FeatureCollectionConfig {
    public static final String AUX_CONFIG = "fcConfig";
    private static Logger log = LoggerFactory.getLogger(FeatureCollectionConfig.class);
    public String name;
    public String path;
    public String spec;
    public String collectionName;
    public String dateFormatMark;
    public String olderThan;
    private String rootDir;
    private String regExp;
    public FeatureCollectionType type;
    public PartitionType ptype = PartitionType.directory;
    public CalendarPeriod timePeriod;
    public UpdateConfig tdmConfig = new UpdateConfig();
    public UpdateConfig updateConfig = new UpdateConfig();
    public ProtoConfig protoConfig = new ProtoConfig();
    public FmrcConfig fmrcConfig = new FmrcConfig();
    public PointConfig pointConfig = new PointConfig();
    public GribConfig gribConfig = new GribConfig();
    public Element innerNcml;
    public Optional<Boolean> filesSortIncreasing = Optional.empty();
    private static boolean regularizeDefault;
    private static Set<FmrcDatasetType> defaultFmrcDatasetTypes;
    private static Set<PointDatasetType> defaultPointDatasetTypes;
    private static final Set<GribDatasetType> defaultGribDatasetTypes;
    public static boolean useGenTypeDef;
    public static boolean useTableVersionDef;
    public static boolean intvMergeDef;
    public static boolean useCenterDef;

    public FeatureCollectionConfig() {
    }

    public FeatureCollectionConfig(String name, String path, FeatureCollectionType fcType, String spec, String collectionName, String dateFormatMark, String olderThan, String timePartition, Element innerNcml) {
        this.name = name;
        this.path = StringUtil2.trim(path, 47);
        this.type = fcType;
        this.spec = spec;
        this.collectionName = collectionName == null ? name : collectionName;
        this.dateFormatMark = dateFormatMark;
        this.olderThan = olderThan;
        if (null != timePartition) {
            if (timePartition.equalsIgnoreCase("none")) {
                this.ptype = PartitionType.none;
            } else if (timePartition.equalsIgnoreCase("directory")) {
                this.ptype = PartitionType.directory;
            } else if (timePartition.equalsIgnoreCase("file")) {
                this.ptype = PartitionType.file;
            } else if (timePartition.equalsIgnoreCase("all")) {
                this.ptype = PartitionType.all;
            } else {
                this.timePeriod = CalendarPeriod.of(timePartition);
                this.ptype = PartitionType.timePeriod;
                if (this.timePeriod == null) {
                    throw new IllegalArgumentException("Illegal timePeriod= " + timePartition);
                }
            }
        }
        this.innerNcml = innerNcml;
    }

    public void setFilter(String rootDir, String regExp) {
        this.rootDir = rootDir;
        this.regExp = regExp;
    }

    public void setFilesSort(Element filesSortElem) {
        if (filesSortElem == null) {
            return;
        }
        String increasingS = filesSortElem.getAttributeValue("increasing");
        if (increasingS != null) {
            if (increasingS.equalsIgnoreCase("true")) {
                this.filesSortIncreasing = Optional.of(true);
            } else if (increasingS.equalsIgnoreCase("false")) {
                this.filesSortIncreasing = Optional.of(false);
            }
        }
    }

    public boolean getSortFilesAscending() {
        if (this.filesSortIncreasing.isPresent()) {
            return this.filesSortIncreasing.get();
        }
        if (this.gribConfig != null && this.gribConfig.filesSortIncreasing.isPresent()) {
            return (Boolean)this.gribConfig.filesSortIncreasing.get();
        }
        return true;
    }

    public CollectionSpecParser getCollectionSpecParser(Formatter errlog) {
        if (this.rootDir != null) {
            return new CollectionSpecParser(this.rootDir, this.regExp, errlog);
        }
        return new CollectionSpecParser(this.spec, errlog);
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isTrigggerOk() {
        return this.updateConfig.triggerOk || this.tdmConfig != null && this.tdmConfig.triggerOk;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("FeatureCollectionConfig name ='%s' collectionName='%s' type='%s'%n", new Object[]{this.name, this.collectionName, this.type});
        f.format("  spec='%s'%n", this.spec);
        if (this.rootDir != null) {
            f.format("  rootDir= '%s' regExp= '%s'%n", this.rootDir, this.regExp);
        }
        if (this.dateFormatMark != null) {
            f.format("  dateFormatMark ='%s'%n", this.dateFormatMark);
        }
        if (this.olderThan != null) {
            f.format("  olderThan =%s%n", this.olderThan);
        }
        f.format("  timePartition =%s%n", new Object[]{this.ptype});
        if (this.updateConfig != null) {
            f.format("  updateConfig =%s%n", this.updateConfig);
        }
        if (this.tdmConfig != null) {
            f.format("  tdmConfig =%s%n", this.tdmConfig);
        }
        if (this.protoConfig != null) {
            f.format("  %s%n", this.protoConfig);
        }
        f.format("  hasInnerNcml =%s%n", this.innerNcml != null);
        if (this.type != null) {
            switch (this.type) {
                case GRIB1: 
                case GRIB2: {
                    f.format("  %s%n", this.gribConfig);
                    break;
                }
                case FMRC: {
                    f.format("  fmrcConfig =%s%n", this.fmrcConfig);
                    break;
                }
                case Point: 
                case Station: 
                case Station_Profile: {
                    f.format("  pointConfig =%s%n", this.pointConfig);
                }
            }
        }
        return f.toString();
    }

    public void show(Formatter f) {
        f.format("FeatureCollectionConfig name= '%s' collectionName= '%s' type= '%s'%n", new Object[]{this.name, this.collectionName, this.type});
        f.format("  spec= '%s'%n", this.spec);
        if (this.rootDir != null) {
            f.format("  rootDir= '%s' regExp= '%s'%n", this.rootDir, this.regExp);
        }
        if (this.dateFormatMark != null) {
            f.format("  dateFormatMark='%s'%n", this.dateFormatMark);
        }
        if (this.olderThan != null) {
            f.format("  olderThan= %s%n", this.olderThan);
        }
        if (this.ptype == PartitionType.timePeriod) {
            f.format("  timePartition= %s %n", this.timePeriod);
        } else {
            f.format("  timePartition= %s%n", new Object[]{this.ptype});
        }
        if (this.type != null) {
            switch (this.type) {
                case GRIB1: 
                case GRIB2: {
                    this.gribConfig.show(f);
                    break;
                }
                case FMRC: {
                    f.format("  fmrcConfig= %s%n", this.fmrcConfig);
                    break;
                }
                case Point: 
                case Station: 
                case Station_Profile: {
                    f.format("  pointConfig= %s%n", this.pointConfig);
                }
            }
        }
    }

    public void finish() {
        if (!this.tdmConfig.userDefined) {
            this.tdmConfig.updateType = CollectionUpdateType.test;
        }
        if (!this.updateConfig.userDefined) {
            this.updateConfig.updateType = this.tdmConfig.userDefined ? CollectionUpdateType.never : CollectionUpdateType.nocheck;
        }
        this.updateConfig.startupType = this.updateConfig.updateType;
        this.tdmConfig.startupType = this.tdmConfig.updateType;
    }

    public DateExtractor getDateExtractor() {
        if (this.dateFormatMark != null) {
            return new DateExtractorFromName(this.dateFormatMark, false);
        }
        CollectionSpecParser sp = this.getCollectionSpecParser(null);
        if (sp.getDateFormatMark() != null) {
            return new DateExtractorFromName(sp.getDateFormatMark(), true);
        }
        return new DateExtractorNone();
    }

    public static void setRegularizeDefault(boolean t2) {
        regularizeDefault = t2;
    }

    static /* synthetic */ boolean access$200() {
        return regularizeDefault;
    }

    static /* synthetic */ Set access$300() {
        return defaultFmrcDatasetTypes;
    }

    static /* synthetic */ Set access$400() {
        return defaultPointDatasetTypes;
    }

    static /* synthetic */ Set access$500() {
        return defaultGribDatasetTypes;
    }

    static {
        defaultFmrcDatasetTypes = Collections.unmodifiableSet(EnumSet.of(FmrcDatasetType.TwoD, FmrcDatasetType.Best, FmrcDatasetType.Files, FmrcDatasetType.Runs));
        defaultPointDatasetTypes = Collections.unmodifiableSet(EnumSet.of(PointDatasetType.cdmrFeature, PointDatasetType.Files));
        defaultGribDatasetTypes = Collections.unmodifiableSet(EnumSet.of(GribDatasetType.TwoD, GribDatasetType.Best, GribDatasetType.Files, GribDatasetType.Latest));
        intvMergeDef = true;
    }

    public static class TimeUnitConverterHash
    implements TimeUnitConverter {
        public Map<Integer, Integer> map = new HashMap<Integer, Integer>(5);

        @Override
        public int convertTimeUnit(int timeUnit) {
            if (this.map == null) {
                return timeUnit;
            }
            Integer convert = this.map.get(timeUnit);
            return convert == null ? timeUnit : convert;
        }
    }

    public static class GribIntvFilter {
        public List<IntvFilter> filterList = new ArrayList<IntvFilter>();
        public boolean isZeroExcluded;

        public boolean isZeroExcluded() {
            return this.isZeroExcluded;
        }

        public boolean hasFilter() {
            return !this.filterList.isEmpty();
        }

        public boolean filter(int id, int intvStart, int intvEnd, int prob) {
            int intvLength = intvEnd - intvStart;
            if (intvLength == 0 && this.isZeroExcluded()) {
                return true;
            }
            for (IntvFilter filter : this.filterList) {
                if (!filter.filter(id, intvStart, intvEnd, prob)) continue;
                return true;
            }
            return false;
        }

        void addInterval(String intervalS) {
            if (intervalS == null) {
                log.warn("Error on interval attribute: must not be empty");
                return;
            }
            String[] s2 = intervalS.split(",");
            if (s2.length != 2) {
                log.warn("Error on interval attribute: must be of form 'start,end'");
                return;
            }
            try {
                int start = Integer.parseInt(s2[0]);
                int end = Integer.parseInt(s2[1]);
                this.filterList.add(new IntervalFilter(start, end));
            }
            catch (NumberFormatException e) {
                log.info("Error on intvFilter element - attribute must be an integer");
            }
        }

        void addVariable(int intvLength, String idS, String probS) {
            if (idS == null) {
                log.warn("Error on intvFilter: must have an id attribute");
                return;
            }
            String[] s2 = idS.split("-");
            if (s2.length != 3 && s2.length != 4) {
                log.warn("Error on intvFilter: id attribute must be of form 'discipline-category-number' (GRIB2) or 'center-subcenter-version-param' (GRIB1)");
                return;
            }
            try {
                int id;
                if (s2.length == 3) {
                    int discipline = Integer.parseInt(s2[0]);
                    int category = Integer.parseInt(s2[1]);
                    int number = Integer.parseInt(s2[2]);
                    id = (discipline << 16) + (category << 8) + number;
                } else {
                    int center = Integer.parseInt(s2[0]);
                    int subcenter = Integer.parseInt(s2[1]);
                    int version = Integer.parseInt(s2[2]);
                    int param = Integer.parseInt(s2[3]);
                    id = (center << 8) + (subcenter << 16) + (version << 24) + param;
                }
                int prob = probS == null ? Integer.MIN_VALUE : Integer.parseInt(probS);
                this.filterList.add(new IntvLengthFilter(id, intvLength, prob));
            }
            catch (NumberFormatException e) {
                log.info("Error on intvFilter element - attribute must be an integer");
            }
        }
    }

    static class IntervalFilter
    implements IntvFilter {
        public final int start;
        public final int end;

        public IntervalFilter(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public boolean filter(int id, int intvStart, int intvEnd, int prob) {
            boolean match;
            boolean bl = match = this.start == intvStart && this.end == intvEnd;
            if (match) {
                log.info("interval filter applied id=" + id);
            }
            return match;
        }
    }

    static class IntvLengthFilter
    implements IntvFilter {
        public final int id;
        public final int intvLength;
        public final int prob;

        public IntvLengthFilter(int id, int intvLength, int prob) {
            this.id = id;
            this.intvLength = intvLength;
            this.prob = prob;
        }

        @Override
        public boolean filter(int id, int intvStart, int intvEnd, int prob) {
            boolean isMine;
            int intvLength = intvEnd - intvStart;
            boolean needProb = this.prob != Integer.MIN_VALUE;
            boolean hasProb = prob != Integer.MIN_VALUE;
            boolean bl = isMine = !needProb || hasProb && this.prob == prob;
            if (this.id == id && isMine) {
                return this.intvLength != intvLength;
            }
            return false;
        }
    }

    static interface IntvFilter {
        public boolean filter(int var1, int var2, int var3, int var4);
    }

    public static class GribConfig {
        public Map<Integer, Integer> gdsHash;
        public Map<Integer, String> gdsNamer;
        public boolean useGenType = useGenTypeDef;
        public boolean useTableVersion = useTableVersionDef;
        public boolean intvMerge = intvMergeDef;
        public boolean useCenter = useCenterDef;
        public boolean unionRuntimeCoord;
        public GribIntvFilter intvFilter;
        public TimeUnitConverterHash tuc;
        public CalendarPeriod userTimeUnit;
        public String latestNamer;
        public String bestNamer;
        private Optional<Boolean> filesSortIncreasing = Optional.empty();
        public Set<GribDatasetType> datasets = FeatureCollectionConfig.access$500();
        public String lookupTablePath;
        public String paramTablePath;
        public Element paramTable;
        private boolean explicitDatasets;

        public TimeUnitConverter getTimeUnitConverter() {
            return this.tuc;
        }

        public void configFromXml(Element configElem, Namespace ns) {
            Element element;
            String datasetTypes = configElem.getAttributeValue("datasetTypes");
            if (null != datasetTypes) {
                this.addDatasetType(datasetTypes);
            }
            List<Element> gdsElems = configElem.getChildren("gdsHash", ns);
            for (Element element2 : gdsElems) {
                this.addGdsHash(element2.getAttributeValue("from"), element2.getAttributeValue("to"));
            }
            List<Element> tuElems = configElem.getChildren("timeUnitConvert", ns);
            for (Element tu : tuElems) {
                this.addTimeUnitConvert(tu.getAttributeValue("from"), tu.getAttributeValue("to"));
            }
            gdsElems = configElem.getChildren("gdsName", ns);
            for (Element gds : gdsElems) {
                this.addGdsName(gds.getAttributeValue("hash"), gds.getAttributeValue("groupName"));
            }
            if (configElem.getChild("parameterMap", ns) != null) {
                this.paramTable = configElem.getChild("parameterMap", ns);
            }
            if (configElem.getChild("gribParameterTable", ns) != null) {
                this.paramTablePath = configElem.getChildText("gribParameterTable", ns);
            }
            if (configElem.getChild("gribParameterTableLookup", ns) != null) {
                this.lookupTablePath = configElem.getChildText("gribParameterTableLookup", ns);
            }
            if (configElem.getChild("latestNamer", ns) != null) {
                this.latestNamer = configElem.getChild("latestNamer", ns).getAttributeValue("name");
            }
            if (configElem.getChild("bestNamer", ns) != null) {
                this.bestNamer = configElem.getChild("bestNamer", ns).getAttributeValue("name");
            }
            if ((element = configElem.getChild("filesSort", ns)) != null) {
                String increasingS = element.getAttributeValue("increasing");
                if (increasingS != null) {
                    if (increasingS.equalsIgnoreCase("true")) {
                        this.filesSortIncreasing = Optional.of(true);
                    } else if (increasingS.equalsIgnoreCase("false")) {
                        this.filesSortIncreasing = Optional.of(false);
                    }
                } else {
                    Element lexigraphicByName = element.getChild("lexigraphicByName", ns);
                    if (lexigraphicByName != null && (increasingS = lexigraphicByName.getAttributeValue("increasing")) != null) {
                        if (increasingS.equalsIgnoreCase("true")) {
                            this.filesSortIncreasing = Optional.of(true);
                        } else if (increasingS.equalsIgnoreCase("false")) {
                            this.filesSortIncreasing = Optional.of(false);
                        }
                    }
                }
            }
            List<Element> intvElems = configElem.getChildren("intvFilter", ns);
            for (Element element3 : intvElems) {
                String intvLengthS;
                String intervalS;
                String excludeZero;
                if (this.intvFilter == null) {
                    this.intvFilter = new GribIntvFilter();
                }
                if ((excludeZero = element3.getAttributeValue("excludeZero")) != null) {
                    this.setExcludeZero(!excludeZero.equals("false"));
                }
                if ((intervalS = element3.getAttributeValue("interval")) != null) {
                    this.intvFilter.addInterval(intervalS);
                }
                if ((intvLengthS = element3.getAttributeValue("intvLength")) == null) continue;
                int intvLength = Integer.parseInt(intvLengthS);
                List<Element> varElems = element3.getChildren("variable", ns);
                for (Element varElem : varElems) {
                    this.intvFilter.addVariable(intvLength, varElem.getAttributeValue("id"), varElem.getAttributeValue("prob"));
                }
            }
            List<Element> paramElems = configElem.getChildren("option", ns);
            if (paramElems.isEmpty()) {
                paramElems = configElem.getChildren("parameter", ns);
            }
            for (Element param : paramElems) {
                String name = param.getAttributeValue("name");
                String value = param.getAttributeValue("value");
                if (name == null || value == null) continue;
                this.setOption(name, value);
            }
            Element element4 = configElem.getChild("pdsHash", ns);
            this.useGenType = this.readValue(element4, "useGenType", ns, useGenTypeDef);
            this.useTableVersion = this.readValue(element4, "useTableVersion", ns, useTableVersionDef);
            this.intvMerge = this.readValue(element4, "intvMerge", ns, intvMergeDef);
            this.useCenter = this.readValue(element4, "useCenter", ns, useCenterDef);
        }

        public boolean setOption(String name, String value) {
            if (name == null || value == null) {
                return false;
            }
            if (name.equalsIgnoreCase("timeUnit")) {
                this.setUserTimeUnit(value);
                return true;
            }
            if (name.equalsIgnoreCase("runtimeCoordinate") && value.equalsIgnoreCase("union")) {
                this.unionRuntimeCoord = true;
                return true;
            }
            return false;
        }

        public void setUserTimeUnit(String value) {
            if (value != null) {
                this.userTimeUnit = CalendarPeriod.of(value);
            }
        }

        public void setExcludeZero(boolean val) {
            if (this.intvFilter == null) {
                this.intvFilter = new GribIntvFilter();
            }
            this.intvFilter.isZeroExcluded = val;
        }

        public void setUseTableVersion(boolean val) {
            this.useTableVersion = val;
        }

        public void setIntervalLength(int intvLength, String varId) {
            if (this.intvFilter == null) {
                this.intvFilter = new GribIntvFilter();
            }
            this.intvFilter.addVariable(intvLength, varId, null);
        }

        private boolean readValue(Element pdsHashElement, String key, Namespace ns, boolean value) {
            Element e;
            if (pdsHashElement != null && (e = pdsHashElement.getChild(key, ns)) != null) {
                value = true;
                String t2 = e.getTextNormalize();
                if ("true".equalsIgnoreCase(t2)) {
                    value = true;
                }
                if ("false".equalsIgnoreCase(t2)) {
                    value = false;
                }
            }
            return value;
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicitDatasets) {
                this.datasets = EnumSet.noneOf(GribDatasetType.class);
            }
            this.explicitDatasets = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    GribDatasetType fdt = GribDatasetType.valueOf(type);
                    if (fdt == GribDatasetType.LatestFile) {
                        fdt = GribDatasetType.Latest;
                    }
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize GribDatasetType {}", (Object)type);
                }
            }
        }

        public boolean hasDatasetType(GribDatasetType type) {
            return this.datasets.contains((Object)type);
        }

        public void addGdsHash(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.gdsHash == null) {
                this.gdsHash = new HashMap<Integer, Integer>(10);
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.gdsHash.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addTimeUnitConvert(String fromS, String toS) {
            if (fromS == null || toS == null) {
                return;
            }
            if (this.tuc == null) {
                this.tuc = new TimeUnitConverterHash();
            }
            try {
                int from = Integer.parseInt(fromS);
                int to = Integer.parseInt(toS);
                this.tuc.map.put(from, to);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)fromS, (Object)toS);
            }
        }

        public void addGdsName(String hashS, String name) {
            if (hashS == null || name == null) {
                return;
            }
            if (this.gdsNamer == null) {
                this.gdsNamer = new HashMap<Integer, String>(5);
            }
            try {
                int hash = Integer.parseInt(hashS);
                this.gdsNamer.put(hash, name);
            }
            catch (Exception e) {
                log.warn("Failed  to parse as Integer = {} {}", (Object)hashS, (Object)name);
            }
        }

        public void show(Formatter f) {
            f.format("GribConfig= ", new Object[0]);
            if (this.useGenType != useGenTypeDef) {
                f.format(" useGenType=%s", this.useGenType);
            }
            if (this.useTableVersion != useTableVersionDef) {
                f.format(" useTableVersion=%s", this.useTableVersion);
            }
            if (this.intvMerge != intvMergeDef) {
                f.format(" intvMerge=%s", this.intvMerge);
            }
            if (this.useCenter != useCenterDef) {
                f.format(" useCenter=%s", this.useCenter);
            }
            if (this.userTimeUnit != null) {
                f.format(" userTimeUnit= %s", this.userTimeUnit);
            }
            f.format("%n", new Object[0]);
            if (this.gdsHash != null) {
                f.format("  gdsHash=%s%n", this.gdsHash);
            }
            if (this.gdsNamer != null) {
                f.format("  gdsNamer=%s%n", this.gdsNamer);
            }
            if (this.intvFilter != null) {
                f.format("  intvFilter=%s%n", this.intvFilter);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("GribConfig{");
            sb.append("datasets=").append(this.datasets);
            if (this.gdsHash != null) {
                sb.append(", gdsHash=").append(this.gdsHash);
            }
            if (this.gdsNamer != null) {
                sb.append(", gdsNamer=").append(this.gdsNamer);
            }
            sb.append(", useGenType=").append(this.useGenType);
            sb.append(", useTableVersion=").append(this.useTableVersion);
            sb.append(", intvMerge=").append(this.intvMerge);
            sb.append(", useCenter=").append(this.useCenter);
            if (this.lookupTablePath != null) {
                sb.append(", lookupTablePath='").append(this.lookupTablePath).append('\'');
            }
            if (this.paramTablePath != null) {
                sb.append(", paramTablePath='").append(this.paramTablePath).append('\'');
            }
            if (this.latestNamer != null) {
                sb.append(", latestNamer='").append(this.latestNamer).append('\'');
            }
            if (this.bestNamer != null) {
                sb.append(", bestNamer='").append(this.bestNamer).append('\'');
            }
            if (this.paramTable != null) {
                sb.append(", paramTable=").append(this.paramTable);
            }
            if (this.filesSortIncreasing.isPresent()) {
                sb.append(", filesSortIncreasing=").append(this.filesSortIncreasing);
            }
            if (this.intvFilter != null) {
                sb.append(", intvFilter=").append(this.intvFilter);
            }
            if (this.userTimeUnit != null) {
                sb.append(", userTimeUnit='").append(this.userTimeUnit).append('\'');
            }
            sb.append('}');
            return sb.toString();
        }

        public Object getIospMessage() {
            if (this.lookupTablePath != null) {
                return "gribParameterTableLookup=" + this.lookupTablePath;
            }
            if (this.paramTablePath != null) {
                return "gribParameterTable=" + this.paramTablePath;
            }
            return null;
        }

        public int convertGdsHash(int hashcode) {
            if (this.gdsHash == null) {
                return hashcode;
            }
            Integer convertedValue = this.gdsHash.get(hashcode);
            if (convertedValue == null) {
                return hashcode;
            }
            return convertedValue;
        }
    }

    public static class PointConfig {
        public Set<PointDatasetType> datasets = FeatureCollectionConfig.access$400();
        protected boolean explicit;

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(PointDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    PointDatasetType fdt = PointDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize PointDatasetType " + type);
                }
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("PointConfig: datasetTypes=%s", this.datasets);
            return f.toString();
        }
    }

    public static class BestDataset {
        public String name;
        public double greaterThan;

        public BestDataset(String name, double greaterThan) {
            this.name = name;
            this.greaterThan = greaterThan;
        }
    }

    public static class FmrcConfig {
        public boolean regularize = FeatureCollectionConfig.access$200();
        public Set<FmrcDatasetType> datasets = FeatureCollectionConfig.access$300();
        private boolean explicit;
        private List<BestDataset> bestDatasets;

        public FmrcConfig() {
        }

        public FmrcConfig(String regularize) {
            this.regularize = "true".equalsIgnoreCase(regularize);
        }

        public void addDatasetType(String datasetTypes) {
            String[] types;
            if (!this.explicit) {
                this.datasets = EnumSet.noneOf(FmrcDatasetType.class);
            }
            this.explicit = true;
            for (String type : types = StringUtil2.splitString(datasetTypes)) {
                try {
                    FmrcDatasetType fdt = FmrcDatasetType.valueOf(type);
                    this.datasets.add(fdt);
                }
                catch (Exception e) {
                    log.warn("Dont recognize FmrcDatasetType " + type);
                }
            }
        }

        public void addBestDataset(String name, double greaterEqual) {
            if (this.bestDatasets == null) {
                this.bestDatasets = new ArrayList<BestDataset>(2);
            }
            this.bestDatasets.add(new BestDataset(name, greaterEqual));
        }

        public List<BestDataset> getBestDatasets() {
            return this.bestDatasets;
        }

        public String toString() {
            Formatter f = new Formatter();
            f.format("FmrcConfig: regularize=%s datasetTypes=%s", this.regularize, this.datasets);
            if (this.bestDatasets != null) {
                for (BestDataset bd : this.bestDatasets) {
                    f.format("best = (%s, %f) ", bd.name, bd.greaterThan);
                }
            }
            return f.toString();
        }
    }

    public static class ProtoConfig {
        public ProtoChoice choice = ProtoChoice.Penultimate;
        public String param;
        public String change;
        public Element outerNcml;
        public boolean cacheAll = true;

        public ProtoConfig() {
        }

        public ProtoConfig(String choice, String change, String param, Element ncml) {
            if (choice != null) {
                try {
                    this.choice = ProtoChoice.valueOf(choice);
                }
                catch (Exception e) {
                    log.warn("Dont recognize ProtoChoice " + choice);
                }
            }
            this.change = change;
            this.param = param;
            this.outerNcml = ncml;
        }

        public String toString() {
            return "ProtoConfig{choice=" + (Object)((Object)this.choice) + ", change='" + this.change + '\'' + ", param='" + this.param + '\'' + ", outerNcml='" + this.outerNcml + '\'' + ", cacheAll=" + this.cacheAll + '}';
        }
    }

    public static class UpdateConfig {
        public String recheckAfter;
        public String rescan;
        public boolean triggerOk = true;
        public boolean userDefined;
        public CollectionUpdateType startupType = CollectionUpdateType.never;
        public CollectionUpdateType updateType = CollectionUpdateType.never;
        public String deleteAfter;

        public UpdateConfig() {
        }

        public UpdateConfig(String startupS, String rewriteS, String recheckAfter, String rescan, String triggerS, String deleteAfter) {
            this.rescan = rescan;
            if (recheckAfter != null) {
                this.recheckAfter = recheckAfter;
            }
            if (rescan != null) {
                this.recheckAfter = null;
            }
            this.deleteAfter = deleteAfter;
            if (triggerS != null) {
                this.triggerOk = triggerS.equalsIgnoreCase("allow");
            }
            if (rewriteS == null) {
                rewriteS = startupS;
            }
            if (rewriteS != null) {
                if ((rewriteS = rewriteS.toLowerCase()).equalsIgnoreCase("true")) {
                    this.updateType = CollectionUpdateType.test;
                } else {
                    try {
                        this.updateType = CollectionUpdateType.valueOf(rewriteS);
                    }
                    catch (Throwable t2) {
                        log.error("Bad updateType= {}", (Object)rewriteS);
                    }
                }
                this.userDefined = true;
            }
        }

        public String toString() {
            return "UpdateConfig{userDefined=" + this.userDefined + ", recheckAfter='" + this.recheckAfter + '\'' + ", rescan='" + this.rescan + '\'' + ", triggerOk=" + this.triggerOk + ", updateType=" + (Object)((Object)this.updateType) + '}';
        }
    }

    public static enum PartitionType {
        none,
        directory,
        file,
        timePeriod,
        all;

    }

    public static enum GribDatasetType {
        TwoD,
        Best,
        Analysis,
        Files,
        Latest,
        LatestFile;

    }

    public static enum PointDatasetType {
        cdmrFeature,
        Files;

    }

    public static enum FmrcDatasetType {
        TwoD,
        Best,
        Files,
        Runs,
        ConstantForecasts,
        ConstantOffsets;

    }

    public static enum ProtoChoice {
        First,
        Random,
        Latest,
        Penultimate,
        Run;

    }
}

