/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.Indent;

public final class StructureMembers {
    private String name;
    private Map<String, Member> memberHash;
    private List<Member> members;
    private int structureSize = -1;

    public StructureMembers(String name) {
        this.name = name;
        this.members = new ArrayList<Member>();
    }

    public StructureMembers(StructureMembers from) {
        this.name = from.name;
        this.members = new ArrayList<Member>(from.getMembers().size());
        for (Member m4 : from.members) {
            Member nm = new Member(m4);
            this.addMember(nm);
            if (m4.members == null) continue;
            nm.members = new StructureMembers(m4.members);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addMember(Member m4) {
        this.members.add(m4);
        if (this.memberHash != null) {
            this.memberHash.put(m4.getName(), m4);
        }
    }

    public void addMember(int pos, Member m4) {
        this.members.add(pos, m4);
        if (this.memberHash != null) {
            this.memberHash.put(m4.getName(), m4);
        }
    }

    public Member addMember(String name, String desc, String units, DataType dtype, int[] shape) {
        Member m4 = new Member(name, desc, units, dtype, shape);
        this.addMember(m4);
        return m4;
    }

    public int hideMember(Member m4) {
        if (m4 == null) {
            return -1;
        }
        int index = this.members.indexOf(m4);
        this.members.remove(m4);
        if (this.memberHash != null) {
            this.memberHash.remove(m4.getName());
        }
        return index;
    }

    public int getStructureSize() {
        if (this.structureSize < 0) {
            this.calcStructureSize();
        }
        return this.structureSize;
    }

    private void calcStructureSize() {
        this.structureSize = 0;
        for (Member member : this.members) {
            this.structureSize += member.getSizeBytes();
        }
    }

    public void setStructureSize(int structureSize) {
        this.structureSize = structureSize;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        ArrayList<String> memberNames = new ArrayList<String>();
        for (Member m4 : this.members) {
            memberNames.add(m4.getName());
        }
        return memberNames;
    }

    public Member getMember(int index) {
        return this.members.get(index);
    }

    public Member findMember(String memberName) {
        if (memberName == null) {
            return null;
        }
        if (this.memberHash == null) {
            int initial_capacity = (int)((double)this.members.size() / 0.75) + 1;
            this.memberHash = new HashMap<String, Member>(initial_capacity);
            for (Member m4 : this.members) {
                this.memberHash.put(m4.getName(), m4);
            }
        }
        return this.memberHash.get(memberName);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("members", this.members).add("structureSize", this.structureSize).toString();
    }

    public final class Member {
        private String name;
        private String desc;
        private String units;
        private DataType dtype;
        private int size = 1;
        private int[] shape;
        private StructureMembers members;
        private boolean isVariableLength;
        private Array dataArray;
        private Object dataObject;
        private int dataParam;

        public Member(String name, String desc, String units, DataType dtype, int[] shape) {
            this.name = Objects.requireNonNull(name);
            this.desc = desc;
            this.units = units;
            this.dtype = Objects.requireNonNull(dtype);
            this.setShape(shape);
        }

        public Member(Member from) {
            this.name = from.name;
            this.desc = from.desc;
            this.units = from.units;
            this.dtype = from.dtype;
            this.setStructureMembers(from.members);
            this.setShape(from.shape);
        }

        public void setStructureMembers(StructureMembers members) {
            if (members == StructureMembers.this) {
                throw new IllegalArgumentException(String.format("%s is already the parent of this Member '%s'; it cannot also be the child.", members, this));
            }
            this.members = members;
        }

        public StructureMembers getStructureMembers() {
            return this.members;
        }

        public void setShape(int[] shape) {
            this.shape = Objects.requireNonNull(shape);
            this.size = (int)Index.computeSize(shape);
            this.isVariableLength = shape.length > 0 && shape[shape.length - 1] < 0;
        }

        public String getName() {
            return this.name;
        }

        public String getFullNameEscaped() {
            return NetcdfFile.makeValidPathName(StructureMembers.this.getName()) + "." + NetcdfFile.makeValidPathName(this.name);
        }

        public String getFullName() {
            return StructureMembers.this.getName() + "." + this.name;
        }

        public String getUnitsString() {
            return this.units;
        }

        public String getDescription() {
            return this.desc;
        }

        public DataType getDataType() {
            return this.dtype;
        }

        public int[] getShape() {
            return this.shape;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isVariableLength() {
            return this.isVariableLength;
        }

        public int getSizeBytes() {
            if (this.getDataType() == DataType.SEQUENCE) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRING) {
                return this.getDataType().getSize();
            }
            if (this.getDataType() == DataType.STRUCTURE) {
                return this.size * this.members.getStructureSize();
            }
            return this.size * this.getDataType().getSize();
        }

        public boolean isScalar() {
            return this.size == 1;
        }

        public int getDataParam() {
            return this.dataParam;
        }

        public void setDataParam(int dataParam) {
            this.dataParam = dataParam;
        }

        public Array getDataArray() {
            return this.dataArray;
        }

        public void setDataArray(Array data) {
            this.dataArray = data;
        }

        public Object getDataObject() {
            return this.dataObject;
        }

        public void setDataObject(Object o) {
            this.dataObject = o;
        }

        public void setVariableInfo(String vname, String desc, String unitString, DataType dtype) {
            if (!this.name.equals(vname) && StructureMembers.this.memberHash != null) {
                StructureMembers.this.memberHash.remove(this.name);
                StructureMembers.this.memberHash.put(vname, this);
            }
            this.name = vname;
            if (dtype != null) {
                this.dtype = dtype;
            }
            if (unitString != null) {
                this.units = unitString;
            }
            if (desc != null) {
                this.desc = desc;
            }
        }

        public void showInternal(Formatter f, Indent indent) {
            f.format("%sname='%s' desc='%s' units='%s' dtype=%s size=%d dataObject=%s dataParam=%d", new Object[]{indent, this.name, this.desc, this.units, this.dtype, this.size, this.dataObject, this.dataParam});
            if (this.members != null) {
                indent.incr();
                f.format("%n%sNested members %s%n", indent, this.members.getName());
                for (Member m4 : this.members.getMembers()) {
                    m4.showInternal(f, indent);
                }
                indent.decr();
            }
            f.format("%n", new Object[0]);
        }

        public String toString() {
            return this.name;
        }
    }
}

