/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureBBsection;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class NcStreamIosp
extends AbstractIOServiceProvider {
    private static Logger logger = LoggerFactory.getLogger(NcStreamIosp.class);
    private static final boolean debug = false;
    private int version;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            return false;
        }
        byte[] b = new byte[4];
        raf.readFully(b);
        return this.test(b, NcStream.MAGIC_HEADER) || this.test(b, NcStream.MAGIC_DATA);
    }

    @Override
    public String getFileTypeId() {
        return "ncstream";
    }

    @Override
    public String getFileTypeDescription() {
        return "netCDF streaming protocol";
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isBuilder() {
        return true;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.openDebug(raf, ncfile, null);
    }

    @Override
    public void build(RandomAccessFile raf, Group.Builder rootGroup, CancelTask cancelTask) throws IOException {
        super.open(raf, rootGroup.getNcfile(), cancelTask);
        this.openDebugNew(raf, rootGroup, null);
    }

    @Override
    public Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        List storage = (List)v.getSPobject();
        ByteBuffer result = null;
        for (DataStorage dataStorage : storage) {
            if (dataStorage.isVlen) {
                return this.readVlenData(v, section, dataStorage);
            }
            if (dataStorage.sdata != null) {
                assert (v instanceof Structure);
                return this.readStructureData((Structure)v, section, dataStorage);
            }
            if (!dataStorage.section.intersects(section)) continue;
            this.raf.seek(dataStorage.filePos);
            byte[] data = new byte[dataStorage.size];
            this.raf.readFully(data);
            if (dataStorage.isDeflate) {
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                InflaterInputStream in = new InflaterInputStream(bin);
                ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length * 7);
                IO.copy(in, bout);
                byte[] resultb = bout.toByteArray();
                result = ByteBuffer.wrap(resultb);
                result.order(dataStorage.bo);
                continue;
            }
            result = ByteBuffer.wrap(data);
            result.order(dataStorage.bo);
        }
        if (result == null) {
            return null;
        }
        return Array.factory(v.getDataType(), v.getShape(), result);
    }

    private Array readStructureData(Structure v, Section section, DataStorage dataStorage) {
        ByteBuffer bb = dataStorage.sdata.getData().asReadOnlyByteBuffer();
        bb.order(dataStorage.bo);
        StructureMembers sm = v.makeStructureMembers();
        ArrayStructureBB.setOffsets(sm);
        ArrayStructureBB all = new ArrayStructureBB(sm, v.getShape(), bb, 0);
        return ArrayStructureBBsection.factory(all, section);
    }

    private Array readVlenData(Variable v, Section section, DataStorage dataStorage) throws IOException {
        this.raf.seek(dataStorage.filePos);
        int nelems = this.readVInt(this.raf);
        Array[] result = new Array[nelems];
        for (int elem = 0; elem < nelems; ++elem) {
            Array dataArray;
            int dsize = this.readVInt(this.raf);
            byte[] data = new byte[dsize];
            this.raf.readFully(data);
            result[elem] = dataArray = Array.factory(v.getDataType(), (int[])null, ByteBuffer.wrap(data));
        }
        return Array.makeVlenArray(new int[]{nelems}, result);
    }

    private int readVInt(RandomAccessFile raf) throws IOException {
        byte b = (byte)raf.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)raf.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    private boolean readAndTest(RandomAccessFile raf, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        raf.readFully(b);
        return this.test(b, test);
    }

    private boolean test(byte[] bread, byte[] test) {
        if (bread.length != test.length) {
            return false;
        }
        for (int i = 0; i < bread.length; ++i) {
            if (bread[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    public void openDebug(RandomAccessFile raf, NetcdfFile ncfile, List<NcsMess> messages) throws IOException {
        raf.seek(0L);
        long pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            if (messages != null) {
                messages.add(new NcsMess(pos, 0, "MAGIC_START missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + raf.getLocation());
        }
        if (messages != null) {
            messages.add(new NcsMess(pos, 4, "MAGIC_START"));
        }
        pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_HEADER)) {
            if (messages != null) {
                messages.add(new NcsMess(pos, 0, "MAGIC_HEADER missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + ncfile.getLocation());
        }
        if (messages != null) {
            messages.add(new NcsMess(pos, 4, "MAGIC_HEADER"));
        }
        pos = raf.getFilePointer();
        int msize = this.readVInt(raf);
        byte[] m4 = new byte[msize];
        raf.readFully(m4);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m4);
        if (messages != null) {
            messages.add(new NcsMess(pos, msize, proto));
        }
        this.version = proto.getVersion();
        NcStreamProto.Group root = proto.getRoot();
        Group.Builder rootBuilder = Group.builder(null).setNcfile(ncfile).setName("");
        NcStream.readGroup(root, rootBuilder);
        ncfile.setRootGroup(rootBuilder.build(null));
        ncfile.finish();
        while (!raf.isAtEndOfFile()) {
            DataStorage dataStorage;
            ArrayList<DataStorage> storage;
            byte[] dp;
            pos = raf.getFilePointer();
            byte[] b = new byte[4];
            raf.readFully(b);
            if (this.test(b, NcStream.MAGIC_END)) {
                if (messages == null) break;
                messages.add(new NcsMess(pos, 4, "MAGIC_END"));
                break;
            }
            if (this.test(b, NcStream.MAGIC_ERR)) {
                int esize = this.readVInt(raf);
                dp = new byte[esize];
                raf.readFully(dp);
                NcStreamProto.Error error = NcStreamProto.Error.parseFrom(dp);
                if (messages == null) break;
                messages.add(new NcsMess(pos, esize, error.getMessage()));
                break;
            }
            if (!this.test(b, NcStream.MAGIC_DATA)) {
                if (messages == null) break;
                messages.add(new NcsMess(pos, 4, "MAGIC_DATA missing - abort"));
                break;
            }
            if (messages != null) {
                messages.add(new NcsMess(pos, 4, "MAGIC_DATA"));
            }
            pos = raf.getFilePointer();
            int psize = this.readVInt(raf);
            dp = new byte[psize];
            raf.readFully(dp);
            NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
            ByteOrder bo = NcStream.decodeDataByteOrder(dproto);
            Variable v = ncfile.findVariable(dproto.getVarName());
            if (v == null) {
                logger.warn(" ERR cant find var {} {}", (Object)dproto.getVarName(), (Object)dproto);
            }
            if (messages != null) {
                messages.add(new NcsMess(pos, psize, dproto));
            }
            if (v != null) {
                storage = (ArrayList<DataStorage>)v.getSPobject();
                if (storage == null) {
                    storage = new ArrayList();
                    v.setSPobject(storage);
                }
            } else {
                storage = new ArrayList<DataStorage>();
            }
            if (dproto.getDataType() == NcStreamProto.DataType.STRUCTURE) {
                pos = raf.getFilePointer();
                msize = this.readVInt(raf);
                m4 = new byte[msize];
                raf.readFully(m4);
                NcStreamProto.StructureData sdata = NcStreamProto.StructureData.parseFrom(m4);
                dataStorage = new DataStorage(msize, pos, dproto);
                dataStorage.sdata = sdata;
                if (messages != null) {
                    messages.add(new NcsMess(dataStorage.filePos, msize, sdata));
                }
                storage.add(dataStorage);
                continue;
            }
            if (dproto.getVdata()) {
                DataStorage dataStorage2 = new DataStorage(0, raf.getFilePointer(), dproto);
                int nelems = this.readVInt(raf);
                int totalSize = 0;
                for (int i = 0; i < nelems; ++i) {
                    int dsize = this.readVInt(raf);
                    totalSize += dsize;
                    raf.skipBytes(dsize);
                }
                dataStorage2.nelems = nelems;
                dataStorage2.size = totalSize;
                if (messages != null) {
                    messages.add(new NcsMess(dataStorage2.filePos, totalSize, dataStorage2));
                }
                storage.add(dataStorage2);
                continue;
            }
            int dsize = this.readVInt(raf);
            dataStorage = new DataStorage(dsize, raf.getFilePointer(), dproto);
            if (messages != null) {
                messages.add(new NcsMess(dataStorage.filePos, dsize, dataStorage));
            }
            storage.add(dataStorage);
            raf.skipBytes(dsize);
        }
    }

    private void openDebugNew(RandomAccessFile raf, Group.Builder rootBuilder, List<NcsMess> messages) throws IOException {
        raf.seek(0L);
        long pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            if (messages != null) {
                messages.add(new NcsMess(pos, 0, "MAGIC_START missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + raf.getLocation());
        }
        if (messages != null) {
            messages.add(new NcsMess(pos, 4, "MAGIC_START"));
        }
        pos = raf.getFilePointer();
        if (!this.readAndTest(raf, NcStream.MAGIC_HEADER)) {
            if (messages != null) {
                messages.add(new NcsMess(pos, 0, "MAGIC_HEADER missing - abort"));
                return;
            }
            throw new IOException("Data corrupted on " + raf.getLocation());
        }
        if (messages != null) {
            messages.add(new NcsMess(pos, 4, "MAGIC_HEADER"));
        }
        pos = raf.getFilePointer();
        int msize = this.readVInt(raf);
        byte[] m4 = new byte[msize];
        raf.readFully(m4);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m4);
        if (messages != null) {
            messages.add(new NcsMess(pos, msize, proto));
        }
        this.version = proto.getVersion();
        NcStreamProto.Group root = proto.getRoot();
        NcStream.readGroup(root, rootBuilder);
        while (!raf.isAtEndOfFile()) {
            DataStorage dataStorage;
            ArrayList<DataStorage> storage;
            byte[] dp;
            pos = raf.getFilePointer();
            byte[] b = new byte[4];
            raf.readFully(b);
            if (this.test(b, NcStream.MAGIC_END)) {
                if (messages == null) break;
                messages.add(new NcsMess(pos, 4, "MAGIC_END"));
                break;
            }
            if (this.test(b, NcStream.MAGIC_ERR)) {
                int esize = this.readVInt(raf);
                dp = new byte[esize];
                raf.readFully(dp);
                NcStreamProto.Error error = NcStreamProto.Error.parseFrom(dp);
                if (messages == null) break;
                messages.add(new NcsMess(pos, esize, error.getMessage()));
                break;
            }
            if (!this.test(b, NcStream.MAGIC_DATA)) {
                if (messages == null) break;
                messages.add(new NcsMess(pos, 4, "MAGIC_DATA missing - abort"));
                break;
            }
            if (messages != null) {
                messages.add(new NcsMess(pos, 4, "MAGIC_DATA"));
            }
            pos = raf.getFilePointer();
            int psize = this.readVInt(raf);
            dp = new byte[psize];
            raf.readFully(dp);
            NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
            ByteOrder bo = NcStream.decodeDataByteOrder(dproto);
            Optional<Variable.Builder<?>> vbopt = rootBuilder.findVariable(dproto.getVarName());
            if (!vbopt.isPresent()) {
                logger.warn(" ERR cant find var {} {}", (Object)dproto.getVarName(), (Object)dproto);
                storage = new ArrayList<DataStorage>();
            } else {
                Variable.Builder<?> vb = vbopt.get();
                storage = (ArrayList<DataStorage>)vb.spiObject;
                if (storage == null) {
                    storage = new ArrayList();
                    vb.setSPobject(storage);
                }
            }
            if (messages != null) {
                messages.add(new NcsMess(pos, psize, dproto));
            }
            if (dproto.getDataType() == NcStreamProto.DataType.STRUCTURE) {
                pos = raf.getFilePointer();
                msize = this.readVInt(raf);
                m4 = new byte[msize];
                raf.readFully(m4);
                NcStreamProto.StructureData sdata = NcStreamProto.StructureData.parseFrom(m4);
                dataStorage = new DataStorage(msize, pos, dproto);
                dataStorage.sdata = sdata;
                if (messages != null) {
                    messages.add(new NcsMess(dataStorage.filePos, msize, sdata));
                }
                storage.add(dataStorage);
                continue;
            }
            if (dproto.getVdata()) {
                DataStorage dataStorage2 = new DataStorage(0, raf.getFilePointer(), dproto);
                int nelems = this.readVInt(raf);
                int totalSize = 0;
                for (int i = 0; i < nelems; ++i) {
                    int dsize = this.readVInt(raf);
                    totalSize += dsize;
                    raf.skipBytes(dsize);
                }
                dataStorage2.nelems = nelems;
                dataStorage2.size = totalSize;
                if (messages != null) {
                    messages.add(new NcsMess(dataStorage2.filePos, totalSize, dataStorage2));
                }
                storage.add(dataStorage2);
                continue;
            }
            int dsize = this.readVInt(raf);
            dataStorage = new DataStorage(dsize, raf.getFilePointer(), dproto);
            if (messages != null) {
                messages.add(new NcsMess(dataStorage.filePos, dsize, dataStorage));
            }
            storage.add(dataStorage);
            raf.skipBytes(dsize);
        }
    }

    public class NcsMess {
        public long filePos;
        public int len;
        public int nelems;
        public Object what;
        public DataType dataType;
        public String varName;

        NcsMess(long filePos, int len, Object what) {
            this.filePos = filePos;
            this.len = len;
            this.what = what;
            if (what instanceof NcStreamProto.Data) {
                NcStreamProto.Data dataMess = (NcStreamProto.Data)what;
                this.dataType = NcStream.convertDataType(dataMess.getDataType());
                this.varName = dataMess.getVarName();
                Section s2 = NcStream.decodeSection(dataMess.getSection());
                if (s2 != null) {
                    this.nelems = (int)s2.computeSize();
                }
            } else if (what instanceof DataStorage) {
                this.nelems = ((DataStorage)what).nelems;
            }
        }

        public String showDeflate() {
            if (!(this.what instanceof DataStorage)) {
                return "Must select a NcStreamIosp.DataStorage object";
            }
            Formatter f = new Formatter();
            try {
                DataStorage dataStorage = (DataStorage)this.what;
                NcStreamIosp.this.raf.seek(dataStorage.filePos);
                byte[] data = new byte[dataStorage.size];
                NcStreamIosp.this.raf.readFully(data);
                ByteArrayInputStream bin = new ByteArrayInputStream(data);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                DeflaterOutputStream dout = new DeflaterOutputStream(bout);
                IO.copy(bin, dout);
                dout.close();
                int deflatedSize = bout.size();
                float ratio = (float)data.length / (float)deflatedSize;
                f.format("Original size = %d bytes, deflated = %d bytes ratio = %f %n", data.length, deflatedSize, Float.valueOf(ratio));
                return f.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                return e.getMessage();
            }
        }
    }

    private static class DataStorage {
        int size;
        long filePos;
        Section section;
        boolean isVlen;
        boolean isDeflate;
        ByteOrder bo;
        int nelems;
        int uncompressedLen;
        NcStreamProto.StructureData sdata;

        DataStorage(int size, long filePos, NcStreamProto.Data dproto) {
            this.size = size;
            this.filePos = filePos;
            this.section = NcStream.decodeSection(dproto.getSection());
            this.nelems = (int)this.section.computeSize();
            this.bo = NcStream.decodeDataByteOrder(dproto);
            this.isVlen = dproto.getVdata();
            boolean bl = this.isDeflate = dproto.getCompress() == NcStreamProto.Compress.DEFLATE;
            if (this.isDeflate) {
                this.uncompressedLen = dproto.getUncompressedSize();
            }
        }

        public String toString() {
            return "size=" + this.size + ", filePos=" + this.filePos + ", section=" + this.section + ", nelems=" + this.nelems + ", isVlen=" + this.isVlen + ", isDeflate=" + this.isDeflate;
        }
    }
}

