/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import loci.common.services.ServiceFactory;
import loci.formats.FormatTools;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.tests.testng.TestTools;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class Jpeg2000GrindTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jpeg2000GrindTest.class);
    public static final String PIXEL_TYPE = "uint16";
    public static final int SIZE_X = 5000;
    public static final int SIZE_Y = 4000;
    public static final int SIZE_Z = 1;
    public static final int SIZE_C = 3;
    public static final int SIZE_T = 1;
    public static final int TILE_WIDTH = 256;
    public static final int TILE_HEIGHT = 256;
    public static final int THREAD_POOL_SIZE = 2;
    private int bytesPerPixel;
    private Map<Integer, String> hashDigests = new HashMap<Integer, String>();
    private TiffWriter writer;
    private File id;
    private Map<Integer, IFD> ifds = new HashMap<Integer, IFD>();
    private int lastIFD;
    private ExecutorService pool;

    private void initializeWriter(String output, String compression, boolean bigTiff) throws Exception {
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        OMEXMLMetadata metadata = service.createOMEXMLMetadata();
        metadata.setImageID("Image:0", 0);
        metadata.setPixelsID("Pixels:0", 0);
        metadata.setPixelsBinDataBigEndian(Boolean.valueOf(true), 0, 0);
        metadata.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
        metadata.setPixelsType(PixelType.fromString((String)PIXEL_TYPE), 0);
        metadata.setPixelsSizeX(new PositiveInteger(Integer.valueOf(5000)), 0);
        metadata.setPixelsSizeY(new PositiveInteger(Integer.valueOf(4000)), 0);
        metadata.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), 0);
        metadata.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
        metadata.setPixelsSizeT(new PositiveInteger(Integer.valueOf(3)), 0);
        metadata.setChannelID("Channel:0", 0, 0);
        metadata.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, 0);
        this.writer = new TiffWriter();
        this.writer.setMetadataRetrieve((MetadataRetrieve)metadata);
        this.writer.setCompression(compression);
        this.writer.setWriteSequentially(false);
        this.writer.setInterleaved(true);
        this.writer.setBigTiff(bigTiff);
        this.writer.setId(output);
        this.bytesPerPixel = FormatTools.getBytesPerPixel((String)PIXEL_TYPE);
    }

    @BeforeClass
    public void setup() throws Exception {
        this.id = File.createTempFile(Jpeg2000GrindTest.class.getName(), ".tif");
        this.initializeWriter(this.id.getAbsolutePath(), TiffCompression.JPEG_2000.getCodecName(), false);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.writer.close();
        this.id.delete();
    }

    @Test(enabled=true)
    public void testPyramidWriteTiles() throws Exception {
        this.pool = Executors.newFixedThreadPool(2);
        short tileCount = (short)TestTools.forEachTile(new TestTools.TileLoopIteration(){

            @Override
            public void run(int z, int c, int t, int x, int y, int tileWidth, int tileHeight, int tileCount) {
                int planeNumber = FormatTools.getIndex((String)"XYZCT", (int)1, (int)3, (int)1, (int)3, (int)z, (int)c, (int)t);
                if (planeNumber != Jpeg2000GrindTest.this.lastIFD) {
                    Jpeg2000GrindTest.this.pool.shutdown();
                    try {
                        while (!Jpeg2000GrindTest.this.pool.awaitTermination(30L, TimeUnit.SECONDS)) {
                            LOGGER.warn("Waiting for runnables to complete...");
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Caught interuption while waiting for termination.");
                    }
                    Jpeg2000GrindTest.this.pool = Executors.newFixedThreadPool(2);
                    Jpeg2000GrindTest.this.lastIFD = planeNumber;
                }
                Jpeg2000GrindTest.this.pool.submit(new TileRunnable(Jpeg2000GrindTest.this.writer, z, c, t, x, y, tileWidth, tileHeight, tileCount));
            }
        }, 5000, 4000, 1, 3, 1, 256, 256);
        this.pool.shutdown();
        while (!this.pool.awaitTermination(30L, TimeUnit.SECONDS)) {
            LOGGER.warn("Waiting for runnables to complete...");
        }
        Assert.assertEquals((int)tileCount, (int)960);
        this.writer.close();
    }

    @Test(dependsOnMethods={"testPyramidWriteTiles"}, enabled=true)
    public void testPyramidReadTilesMultiThreaded() throws Exception {
        this.pool = Executors.newFixedThreadPool(2);
        for (int theC = 0; theC < 3; ++theC) {
            this.pool.execute(new ChannelRunnable(theC));
        }
        this.pool.shutdown();
        while (!this.pool.awaitTermination(30L, TimeUnit.SECONDS)) {
            LOGGER.warn("Waiting for channel runnables to complete...");
        }
    }

    class ChannelRunnable
    implements Runnable {
        private int theC;

        public ChannelRunnable(int theC) {
            this.theC = theC;
        }

        @Override
        public void run() {
            final TiffReader reader = new TiffReader();
            try {
                reader.setId(Jpeg2000GrindTest.this.id.getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((int)reader.getImageCount(), (int)3);
            Assert.assertEquals((int)reader.getSeriesCount(), (int)6);
            short tileCount = (short)TestTools.forEachTile(new TestTools.TileLoopIteration(){

                @Override
                public void run(int z, int c, int t, int x, int y, int tileWidth, int tileHeight, int tileCount) {
                    try {
                        tileCount += ChannelRunnable.this.theC * 320;
                        int planeNumber = FormatTools.getIndex((String)"XYZCT", (int)1, (int)3, (int)1, (int)3, (int)z, (int)ChannelRunnable.this.theC, (int)t);
                        byte[] tile = null;
                        try {
                            tile = reader.openBytes(planeNumber, x, y, tileWidth, tileHeight);
                        }
                        catch (Throwable throwable) {
                            Assert.fail((String)String.format("Failure reading tile z:%d c:%d t:%d x:%d y:%d", z, ChannelRunnable.this.theC, t, x, y), (Throwable)throwable);
                        }
                        String readDigest = TestTools.md5(tile);
                        String writtenDigest = (String)Jpeg2000GrindTest.this.hashDigests.get(tileCount);
                        if (!writtenDigest.equals(readDigest)) {
                            Assert.fail((String)String.format("Hash digest mismatch z:%d c:%d t:%d x:%d y:%d -- %s != %s", z, ChannelRunnable.this.theC, t, x, y, writtenDigest, readDigest));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, 5000, 4000, 1, 1, 1, 256, 256);
            Assert.assertEquals((int)tileCount, (int)320);
        }
    }

    class TileRunnable
    implements Runnable {
        private int tileNumber;
        private TiffWriter writer;
        private int z;
        private int c;
        private int t;
        private int x;
        private int y;
        private int tileWidth;
        private int tileHeight;

        public TileRunnable(TiffWriter writer, int z, int c, int t, int x, int y, int tileWidth, int tileHeight, int tileNumber) {
            this.z = z;
            this.c = c;
            this.t = t;
            this.x = x;
            this.y = y;
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            this.writer = writer;
            this.tileNumber = tileNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IFD ifd;
            byte[] tile = new byte[this.tileWidth * this.tileHeight * Jpeg2000GrindTest.this.bytesPerPixel];
            ByteBuffer.wrap(tile).asShortBuffer().put(0, (short)this.tileNumber);
            Jpeg2000GrindTest.this.hashDigests.put(this.tileNumber, TestTools.md5(tile));
            int planeNumber = FormatTools.getIndex((String)"XYZCT", (int)1, (int)3, (int)1, (int)3, (int)this.z, (int)this.c, (int)this.t);
            Map map = Jpeg2000GrindTest.this.ifds;
            synchronized (map) {
                if (!Jpeg2000GrindTest.this.ifds.containsKey(planeNumber)) {
                    ifd = new IFD();
                    ifd.put((Object)322, (Object)256);
                    ifd.put((Object)323, (Object)256);
                    Jpeg2000GrindTest.this.ifds.put(planeNumber, ifd);
                }
                ifd = (IFD)Jpeg2000GrindTest.this.ifds.get(planeNumber);
            }
            try {
                this.writer.saveBytes(planeNumber, tile, ifd, this.x, this.y, this.tileWidth, this.tileHeight);
            }
            catch (Exception e) {
                LOGGER.error("Exception while writing tile", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

