/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ImageReader;
import loci.tests.testng.Configuration;
import loci.tests.testng.ConfigurationTree;
import org.kohsuke.file_leak_detector.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestTools.class);
    public static final String DIVIDER = "----------------------------------------";
    public static final String baseConfigName = ".bioformats";

    public static String getProperty(String key) {
        String value = System.getProperty(key);
        if (value == null || value.equals("${" + key + "}")) {
            return null;
        }
        return value;
    }

    public static String sha1(byte[] b, int offset, int len) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.reset();
            md.update(b, offset, len);
            byte[] digest = md.digest();
            return DataTools.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String sha1(byte[] b) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.reset();
            md.update(b);
            byte[] digest = md.digest();
            return DataTools.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String md5(byte[] b, int sizeX, int sizeY, int posX, int posY, int width, int height, int bpp) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            int offset = 0;
            for (int i = 0; i < height; ++i) {
                offset = ((posY + i) * sizeX + posX) * bpp;
                md.update(b, offset, width * bpp);
            }
            byte[] digest = md.digest();
            return DataTools.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String md5(byte[] b, int offset, int len) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(b, offset, len);
            byte[] digest = md.digest();
            return DataTools.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String md5(byte[] b) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(b);
            byte[] digest = md.digest();
            return DataTools.bytesToHex((byte[])digest);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static int getThreadCount() {
        int threadCount = 1;
        try {
            threadCount = Integer.parseInt(System.getProperty("testng.threadCount"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return threadCount;
    }

    public static boolean canFitInMemory(long bufferSize) {
        Runtime r = Runtime.getRuntime();
        long mem = r.maxMemory() - (r.totalMemory() - r.freeMemory());
        mem /= 2L;
        return bufferSize < (mem /= (long)TestTools.getThreadCount()) && bufferSize <= Integer.MAX_VALUE;
    }

    public static long getUsedMemory() {
        Runtime r = Runtime.getRuntime();
        long mem = r.totalMemory() - r.freeMemory();
        return mem >> 20;
    }

    public static String shortClassName(Object o) {
        String name = o.getClass().getName();
        int dot = name.lastIndexOf(".");
        return dot < 0 ? name : name.substring(dot + 1);
    }

    public static boolean isConfigFile(Location file, String configFileSuffix) {
        String filename;
        String configName = baseConfigName;
        if (configFileSuffix.length() > 0) {
            configName = configName + ".";
            configName = configName + configFileSuffix;
        }
        return (filename = file.getName()).equals(configName) || filename.equals(baseConfigName);
    }

    public static void getFiles(String root, List files, ConfigurationTree config, String toplevelConfig) {
        TestTools.getFiles(root, files, config, toplevelConfig, null);
    }

    public static void getFiles(String root, List files, ConfigurationTree config, String toplevelConfig, String[] subdirs) {
        TestTools.getFiles(root, files, config, toplevelConfig, subdirs, "");
    }

    @Deprecated
    public static String getExternalConfigFile(String root, ConfigurationTree config) {
        String configRoot = config.relocateToConfig(root);
        Location configFile = new Location(configRoot, baseConfigName);
        if (configFile.exists()) {
            return configFile.getAbsolutePath();
        }
        return null;
    }

    @Deprecated
    public static String getExternalSymlinkConfigFile(String root, ConfigurationTree config) {
        try {
            String configCanonicalRoot;
            Location configFile;
            String canonicalRoot = new Location(root).getCanonicalPath();
            if (!root.equals(canonicalRoot) && (configFile = new Location(configCanonicalRoot = config.relocateToConfig(canonicalRoot), baseConfigName)).exists()) {
                return configFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void getFiles(String root, List files, ConfigurationTree config, String toplevelConfig, String[] subdirs, String configFileSuffix) {
        TestTools.getFiles(root, files, config, toplevelConfig, subdirs, configFileSuffix, true);
    }

    public static void getFiles(String root, List files, final ConfigurationTree config, String toplevelConfig, String[] subdirs, String configFileSuffix, boolean ignoreDoTest) {
        String configRoot;
        Location configFile;
        Location f = new Location(root);
        Object[] subs = f.list();
        if (subs == null) {
            subs = new String[]{};
        }
        if (subdirs != null) {
            subs = subdirs;
        }
        boolean isToplevel = toplevelConfig != null && new File(toplevelConfig).exists();
        Arrays.sort(subs);
        ArrayList<String> subsList = new ArrayList<String>();
        if (config.getConfigDirectory() != null && (configFile = new Location(configRoot = config.relocateToConfig(root), baseConfigName)).exists()) {
            LOGGER.debug("found config file: {}", (Object)configFile.getAbsolutePath());
            subsList.add(configFile.getAbsolutePath());
        }
        for (int i = 0; i < subs.length; ++i) {
            Location file = new Location(root, (String)subs[i]);
            if (!isToplevel && TestTools.isConfigFile(file, configFileSuffix) || isToplevel && ((String)subs[i]).equals(toplevelConfig)) {
                if (config.getConfigDirectory() == null) continue;
                LOGGER.debug("adding config file: {}", (Object)file.getAbsolutePath());
                subsList.add(0, file.getAbsolutePath());
                continue;
            }
            subsList.add(file.getAbsolutePath());
        }
        LOGGER.debug("\tconfig file");
        try {
            LOGGER.debug("Parsing {}:", subsList.get(0));
            config.parseConfigFile((String)subsList.get(0));
        }
        catch (IOException exc) {
            LOGGER.debug("", (Throwable)exc);
        }
        catch (Throwable exc) {
            // empty catch block
        }
        Arrays.sort(subs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = o1.toString();
                String s2 = o2.toString();
                Configuration c1 = null;
                Configuration c2 = null;
                try {
                    c1 = config.get(s1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    c2 = config.get(s2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (c1 == null && c2 != null) {
                    return 1;
                }
                if (c1 != null && c2 == null) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
        });
        ImageReader typeTester = new ImageReader();
        for (int i = 0; i < subsList.size(); ++i) {
            Location file = new Location((String)subsList.get(i));
            LOGGER.debug("Checking {}:", subsList.get(i));
            if (TestTools.isConfigFile(file, configFileSuffix)) continue;
            if (TestTools.isIgnoredFile((String)subsList.get(i), config, ignoreDoTest)) {
                LOGGER.debug("\tignored");
                continue;
            }
            if (file.isDirectory()) {
                LOGGER.debug("\tdirectory");
                TestTools.getFiles((String)subsList.get(i), files, config, null, null, configFileSuffix, ignoreDoTest);
            } else if (!((String)subsList.get(i)).endsWith("readme.txt") && !((String)subsList.get(i)).endsWith("test_setup.ini")) {
                if (typeTester.isThisType((String)subsList.get(i))) {
                    LOGGER.debug("\tOK");
                } else {
                    LOGGER.debug("\tunknown type");
                }
                files.add(file.getAbsolutePath());
            }
            file = null;
        }
    }

    public static void parseConfigFiles(String dir, ConfigurationTree config) {
        String[] files;
        Location root = new Location(dir);
        for (String file : files = root.list()) {
            Location check = new Location(root, file);
            if (check.isDirectory()) {
                TestTools.parseConfigFiles(check.getAbsolutePath(), config);
                continue;
            }
            if (!TestTools.isConfigFile(check, "")) continue;
            try {
                config.parseConfigFile(check.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.warn("Failed to parse config {}", (Object)check, (Object)e);
            }
        }
    }

    public static boolean isIgnoredFile(String file, ConfigurationTree config) {
        return TestTools.isIgnoredFile(file, config, true);
    }

    public static boolean isIgnoredFile(String file, ConfigurationTree config, boolean ignoreDoTest) {
        if (file.indexOf(File.separator + ".") >= 0) {
            return true;
        }
        try {
            Configuration c = config.get(file);
            if (c == null) {
                return false;
            }
            if (ignoreDoTest && !c.doTest()) {
                return true;
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.endsWith(".oif.files");
    }

    public static int forEachTile(TileLoopIteration iteration, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int tileWidth, int tileHeight) {
        int tileCount = 0;
        for (int t = 0; t < sizeT; ++t) {
            for (int c = 0; c < sizeC; ++c) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int tileOffsetY = 0; tileOffsetY < (sizeY + tileHeight - 1) / tileHeight; ++tileOffsetY) {
                        for (int tileOffsetX = 0; tileOffsetX < (sizeX + tileWidth - 1) / tileWidth; ++tileOffsetX) {
                            int h;
                            int x = tileOffsetX * tileWidth;
                            int y = tileOffsetY * tileHeight;
                            int w = tileWidth;
                            if (w + x > sizeX) {
                                w = sizeX - x;
                            }
                            if ((h = tileHeight) + y > sizeY) {
                                h = sizeY - y;
                            }
                            iteration.run(z, c, t, x, y, w, h, tileCount);
                            ++tileCount;
                        }
                    }
                }
            }
        }
        return tileCount;
    }

    public static boolean mapFile(String id) throws IOException {
        RandomAccessInputStream stream = new RandomAccessInputStream(id);
        Runtime rt = Runtime.getRuntime();
        long maxMem = rt.freeMemory();
        long length = stream.length();
        if (length < Integer.MAX_VALUE && length < maxMem) {
            stream.close();
            FileInputStream fis = new FileInputStream(id);
            FileChannel channel = fis.getChannel();
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            ByteArrayHandle handle = new ByteArrayHandle((ByteBuffer)buf);
            Location.mapFile((String)id, (IRandomAccess)handle);
            fis.close();
            return true;
        }
        stream.close();
        return false;
    }

    public static boolean isOutOfMemory(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            return true;
        }
        while (t.getCause() != null) {
            if (t.getCause() instanceof OutOfMemoryError) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }

    public static ArrayList<String> getHandles() throws IOException {
        return TestTools.getHandles(false);
    }

    public static ArrayList<String> getHandles(boolean filter) throws IOException {
        List openHandles = Listener.getCurrentOpenFiles();
        ArrayList<String> names = new ArrayList<String>();
        for (Listener.Record f : openHandles) {
            if (!(f instanceof Listener.FileRecord)) continue;
            String path = ((Listener.FileRecord)f).file.getAbsolutePath();
            if (filter && (path.endsWith("libnio.so") || path.endsWith(".jar") || path.startsWith("/usr/lib") || path.startsWith("/opt/") || path.startsWith("/usr/share/locale") || path.startsWith("/lib") || path.indexOf("turbojpeg") > 0 || path.indexOf("/jre/") > 0 || path.indexOf("nativedata") > 0 || path.indexOf("jhdf") > 0)) continue;
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            names.add(path);
            f.dump("", p);
            LOGGER.debug(sw.toString());
            p.close();
        }
        return names;
    }

    public static interface TileLoopIteration {
        public void run(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

