/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import loci.common.services.DependencyException;
import loci.common.services.S3ClientService;
import loci.common.services.S3ClientServiceException;
import loci.common.services.S3ClientServiceImpl;
import loci.common.services.S3ClientStat;
import loci.common.services.ServiceFactory;
import loci.common.utests.TestUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class S3ClientServiceTest {
    private static boolean runS3RemoteTests;
    private Path TEMPDIR;
    private S3ClientService s3;
    private static final Logger LOGGER;

    @BeforeClass
    public void setup() throws IOException {
        this.TEMPDIR = Files.createTempDirectory("S3ClientServiceTest-", new FileAttribute[0]);
        this.TEMPDIR.toFile().deleteOnExit();
        boolean bl = runS3RemoteTests = TestUtilities.getPropValueInt("testng.runS3RemoteTests") > 0;
        if (!runS3RemoteTests) {
            LOGGER.warn("S3 tests are disabled!");
        }
    }

    @BeforeMethod
    public void setupMethod() throws S3ClientServiceException, SkipException {
        if (!runS3RemoteTests) {
            throw new SkipException("S3 tests are disabled");
        }
        this.s3 = new S3ClientServiceImpl();
        this.s3.initialize("http://localhost", 31836, null, null, "S3ClientServiceTest", "0.0.0");
    }

    @Test
    public void testServiceLookup() throws DependencyException {
        ServiceFactory factory = new ServiceFactory();
        S3ClientService s3client = (S3ClientService)factory.getInstance(S3ClientService.class);
        AssertJUnit.assertTrue((boolean)S3ClientServiceImpl.class.isInstance(s3client));
    }

    @Test
    public void testBucketExists() throws S3ClientServiceException, IOException {
        AssertJUnit.assertTrue((boolean)this.s3.bucketExists("bioformats.test.public"));
    }

    @Test(expectedExceptions={S3ClientServiceException.class})
    public void testBucketNotExists() throws S3ClientServiceException, IOException {
        this.s3.bucketExists("this.bucket.does.not.exist");
    }

    @Test
    public void testStatObject() throws S3ClientServiceException, IOException {
        S3ClientStat stat = this.s3.statObject("bioformats.test.public", "2MBfile.txt");
        AssertJUnit.assertEquals((long)0x200000L, (long)stat.length());
    }

    @Test
    public void testGetObject() throws S3ClientServiceException, IOException {
        InputStream in = this.s3.getObject("bioformats.test.public", "2MBfile.txt", 1380896L);
        String line = new BufferedReader(new InputStreamReader(in)).readLine();
        AssertJUnit.assertEquals((String)".                         43154", (String)line);
        in.close();
    }

    @Test
    public void testGetObjectFile() throws S3ClientServiceException, IOException {
        String filepath = this.TEMPDIR + "/2MBfile.txt";
        this.s3.getObject("bioformats.test.public", "2MBfile.txt", filepath);
        Path path = Paths.get(filepath, new String[0]);
        AssertJUnit.assertEquals((long)0x200000L, (long)Files.size(path));
        String[] lines = (String[])Files.newBufferedReader(path).lines().toArray(String[]::new);
        AssertJUnit.assertEquals((String)".                             1", (String)lines[0]);
        AssertJUnit.assertEquals((String)".                         65536", (String)lines[lines.length - 1]);
    }

    static {
        LOGGER = LoggerFactory.getLogger(S3ClientServiceTest.class);
    }
}

