/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import loci.common.DataTools;
import loci.common.image.SimpleImageScaler;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleImageScalerTest {
    private static final byte[] SOURCE_IMAGE_INTERLEAVED = SimpleImageScalerTest.makeImage(4, 4, 3, 2, true);
    private static final byte[] SOURCE_IMAGE_NON_INTERLEAVED = SimpleImageScalerTest.makeImage(6, 3, 3, 2, false);
    private SimpleImageScaler scaler;

    private static byte[] makeImage(int width, int height, int channels, int bytes, boolean interleaved) {
        byte[] image = new byte[width * height * channels * bytes];
        int v = 0;
        int pos = 0;
        int count = interleaved ? 1 : channels;
        int pixelChannels = interleaved ? channels : 1;
        for (int c = 0; c < count; ++c) {
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    for (int p = 0; p < pixelChannels; ++p) {
                        DataTools.unpackBytes((long)v, (byte[])image, (int)pos, (int)bytes, (boolean)false);
                        ++v;
                        pos += bytes;
                    }
                }
            }
        }
        return image;
    }

    @BeforeMethod
    public void setUp() {
        this.scaler = new SimpleImageScaler();
    }

    @Test
    public void testDownsampleInterleaved() {
        byte[] downsample = this.scaler.downsample(SOURCE_IMAGE_INTERLEAVED, 4, 4, 2.0, 2, false, false, 3, true);
        AssertJUnit.assertEquals((int)downsample.length, (int)24);
        int[] expectedPixels = new int[]{0, 1, 2, 6, 7, 8, 24, 25, 26, 30, 31, 32};
        for (int i = 0; i < expectedPixels.length; ++i) {
            AssertJUnit.assertEquals((int)expectedPixels[i], (int)DataTools.bytesToInt((byte[])downsample, (int)(i * 2), (int)2, (boolean)false));
        }
    }

    @Test
    public void testDownsampleNonInterleaved() {
        byte[] downsample = this.scaler.downsample(SOURCE_IMAGE_NON_INTERLEAVED, 6, 3, 3.0, 2, false, false, 3, false);
        AssertJUnit.assertEquals((int)downsample.length, (int)12);
        int[] expectedPixels = new int[]{0, 3, 18, 21, 36, 39};
        for (int i = 0; i < expectedPixels.length; ++i) {
            AssertJUnit.assertEquals((int)expectedPixels[i], (int)DataTools.bytesToInt((byte[])downsample, (int)(i * 2), (int)2, (boolean)false));
        }
    }
}

