/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests.providers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import loci.common.IRandomAccess;
import loci.common.ZipHandle;
import loci.common.utests.providers.IRandomAccessProvider;

class ZipHandleProvider
implements IRandomAccessProvider {
    ZipHandleProvider() {
    }

    @Override
    public IRandomAccess createMock(byte[] page, String mode, int bufferSize) throws IOException {
        File pageFile = File.createTempFile("page", ".zip");
        pageFile.deleteOnExit();
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(pageFile));
        out.putNextEntry(new ZipEntry(pageFile.getName()));
        out.write(page);
        out.close();
        return new ZipHandle(pageFile.getAbsolutePath());
    }
}

