/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Comparator;
import loci.common.DataTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.formats.FormatException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class FormatPageAutogen {
    private static final String TEMPLATE = "templates/FormatPage.vm";
    private static final String TABLE_TEMPLATE = "templates/FormatTable.vm";
    private static final String OUTPUT_DIR = System.getProperty("sphinx_builddir");
    private static final String RATINGS = System.getProperty("autogen.ratings");
    private IniList data;

    public FormatPageAutogen() throws FormatException, IOException {
        String file = DataTools.readFile((String)RATINGS);
        IniParser parser = new IniParser();
        parser.setCommentDelimiter(null);
        this.data = parser.parseINI(new BufferedReader(new StringReader(file)));
    }

    public void writeFormatPages() throws Exception {
        boolean success;
        boolean success2;
        File doc = new File(OUTPUT_DIR);
        if (!doc.exists() && !(success2 = doc.mkdir())) {
            throw new IOException("Could not create " + doc.getAbsolutePath());
        }
        File docFormats = new File(doc, "formats/");
        if (!docFormats.exists() && !(success = docFormats.mkdir())) {
            throw new IOException("Could not create " + docFormats.getAbsolutePath());
        }
        VelocityEngine engine = VelocityTools.createEngine();
        for (IniTable table : this.data) {
            String[] page;
            VelocityContext context = VelocityTools.createContext();
            String format = (String)table.get((Object)"header");
            context.put("format", (Object)format);
            if (table.containsKey((Object)"extensions")) {
                context.put("extensions", table.get((Object)"extensions"));
            }
            if (table.containsKey((Object)"indexExtensions")) {
                context.put("indexExtensions", table.get((Object)"indexExtensions"));
            } else if (table.containsKey((Object)"extensions")) {
                context.put("indexExtensions", table.get((Object)"extensions"));
            }
            context.put("owner", table.get((Object)"owner"));
            context.put("developer", table.get((Object)"developer"));
            context.put("bsd", table.get((Object)"bsd"));
            context.put("export", table.get((Object)"export"));
            context.put("pyramid", table.get((Object)"pyramid"));
            if (table.containsKey((Object)"versions")) {
                context.put("versions", table.get((Object)"versions"));
            } else {
                context.put("versions", (Object)"");
            }
            context.put("pixelsRating", table.get((Object)"pixelsRating"));
            context.put("metadataRating", table.get((Object)"metadataRating"));
            context.put("opennessRating", table.get((Object)"opennessRating"));
            context.put("presenceRating", table.get((Object)"presenceRating"));
            context.put("utilityRating", table.get((Object)"utilityRating"));
            context.put("reader", table.get((Object)"reader"));
            context.put("writer", table.get((Object)"writer"));
            context.put("mif", table.get((Object)"mif"));
            context.put("notes", table.get((Object)"notes"));
            context.put("privateSpecification", table.get((Object)"privateSpecification"));
            context.put("options", table.get((Object)"options"));
            context.put("readerextlink", (Object)(((String)table.get((Object)"bsd")).equals("no") ? "bfreader" : "bsd-reader"));
            context.put("writerextlink", (Object)(((String)table.get((Object)"bsd")).equals("no") ? "bfwriter" : "bsd-writer"));
            if (table.containsKey((Object)"developer")) {
                String[] developer = ((String)table.get((Object)"developer")).split("\n");
                context.put("developer", (Object)developer);
            }
            if (table.containsKey((Object)"software")) {
                String[] software = ((String)table.get((Object)"software")).split("\n");
                context.put("software", (Object)software);
            }
            if (table.containsKey((Object)"weHave")) {
                String[] weHave = ((String)table.get((Object)"weHave")).split("\n");
                context.put("weHave", (Object)weHave);
            }
            if (table.containsKey((Object)"weWant")) {
                String[] weWant = ((String)table.get((Object)"weWant")).split("\n");
                context.put("weWant", (Object)weWant);
            }
            if (table.containsKey((Object)"samples")) {
                String[] samples = ((String)table.get((Object)"samples")).split("\n");
                context.put("samples", (Object)samples);
            }
            if (table.containsKey((Object)"notes")) {
                String[] notes = ((String)table.get((Object)"notes")).split("\n");
                context.put("notes", (Object)notes);
            }
            if (table.containsKey((Object)"reader")) {
                String[] reader = ((String)table.get((Object)"reader")).split(", ");
                context.put("reader", (Object)reader);
            }
            String filename = FormatPageAutogen.getPageName(format, (String)table.get((Object)"pagename"));
            if (table.containsKey((Object)"metadataPage")) {
                page = (String[])table.get((Object)"metadataPage");
                if (page.length() > 0) {
                    context.put("metadataPage", (Object)page.split(", "));
                }
            } else {
                page = new String[]{filename.substring(filename.indexOf(File.separator) + 1) + "-metadata"};
                context.put("metadataPage", (Object)page);
            }
            VelocityTools.processTemplate(engine, context, TEMPLATE, OUTPUT_DIR + "/" + filename + ".rst");
        }
    }

    public void writeFormatTable() throws Exception {
        boolean success;
        File doc = new File(OUTPUT_DIR);
        if (!doc.exists() && !(success = doc.mkdir())) {
            throw new IOException("Could not create " + doc.getAbsolutePath());
        }
        VelocityEngine engine = VelocityTools.createEngine();
        VelocityContext context = VelocityTools.createContext();
        IniTable[] sortedTable = new IniTable[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            IniTable table = (IniTable)this.data.get(i);
            table.put((Object)"pagename", (Object)FormatPageAutogen.getPageName((String)table.get((Object)"header"), (String)table.get((Object)"pagename")));
            sortedTable[i] = table;
        }
        Arrays.sort(sortedTable, new Comparator<IniTable>(){

            @Override
            public int compare(IniTable t1, IniTable t2) {
                String page1 = (String)t1.get((Object)"pagename");
                String page2 = (String)t2.get((Object)"pagename");
                return page1.compareTo(page2);
            }
        });
        context.put("formats", (Object)sortedTable);
        context.put("count", (Object)sortedTable.length);
        VelocityTools.processTemplate(engine, context, TABLE_TEMPLATE, OUTPUT_DIR + "/supported-formats.rst");
    }

    protected static String getPageName(String format, String pagename) {
        String realPageName = pagename;
        if (realPageName == null) {
            realPageName = format.replaceAll("/", "");
            realPageName = realPageName.replaceAll("\\(", "");
            realPageName = realPageName.replaceAll("\\)", "");
            realPageName = realPageName.replaceAll("\\.", "");
            realPageName = realPageName.replaceAll("& ", "");
            realPageName = realPageName.replaceAll(" ", "-");
            realPageName = realPageName.toLowerCase();
        }
        realPageName = "formats/" + realPageName;
        return realPageName;
    }

    public static void main(String[] args) throws Exception {
        FormatPageAutogen autogen = new FormatPageAutogen();
        autogen.writeFormatPages();
        autogen.writeFormatTable();
    }
}

