/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import com.bc.zarr.ArrayParams;
import com.bc.zarr.Compressor;
import com.bc.zarr.CompressorFactory;
import com.bc.zarr.DataType;
import com.bc.zarr.ZarrArray;
import com.bc.zarr.ZarrGroup;
import com.bc.zarr.storage.Store;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import loci.common.services.AbstractService;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.S3FileSystemStore;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.ZarrService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;

public class JZarrServiceImpl
extends AbstractService
implements ZarrService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JZarrServiceImpl.class);
    public static final String NO_ZARR_MSG = "JZARR is required to read Zarr files.";
    S3FileSystemStore s3fs;
    ZarrArray zarrArray;
    String currentId;
    Compressor zlibComp = CompressorFactory.create((String)"zlib", (Object[])new Object[]{"level", 8});
    Compressor bloscComp = CompressorFactory.create((String)"blosc", (Object[])new Object[]{"cname", "lz4hc", "clevel", 7});
    Compressor nullComp = CompressorFactory.create((String)"null", (Object[])new Object[0]);

    public JZarrServiceImpl(String root) {
        this.checkClassDependency(ZarrArray.class);
        if (root != null && (root.matches("^https?:.*") || root.matches("^s3:.*"))) {
            this.s3fs = new S3FileSystemStore(Paths.get(root, new String[0]));
        }
    }

    @Override
    public void open(String file) throws IOException, FormatException {
        this.currentId = file;
        this.zarrArray = this.getArray(file);
    }

    public void open(String id, ZarrArray array) {
        this.currentId = id;
        this.zarrArray = array;
    }

    @Override
    public Map<String, Object> getGroupAttr(String path) throws IOException, FormatException {
        return this.getGroup(path).getAttributes();
    }

    @Override
    public Map<String, Object> getArrayAttr(String path) throws IOException, FormatException {
        return this.getArray(path).getAttributes();
    }

    @Override
    public Set<String> getGroupKeys(String path) throws IOException, FormatException {
        return this.getGroup(path).getGroupKeys();
    }

    @Override
    public Set<String> getArrayKeys(String path) throws IOException, FormatException {
        return this.getGroup(path).getArrayKeys();
    }

    public DataType getZarrPixelType(int pixType) {
        DataType pixelType = null;
        switch (pixType) {
            case 0: {
                pixelType = DataType.i1;
                break;
            }
            case 2: {
                pixelType = DataType.i2;
                break;
            }
            case 4: {
                pixelType = DataType.i4;
                break;
            }
            case 1: {
                pixelType = DataType.u1;
                break;
            }
            case 3: {
                pixelType = DataType.u2;
                break;
            }
            case 5: {
                pixelType = DataType.u4;
                break;
            }
            case 6: {
                pixelType = DataType.f4;
                break;
            }
            case 7: {
                pixelType = DataType.f8;
            }
        }
        return pixelType;
    }

    public int getOMEPixelType(DataType pixType) {
        int pixelType = -1;
        switch (pixType) {
            case i1: {
                pixelType = 0;
                break;
            }
            case i2: {
                pixelType = 2;
                break;
            }
            case i4: {
                pixelType = 4;
                break;
            }
            case u1: {
                pixelType = 1;
                break;
            }
            case u2: {
                pixelType = 3;
                break;
            }
            case u4: {
                pixelType = 5;
                break;
            }
            case f4: {
                pixelType = 6;
                break;
            }
            case f8: {
                pixelType = 7;
                break;
            }
            case i8: {
                pixelType = 7;
                break;
            }
        }
        return pixelType;
    }

    @Override
    public String getNoZarrMsg() {
        return NO_ZARR_MSG;
    }

    @Override
    public int[] getShape() {
        if (this.zarrArray != null) {
            return this.zarrArray.getShape();
        }
        return null;
    }

    @Override
    public int[] getChunkSize() {
        if (this.zarrArray != null) {
            return this.zarrArray.getChunks();
        }
        return null;
    }

    @Override
    public int getPixelType() {
        if (this.zarrArray != null) {
            return this.getOMEPixelType(this.zarrArray.getDataType());
        }
        return 0;
    }

    @Override
    public boolean isLittleEndian() {
        if (this.zarrArray != null) {
            return this.zarrArray.getByteOrder().equals(ByteOrder.LITTLE_ENDIAN);
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.zarrArray = null;
        this.currentId = null;
        if (this.s3fs != null) {
            this.s3fs.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.zarrArray != null && this.currentId != null;
    }

    @Override
    public String getID() {
        return this.currentId;
    }

    @Override
    public Object readBytes(int[] shape, int[] offset) throws FormatException, IOException {
        if (this.zarrArray != null) {
            try {
                return this.zarrArray.read(shape, offset);
            }
            catch (InvalidRangeException e) {
                throw new FormatException((Throwable)e);
            }
        }
        throw new IOException("No Zarr file opened");
    }

    @Override
    public void saveBytes(Object data, int[] shape, int[] offset) throws FormatException, IOException {
        if (this.zarrArray != null) {
            try {
                this.zarrArray.write(data, shape, offset);
            }
            catch (InvalidRangeException e) {
                throw new FormatException((Throwable)e);
            }
        } else {
            throw new IOException("No Zarr file opened");
        }
    }

    @Override
    public void create(String file, MetadataRetrieve meta, int[] chunks, ZarrService.Compression compression) throws IOException {
        boolean isLittleEndian;
        int seriesCount = meta.getImageCount();
        int resolutionCount = 1;
        ArrayParams params = new ArrayParams();
        params.chunks(chunks);
        params.compressor(this.nullComp);
        boolean bl = isLittleEndian = meta.getPixelsBigEndian(0) == false;
        if (isLittleEndian) {
            params.byteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        int x = (Integer)meta.getPixelsSizeX(0).getValue();
        int y = (Integer)meta.getPixelsSizeY(0).getValue();
        int z = (Integer)meta.getPixelsSizeZ(0).getValue();
        int c = (Integer)meta.getPixelsSizeC(0).getValue();
        int t = (Integer)meta.getPixelsSizeT(0).getValue();
        int[] shape = new int[]{x, y, z, c, t};
        params.shape(shape);
        int pixelType = FormatTools.pixelTypeFromString((String)meta.getPixelsType(0).toString());
        DataType zarrPixelType = this.getZarrPixelType(pixelType);
        int bytes = FormatTools.getBytesPerPixel((int)pixelType);
        params.dataType(zarrPixelType);
        if (seriesCount > 1) {
            ZarrGroup root;
            ZarrGroup currentGroup = root = ZarrGroup.create((String)file);
            for (int i = 0; i < seriesCount; ++i) {
                x = (Integer)meta.getPixelsSizeX(i).getValue();
                y = (Integer)meta.getPixelsSizeY(i).getValue();
                z = (Integer)meta.getPixelsSizeZ(i).getValue();
                c = (Integer)meta.getPixelsSizeC(i).getValue();
                t = (Integer)meta.getPixelsSizeT(i).getValue();
                shape = new int[]{x, y, z, c, t};
                params.shape(shape);
                pixelType = FormatTools.pixelTypeFromString((String)meta.getPixelsType(i).toString());
                zarrPixelType = this.getZarrPixelType(pixelType);
                params.dataType(zarrPixelType);
                boolean bl2 = isLittleEndian = meta.getPixelsBigEndian(i) == false;
                if (isLittleEndian) {
                    params.byteOrder(ByteOrder.LITTLE_ENDIAN);
                }
                if (meta instanceof IPyramidStore) {
                    resolutionCount = ((IPyramidStore)meta).getResolutionCount(i);
                }
                if (resolutionCount > 1) {
                    currentGroup = root.createSubGroup("Series" + i);
                    for (int j = 0; j < resolutionCount; ++j) {
                        this.zarrArray = currentGroup.createArray("Resolution" + j, params);
                    }
                    continue;
                }
                this.zarrArray = currentGroup.createArray("Series" + i, params);
            }
        } else {
            this.zarrArray = ZarrArray.create((String)file, (ArrayParams)params);
        }
        this.currentId = file;
    }

    @Override
    public void create(String id, MetadataRetrieve meta, int[] chunks) throws IOException {
        this.create(id, meta, chunks, ZarrService.Compression.NONE);
    }

    private String stripZarrRoot(String path) {
        return path.substring(path.indexOf(".zarr") + 5);
    }

    private String getZarrRoot(String path) {
        return path.substring(0, path.indexOf(".zarr") + 5);
    }

    private ZarrGroup getGroup(String path) throws IOException {
        ZarrGroup group = null;
        if (this.s3fs == null) {
            group = ZarrGroup.open((String)path);
        } else {
            this.s3fs.updateRoot(this.getZarrRoot(this.s3fs.getRoot()) + this.stripZarrRoot(path));
            group = ZarrGroup.open((Store)this.s3fs);
        }
        return group;
    }

    private ZarrArray getArray(String path) throws IOException {
        ZarrArray array = null;
        if (this.s3fs == null) {
            array = ZarrArray.open((String)path);
        } else {
            this.s3fs.updateRoot(this.getZarrRoot(this.s3fs.getRoot()) + this.stripZarrRoot(path));
            array = ZarrArray.open((Store)this.s3fs);
        }
        return array;
    }

    public boolean usingS3FileSystemStore() {
        return this.s3fs != null;
    }
}

