/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.ArrayList;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.xml.BaseHandler;
import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class ND2Handler
extends BaseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ND2Handler.class);
    private static final String DATE_FORMAT = "dd/MM/yyyy  HH:mm:ss";
    private static final int FIELD_INDEX = 2;
    private String prefix = null;
    private String prevRuntype = null;
    private String prevElement = null;
    private Hashtable<String, Object> metadata = new Hashtable();
    private CoreMetadataList core;
    private boolean isLossless;
    private ArrayList<Long> zs = new ArrayList();
    private ArrayList<Long> ts = new ArrayList();
    private int numSeries = 0;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private Double pinholeSize;
    private Double voltage;
    private Double mag;
    private Double na;
    private String objectiveModel;
    private String immersion;
    private String correction;
    private Double refractiveIndex;
    private ArrayList<String> channelNames = new ArrayList();
    private ArrayList<String> modality = new ArrayList();
    private ArrayList<String> binning = new ArrayList();
    private ArrayList<Double> speed = new ArrayList();
    private ArrayList<Double> gain = new ArrayList();
    private ArrayList<Double> temperature = new ArrayList();
    private ArrayList<Double> exposureTime = new ArrayList();
    private ArrayList<Double> exWave = new ArrayList();
    private ArrayList<Double> emWave = new ArrayList();
    private ArrayList<Integer> power = new ArrayList();
    private ArrayList<Hashtable<String, String>> rois = new ArrayList();
    private ArrayList<Length> posX = new ArrayList();
    private ArrayList<Length> posY = new ArrayList();
    private ArrayList<Length> posZ = new ArrayList();
    private ArrayList<String> posNames = new ArrayList();
    private String cameraModel;
    private String date;
    private Hashtable<String, Integer> colors = new Hashtable();
    private Hashtable<String, String> dyes = new Hashtable();
    private Hashtable<String, Integer> realColors = new Hashtable();
    private int nXFields = 0;
    private int nYFields = 0;
    private boolean populateXY = true;
    private int nImages = 0;
    private ArrayList<Boolean> validLoopState = new ArrayList();
    private boolean canAdjustDimensions = true;
    private boolean firstTimeLoop = true;
    public boolean imageMetadataLVExists = false;

    public ND2Handler(CoreMetadataList core, int nImages) {
        this(core, true, nImages);
    }

    public ND2Handler(CoreMetadataList core, boolean populateXY, int nImages) {
        this.populateXY = populateXY;
        this.nImages = nImages;
        this.core = new CoreMetadataList(core);
    }

    public int getXFields() {
        return this.nXFields;
    }

    public CoreMetadataList getCoreMetadataList() {
        return this.core;
    }

    public void populateROIs(MetadataStore store) {
        for (int r = 0; r < this.rois.size(); ++r) {
            String roiID;
            Hashtable<String, String> roi = this.rois.get(r);
            String type = roi.get("ROIType");
            if (type.equals("Text")) {
                roiID = MetadataTools.createLSID("ROI", r);
                for (int i = 0; i < this.core.size(); ++i) {
                    store.setImageROIRef(roiID, i, r);
                }
                store.setROIID(roiID, r);
                store.setLabelID(MetadataTools.createLSID("Shape", r, 0), r, 0);
                int fontSize = Integer.parseInt(roi.get("fHeight"));
                if (fontSize >= 0) {
                    store.setLabelFontSize(new Length(fontSize, UNITS.POINT), r, 0);
                }
                store.setLabelText(roi.get("eval-text"), r, 0);
                Length l = new Length(Double.parseDouble(roi.get("line-width")), UNITS.PIXEL);
                store.setLabelStrokeWidth(l, r, 0);
                String rectangle = roi.get("rectangle");
                String[] p = rectangle.split(",");
                double[] points = new double[p.length];
                for (int i = 0; i < p.length; ++i) {
                    points[i] = Double.parseDouble(p[i]);
                }
                store.setLabelX(points[0], r, 0);
                store.setLabelY(points[1], r, 0);
                store.setRectangleID(MetadataTools.createLSID("Shape", r, 1), r, 1);
                store.setRectangleX(points[0], r, 1);
                store.setRectangleY(points[1], r, 1);
                store.setRectangleWidth(points[2] - points[0], r, 1);
                store.setRectangleHeight(points[3] - points[1], r, 1);
                continue;
            }
            if (!type.equals("HorizontalLine") && !type.equals("VerticalLine")) continue;
            roiID = MetadataTools.createLSID("ROI", r);
            for (int i = 0; i < this.core.size(); ++i) {
                store.setImageROIRef(roiID, i, r);
            }
            store.setROIID(roiID, r);
            String segments = roi.get("segments");
            segments = segments.replaceAll("\\[\\]", "");
            String[] points = segments.split("\\)");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < points.length; ++i) {
                points[i] = points[i].substring(points[i].indexOf(58) + 1);
                sb.append(points[i]);
                if (i >= points.length - 1) continue;
                sb.append(" ");
            }
            store.setPolylineID(MetadataTools.createLSID("Shape", r, 0), r, 0);
            store.setPolylinePoints(sb.toString(), r, 0);
        }
    }

    public String getDate() {
        return this.date;
    }

    public Hashtable<String, Object> getMetadata() {
        return this.metadata;
    }

    public int getSeriesCount() {
        return this.numSeries;
    }

    public boolean isLossless() {
        return this.isLossless;
    }

    public ArrayList<Long> getZSections() {
        return this.zs;
    }

    public ArrayList<Long> getTimepoints() {
        return this.ts;
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public double getPixelSizeZ() {
        return this.pixelSizeZ;
    }

    public Double getPinholeSize() {
        return this.pinholeSize;
    }

    public Double getVoltage() {
        return this.voltage;
    }

    public Double getMagnification() {
        return this.mag;
    }

    public Double getNumericalAperture() {
        return this.na;
    }

    public String getObjectiveModel() {
        return this.objectiveModel;
    }

    public String getImmersion() {
        return this.immersion;
    }

    public String getCorrection() {
        return this.correction;
    }

    public Double getRefractiveIndex() {
        return this.refractiveIndex;
    }

    public ArrayList<String> getChannelNames() {
        return this.channelNames;
    }

    public ArrayList<String> getModalities() {
        return this.modality;
    }

    public ArrayList<String> getBinnings() {
        return this.binning;
    }

    public ArrayList<Double> getSpeeds() {
        return this.speed;
    }

    public ArrayList<Double> getGains() {
        return this.gain;
    }

    public ArrayList<Double> getTemperatures() {
        return this.temperature;
    }

    public ArrayList<Double> getExposureTimes() {
        return this.exposureTime;
    }

    public ArrayList<Double> getExcitationWavelengths() {
        return this.exWave;
    }

    public ArrayList<Double> getEmissionWavelengths() {
        return this.emWave;
    }

    public ArrayList<Integer> getPowers() {
        return this.power;
    }

    public ArrayList<Hashtable<String, String>> getROIs() {
        return this.rois;
    }

    public ArrayList<Length> getXPositions() {
        return this.posX;
    }

    public ArrayList<Length> getYPositions() {
        return this.posY;
    }

    public ArrayList<Length> getZPositions() {
        return this.posZ;
    }

    public ArrayList<String> getPositionNames() {
        return this.posNames;
    }

    public String getCameraModel() {
        return this.cameraModel;
    }

    public int getFieldIndex() {
        return 2;
    }

    public Hashtable<String, Integer> getChannelColors() {
        return this.realColors;
    }

    public void endElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
            this.prefix = null;
        }
        if (qName.equals(this.prevElement)) {
            this.prevElement = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        block90: {
            String runtype = attributes.getValue("runtype");
            if ("CLxListVariant".equals(runtype) || "RLxIRect".equals(runtype)) {
                this.prevElement = qName;
            }
            String value = attributes.getValue("value");
            CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
            try {
                if (qName.equals("uiWidth")) {
                    int x = Integer.parseInt(value);
                    if (x != 0 && this.populateXY) {
                        ms0.sizeX = x;
                    }
                    break block90;
                }
                if (qName.equals("uiCamPxlCountX")) {
                    if (ms0.sizeX == 0 && this.populateXY) {
                        ms0.sizeX = Integer.parseInt(value);
                    }
                    break block90;
                }
                if (qName.equals("uiCamPxlCountY")) {
                    if (ms0.sizeY == 0 && this.populateXY) {
                        ms0.sizeY = Integer.parseInt(value);
                    }
                    break block90;
                }
                if (qName.equals("iXFields")) {
                    int fields = Integer.parseInt(value);
                    this.nXFields += fields;
                    break block90;
                }
                if (qName.equals("iYFields")) {
                    int fields = Integer.parseInt(value);
                    this.nYFields += fields;
                    break block90;
                }
                if ("rectSensorUser".equals(this.prevElement) && this.populateXY) {
                    if (qName.equals("left") && ms0.sizeX == 0) {
                        ms0.sizeX = -1 * Integer.parseInt(value);
                    } else if (qName.equals("top") && ms0.sizeY == 0) {
                        ms0.sizeY = -1 * Integer.parseInt(value);
                    } else if (qName.equals("right") && ms0.sizeX <= 0) {
                        ms0.sizeX += Integer.parseInt(value);
                    } else if (qName.equals("bottom") && ms0.sizeY <= 0) {
                        ms0.sizeY += Integer.parseInt(value);
                    }
                    break block90;
                }
                if ("LoopState".equals(this.prevElement) && value != null) {
                    long v = Long.parseLong(value);
                    this.validLoopState.add(v != 529L && v < 1048575L);
                    break block90;
                }
                if ("LoopSize".equals(this.prevElement) && value != null) {
                    int v = Integer.parseInt(value);
                    int loopIndex = 0;
                    while (this.validLoopState.get(loopIndex) == null) {
                        ++loopIndex;
                    }
                    boolean loop = this.validLoopState.get(loopIndex);
                    if (!loop && this.validLoopState.contains(true)) {
                        v = 1;
                    }
                    if (ms0.sizeT == 0 || ms0.sizeT * ms0.sizeZ > this.nImages && v < ms0.sizeT) {
                        ms0.sizeT = v;
                    } else if (qName.equals("no_name") && v > 1 && this.core.size() == 1) {
                        this.core = new CoreMetadataList();
                        for (int q = 0; q < v; ++q) {
                            this.core.add(ms0);
                        }
                    } else if (ms0.sizeZ == 0) {
                        ms0.sizeZ = v;
                    } else {
                        this.canAdjustDimensions = false;
                    }
                    ms0.dimensionOrder = "CZT";
                    break block90;
                }
                if ("pPosName".equals(this.prevElement) && value != null) {
                    this.posNames.add(value);
                    break block90;
                }
                if (qName.equals("FramesBefore")) {
                    if (ms0.sizeZ == 0) {
                        ms0.sizeZ = 1;
                    }
                    if (this.canAdjustDimensions && this.core.size() == 1 && (ms0.sizeT <= 1 || ms0.sizeT * ms0.sizeZ != this.nImages)) {
                        ms0.sizeZ *= Integer.parseInt(value);
                    }
                    break block90;
                }
                if (qName.equals("FramesAfter")) {
                    int loopIndex = 0;
                    while (this.validLoopState.get(loopIndex) == null) {
                        ++loopIndex;
                    }
                    boolean loop = this.validLoopState.get(loopIndex);
                    this.validLoopState.set(loopIndex, null);
                    if (this.canAdjustDimensions && this.core.size() == 1) {
                        ms0.sizeZ *= Integer.parseInt(value);
                        if (ms0.sizeT * ms0.sizeZ > this.nImages && ms0.sizeT <= this.nImages && ms0.sizeT != ms0.sizeZ) {
                            ms0.sizeZ = ms0.sizeT;
                            ms0.sizeT = 1;
                        }
                    }
                    break block90;
                }
                if (qName.equals("TimeBefore") && this.canAdjustDimensions) {
                    if (ms0.sizeT == 0) {
                        ms0.sizeT = 1;
                    }
                    ms0.sizeT *= Integer.parseInt(value);
                    break block90;
                }
                if (qName.equals("TimeAfter") && this.canAdjustDimensions) {
                    ms0.sizeT *= Integer.parseInt(value);
                    break block90;
                }
                if (qName.equals("uiMaxDst")) {
                    int maxPixelValue = Integer.parseInt(value) + 1;
                    int bits = 0;
                    while (maxPixelValue > 0) {
                        maxPixelValue /= 2;
                        ++bits;
                    }
                    try {
                        if (ms0.pixelType == 0 && bits <= 16) {
                            ms0.pixelType = FormatTools.pixelTypeFromBytes(bits / 8, false, false);
                        }
                        break block90;
                    }
                    catch (FormatException e) {
                        LOGGER.warn("Could not set the pixel type", e);
                    }
                    break block90;
                }
                if (qName.equals("uiWidthBytes") || qName.startsWith("uiBpcInMemory") || qName.startsWith("uiBpcSignificant")) {
                    int div;
                    int n = div = qName.equals("uiWidthBytes") ? ms0.sizeX : 8;
                    if (div <= 0) break block90;
                    int bits = Integer.parseInt(value);
                    int bytes = bits / div;
                    if (bytes * div == bits) {
                        try {
                            ms0.pixelType = FormatTools.pixelTypeFromBytes(bytes, false, false);
                        }
                        catch (FormatException formatException) {
                            // empty catch block
                        }
                    }
                    this.parseKeyAndValue(qName, value, this.prevRuntype);
                    break block90;
                }
                if ("dPosX".equals(this.prevElement) && qName.startsWith("item_")) {
                    Double number = DataTools.parseDouble(value);
                    this.posX.add(new Length(number, UNITS.MICROMETER));
                    this.metadata.put("X position for position #" + this.posX.size(), value);
                } else if ("dPosY".equals(this.prevElement) && qName.startsWith("item_")) {
                    Double number = DataTools.parseDouble(value);
                    this.posY.add(new Length(number, UNITS.MICROMETER));
                    this.metadata.put("Y position for position #" + this.posY.size(), value);
                } else if ("dPosZ".equals(this.prevElement) && qName.startsWith("item_")) {
                    Double number = DataTools.parseDouble(value);
                    this.posZ.add(new Length(number, UNITS.MICROMETER));
                    this.metadata.put("Z position for position #" + this.posZ.size(), value);
                } else if (qName.startsWith("item_")) {
                    int v = Integer.parseInt(qName.substring(qName.indexOf(95) + 1));
                    if (v == this.numSeries) {
                        ++this.numSeries;
                    }
                } else if (qName.equals("uiCompCount")) {
                    int v = Integer.parseInt(value);
                    ms0.sizeC = Math.max(ms0.sizeC, v);
                } else if (qName.equals("uiHeight") && this.populateXY) {
                    int y = Integer.parseInt(value);
                    if (y != 0) {
                        ms0.sizeY = y;
                    }
                } else if (qName.startsWith("TextInfo")) {
                    this.parseKeyAndValue(qName, attributes.getValue("Text"), this.prevRuntype);
                    this.parseKeyAndValue(qName, value, this.prevRuntype);
                } else if (qName.equals("dCompressionParam")) {
                    this.isLossless = Double.parseDouble(value) > 0.0;
                    this.parseKeyAndValue(qName, value, this.prevRuntype);
                } else if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                    this.prefix = qName + " " + attributes.getValue("_SEQUENCE_INDEX");
                } else if (qName.equals("HorizontalLine") || qName.equals("VerticalLine") || qName.equals("Text")) {
                    Hashtable<String, String> roi = new Hashtable<String, String>();
                    roi.put("ROIType", qName);
                    for (int q = 0; q < attributes.getLength(); ++q) {
                        roi.put(attributes.getQName(q), attributes.getValue(q));
                    }
                    this.rois.add(roi);
                } else if (qName.equals("dPinholeRadius")) {
                    this.pinholeSize = DataTools.parseDouble(value);
                    this.metadata.put("Pinhole size", value);
                } else if (qName.endsWith("ChannelColor")) {
                    String name = qName.substring(0, qName.indexOf("Channel"));
                    this.colors.put(name, Integer.parseInt(value));
                } else if (qName.endsWith("DyeName")) {
                    int channelIndex = qName.indexOf("Channel");
                    if (channelIndex < 0) {
                        channelIndex = 0;
                    }
                    this.dyes.put(qName.substring(0, channelIndex), value);
                } else if (qName.equals("uiSequenceCount")) {
                    int newCount;
                    int imageCount = Integer.parseInt(value);
                    if (this.core.size() > 0 && (newCount = imageCount / this.core.size()) * this.core.size() == imageCount) {
                        imageCount = newCount;
                    }
                    if (ms0.sizeZ * ms0.sizeT != imageCount && ms0.sizeZ * ms0.sizeC * ms0.sizeT != imageCount) {
                        if (ms0.sizeZ > 1 && ms0.sizeT <= 1) {
                            ms0.sizeZ = imageCount;
                            ms0.sizeT = 1;
                            ms0.imageCount = imageCount;
                        } else if (ms0.sizeT > 1 && ms0.sizeZ <= 1) {
                            ms0.sizeT = imageCount;
                            ms0.sizeZ = 1;
                            ms0.imageCount = imageCount;
                        } else if (imageCount == 0) {
                            ms0.sizeT = 0;
                            ms0.sizeZ = 0;
                            ms0.imageCount = 0;
                        }
                    }
                    this.metadata.put(qName, value);
                } else {
                    StringBuilder sb = new StringBuilder();
                    if (this.prefix != null) {
                        sb.append(this.prefix);
                        sb.append(" ");
                    }
                    sb.append(qName);
                    this.parseKeyAndValue(sb.toString(), value, this.prevRuntype);
                }
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Could not parse {} value: {}", (Object)qName, (Object)value);
            }
        }
        this.prevRuntype = attributes.getValue("runtype");
    }

    @Override
    public void endDocument() {
        for (String name : this.colors.keySet()) {
            String chName = this.dyes.get(name);
            if (chName == null) {
                chName = name;
            }
            this.realColors.put(chName, this.colors.get(name));
        }
        if (this.nXFields > 0 && this.nXFields < 10 && this.nYFields > 0 && this.nYFields < 10 && this.populateXY) {
            CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
            ms0.sizeX *= this.nXFields;
            ms0.sizeY *= this.nYFields;
        }
    }

    public void parseKeyAndValue(String key, String value, String runtype) {
        if (key == null || value == null) {
            return;
        }
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0, 0);
        this.metadata.put(key, value);
        try {
            int v;
            if (key.endsWith("dCalibration")) {
                this.pixelSizeY = this.pixelSizeX = DataTools.parseDouble(value).doubleValue();
            } else if (key.endsWith("dZStep")) {
                this.pixelSizeZ = DataTools.parseDouble(value);
            } else if (key.endsWith("Gain")) {
                Double gainValue = DataTools.parseDouble(value);
                if (gainValue != null) {
                    this.gain.add(gainValue);
                }
            } else if (key.endsWith("dLampVoltage")) {
                this.voltage = DataTools.parseDouble(value);
            } else if (key.endsWith("dObjectiveMag") && this.mag == null) {
                this.mag = DataTools.parseDouble(value);
            } else if (key.endsWith("dObjectiveNA")) {
                this.na = DataTools.parseDouble(value);
            } else if (key.endsWith("dRefractIndex1")) {
                this.refractiveIndex = DataTools.parseDouble(value);
            } else if (key.equals("sObjective") || key.equals("wsObjectiveName") || key.equals("sOptics")) {
                String[] tokens = value.split(" ");
                int magIndex = -1;
                for (int i = 0; i < tokens.length; ++i) {
                    if (tokens[i].indexOf(120) == -1) continue;
                    magIndex = i;
                    break;
                }
                StringBuilder s2 = new StringBuilder();
                for (int i = 0; i < magIndex; ++i) {
                    s2.append(tokens[i]);
                }
                this.correction = s2.toString();
                if (magIndex >= 0) {
                    String m4 = tokens[magIndex].substring(0, tokens[magIndex].indexOf(120));
                    this.mag = DataTools.parseDouble(m4);
                }
                if (magIndex + 1 < tokens.length) {
                    this.immersion = tokens[magIndex + 1];
                }
            } else if (key.endsWith("dTimeMSec")) {
                Long v2 = DataTools.parseDouble(value).longValue();
                if (!this.ts.contains(v2)) {
                    this.ts.add(v2);
                    this.metadata.put("number of timepoints", this.ts.size());
                }
            } else if (key.endsWith("dZPos")) {
                Long v3 = DataTools.parseLong(value);
                if (!this.zs.contains(v3)) {
                    this.zs.add(v3);
                }
            } else if (key.endsWith("uiCount")) {
                if (runtype != null) {
                    if (runtype.endsWith("ZStackLoop") && !this.imageMetadataLVExists) {
                        if (ms0.sizeZ == 0) {
                            ms0.sizeZ = Integer.parseInt(value);
                            if (ms0.dimensionOrder.indexOf(90) == -1) {
                                ms0.dimensionOrder = "Z" + ms0.dimensionOrder;
                            }
                        }
                    } else if (runtype.endsWith("TimeLoop") && !this.imageMetadataLVExists) {
                        if (ms0.sizeT == 0) {
                            ms0.sizeT = Integer.parseInt(value);
                            if (ms0.dimensionOrder.indexOf(84) == -1) {
                                ms0.dimensionOrder = "T" + ms0.dimensionOrder;
                            }
                        }
                    } else if (runtype.endsWith("XYPosLoop") && this.core.size() == 1) {
                        int len = Integer.parseInt(value);
                        this.core = new CoreMetadataList();
                        for (int i = 0; i < len; ++i) {
                            this.core.add(ms0);
                        }
                    }
                }
            } else if (key.endsWith("uiBpcSignificant")) {
                ms0.bitsPerPixel = Integer.parseInt(value);
            } else if (key.equals("VirtualComponents")) {
                if (ms0.sizeC == 0) {
                    ms0.sizeC = Integer.parseInt(value);
                    if (ms0.dimensionOrder.indexOf(67) == -1) {
                        ms0.dimensionOrder = ms0.dimensionOrder + "C" + ms0.dimensionOrder;
                    }
                }
            } else if (key.startsWith("TextInfoItem") || key.endsWith("TextInfoItem")) {
                String[] tokens;
                this.metadata.remove(key);
                value = value.replaceAll("&#x000d;", "");
                value = value.replaceAll("#x000d;", "");
                value = value.replaceAll("&#x000a;", "\n");
                value = value.replaceAll("#x000a;", "\n");
                for (String t2 : tokens = value.split("\n")) {
                    String[] v4 = (t2 = t2.trim()).split(":");
                    if (v4.length == 0) continue;
                    if (v4.length == 2) {
                        this.parseKeyAndValue(v4[0].trim(), v4[1].trim(), runtype);
                        continue;
                    }
                    if (v4[0].equals("Line")) {
                        this.parseKeyAndValue(v4[0], t2.substring(t2.indexOf(58) + 1).trim(), runtype);
                        continue;
                    }
                    if (v4.length > 1) {
                        v4[0] = v4[0].replace('{', ' ');
                        v4[0] = v4[0].replace('}', ' ');
                        this.metadata.put(v4[0].trim(), v4[1]);
                        continue;
                    }
                    if (v4.length != 1) continue;
                    this.metadata.put(key, v4[0]);
                }
            } else if (this.isDimensions(key) && !this.imageMetadataLVExists) {
                String[] dims = value.split(" x ");
                if (ms0.sizeZ == 0) {
                    ms0.sizeZ = 1;
                }
                if (ms0.sizeT == 0) {
                    ms0.sizeT = 1;
                }
                if (ms0.sizeC == 0) {
                    ms0.sizeC = 1;
                }
                for (String dim : dims) {
                    dim = dim.trim();
                    int v5 = Integer.parseInt(dim.replaceAll("\\D", ""));
                    v5 = Math.max(v5, 1);
                    if (dim.startsWith("XY")) {
                        this.numSeries = v5;
                        if (this.numSeries <= 1) continue;
                        int x = ms0.sizeX;
                        int y = ms0.sizeY;
                        int z = ms0.sizeZ;
                        int tSize = ms0.sizeT;
                        int c = ms0.sizeC;
                        String order = ms0.dimensionOrder;
                        int pixelType = ms0.pixelType;
                        this.core = new CoreMetadataList();
                        for (int i = 0; i < this.numSeries; ++i) {
                            CoreMetadata ms = new CoreMetadata();
                            this.core.add(ms);
                            ms.sizeX = x;
                            ms.sizeY = y;
                            ms.sizeZ = z == 0 ? 1 : z;
                            ms.sizeC = c == 0 ? 1 : c;
                            ms.sizeT = tSize == 0 ? 1 : tSize;
                            ms.dimensionOrder = order;
                            ms.pixelType = pixelType;
                        }
                        ms0 = (CoreMetadata)this.core.get(0, 0);
                        continue;
                    }
                    if (dim.startsWith("T")) {
                        if (ms0.sizeT > 1 && v5 >= ms0.sizeT) continue;
                        ms0.sizeT = v5;
                        continue;
                    }
                    if (dim.startsWith("Z")) {
                        if (ms0.sizeZ > 1) continue;
                        ms0.sizeZ = v5;
                        continue;
                    }
                    if (ms0.sizeC > 1) continue;
                    ms0.sizeC = v5;
                }
                ms0.imageCount = ms0.sizeZ * ms0.sizeC * ms0.sizeT;
            } else if (key.startsWith("Number of Picture Planes")) {
                ms0.sizeC = Integer.parseInt(value.replaceAll("\\D", ""));
            } else if (key.equals("Name")) {
                this.channelNames.add(value);
            } else if (key.equals("Modality")) {
                this.modality.add(value);
            } else if (key.equals("Camera Type")) {
                this.cameraModel = value;
            } else if (key.equals("Binning")) {
                this.binning.add(value);
            } else if (key.equals("Readout Speed")) {
                int last = value.lastIndexOf(" ");
                if (last != -1) {
                    value = value.substring(0, last);
                }
                this.speed.add(DataTools.parseDouble(value));
            } else if (key.equals("Temperature")) {
                String temp = value.replaceAll("[\\D&&[^-.]]", "");
                this.temperature.add(DataTools.parseDouble(temp));
            } else if (key.equals("Exposure") && (this.prevElement == null || "no_name".equals(this.prevElement) || "PropertiesQuality".equals(this.prevElement))) {
                String[] s3 = value.trim().split(" ");
                Double time = DataTools.parseDouble(s3[0]);
                if (time != null) {
                    if (s3.length > 1) {
                        if (s3[1].equals("ms")) {
                            time = time / 1000.0;
                        }
                    } else {
                        time = time / 1000.0;
                    }
                    this.exposureTime.add(time);
                }
            } else if (key.equals("{Pinhole Size}")) {
                this.pinholeSize = DataTools.parseDouble(value);
                this.metadata.put("Pinhole size", value);
            } else if (key.startsWith("- Step")) {
                Double step = this.parsePixelsSizeZFromKey(key);
                if (step != null) {
                    this.pixelSizeZ = step;
                }
            } else if (key.equals("Line")) {
                String[] values = value.split(";");
                for (int q = 0; q < values.length; ++q) {
                    int colon = values[q].indexOf(58);
                    if (colon < 0) continue;
                    String nextKey = values[q].substring(0, colon).trim();
                    String nextValue = values[q].substring(colon + 1).trim();
                    this.parseKeyAndValue(nextKey, nextValue, runtype);
                }
            } else if (key.equalsIgnoreCase("Emission wavelength")) {
                String[] v6 = value.split(" ");
                this.emWave.add(Double.parseDouble(v6[0]));
            } else if (key.equalsIgnoreCase("Excitation wavelength")) {
                String[] v7 = value.split(" ");
                this.exWave.add(Double.parseDouble(v7[0]));
            } else if (key.equals("Power")) {
                this.power.add(DataTools.parseDouble(value).intValue());
            } else if (key.equals("CameraUniqueName")) {
                this.cameraModel = value;
            } else if (key.equals("ExposureTime")) {
                this.exposureTime.add(Double.parseDouble(value) / 1000.0);
            } else if (key.equals("sDate")) {
                this.date = DateTools.formatDate(value, DATE_FORMAT);
            } else if (key.equals("Name") && this.channelNames.size() < ms0.sizeC) {
                this.channelNames.add(value);
            } else if (key.equals("Z Stack Loop")) {
                int v8 = Integer.parseInt(value);
                if (v8 <= this.nImages || this.nImages <= 0) {
                    ((CoreMetadata)this.core.get((int)0, (int)0)).sizeZ = v8;
                }
            } else if (key.equals("Time Loop") && (v = Integer.parseInt(value)) <= this.nImages && this.firstTimeLoop) {
                ((CoreMetadata)this.core.get((int)0, (int)0)).sizeT = v;
                this.firstTimeLoop = false;
            }
        }
        catch (NullPointerException | NumberFormatException exc) {
            LOGGER.warn("Could not parse {} value: {}", (Object)key, (Object)value);
        }
    }

    public boolean isDimensions(String key) {
        return key.startsWith("Dimensions") || key.startsWith("Abmessungen");
    }

    private Double parsePixelsSizeZFromKey(String key) {
        int space = key.indexOf(32, key.indexOf("Step") + 1);
        if (space == -1) {
            return null;
        }
        int last = key.indexOf(32, space + 1);
        if (last == -1) {
            last = key.length();
        }
        return DataTools.parseDouble(key.substring(space, last).trim());
    }
}

