/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.MJPBCodec;
import loci.formats.codec.MJPBCodecOptions;
import loci.formats.codec.QTRLECodec;
import loci.formats.codec.RPZACodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataStore;

public class QTReader
extends FormatReader {
    private static final String[] CONTAINER_TYPES = new String[]{"moov", "trak", "udta", "tref", "imap", "mdia", "minf", "stbl", "edts", "mdra", "rmra", "imag", "vnrp", "dinf"};
    private long pixelOffset;
    private long pixelBytes;
    private int bitsPerPixel;
    private int rawSize;
    private Vector<Integer> offsets;
    private byte[] prevPixels;
    private int prevPlane;
    private boolean canUsePrevious;
    private String codec;
    private String altCodec;
    private int altPlanes;
    private int scale;
    private Vector<Integer> chunkSizes;
    private boolean interlaced;
    private boolean separatedFork;
    private String forkFile;
    private boolean flip;

    public QTReader() {
        super("QuickTime", "mov");
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        if (!FormatTools.validStream(stream, 64, false)) {
            return false;
        }
        String s2 = stream.readString(64);
        for (int i = 0; i < CONTAINER_TYPES.length; ++i) {
            if (s2.indexOf(CONTAINER_TYPES[i]) < 0 || CONTAINER_TYPES[i].equals("imag")) continue;
            return true;
        }
        return s2.indexOf("wide") >= 0 || s2.indexOf("mdat") >= 0 || s2.indexOf("ftypqt") >= 0;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String[] stringArray2;
            if (this.forkFile == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.forkFile;
            }
            return stringArray2;
        }
        if (this.forkFile == null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = this.currentId;
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = this.currentId;
            stringArray = stringArray5;
            stringArray5[1] = this.forkFile;
        }
        return stringArray;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        int expectedSize;
        byte[] t2;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        String code = this.codec;
        if (no >= this.getImageCount() - this.altPlanes) {
            code = this.altCodec;
        }
        int offset = this.offsets.get(no);
        int nextOffset = (int)this.pixelBytes;
        this.scale = this.offsets.get(0);
        offset -= this.scale;
        if (no < this.offsets.size() - 1) {
            nextOffset = this.offsets.get(no + 1) - this.scale;
        }
        if (nextOffset - offset < 0) {
            int temp = offset;
            offset = nextOffset;
            nextOffset = temp;
        }
        byte[] pixs = new byte[nextOffset - offset];
        this.in.seek(this.pixelOffset + (long)offset);
        this.in.read(pixs);
        this.canUsePrevious = this.prevPixels != null && this.prevPlane == no - 1 && !code.equals(this.altCodec);
        byte[] byArray = t2 = this.prevPlane == no && this.prevPixels != null && !code.equals(this.altCodec) ? this.prevPixels : this.uncompress(pixs, code);
        if (code.equals("rpza")) {
            for (int i = 0; i < t2.length; ++i) {
                t2[i] = (byte)(255 - t2[i]);
            }
            this.prevPlane = no;
            return buf;
        }
        if (this.canUsePrevious && this.prevPixels.length < t2.length) {
            byte[] temp = t2;
            t2 = new byte[this.prevPixels.length];
            System.arraycopy(temp, 0, t2, 0, t2.length);
        }
        if (t2.length > 0) {
            this.prevPixels = t2;
        }
        this.prevPlane = no;
        int bytes = this.bitsPerPixel < 40 ? this.bitsPerPixel / 8 : (this.bitsPerPixel - 32) / 8;
        int pad = (4 - this.getSizeX() % 4) % 4;
        if (this.codec.equals("mjpb")) {
            pad = 0;
        }
        if (this.prevPixels.length == (expectedSize = FormatTools.getPlaneSize(this)) || this.bitsPerPixel == 32 && 3 * (this.prevPixels.length / 4) == expectedSize) {
            pad = 0;
        }
        if (pad > 0) {
            t2 = new byte[this.prevPixels.length - this.getSizeY() * pad];
            for (int row = 0; row < this.getSizeY(); ++row) {
                System.arraycopy(this.prevPixels, row * (bytes * this.getSizeX() + pad), t2, row * this.getSizeX() * bytes, this.getSizeX() * bytes);
            }
        }
        if (t2.length == 0) {
            t2 = this.prevPixels;
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int srcRowLen = this.getSizeX() * bpp * this.getSizeC();
        int destRowLen = w * bpp * this.getSizeC();
        for (int row = 0; row < h2; ++row) {
            if (this.bitsPerPixel == 32) {
                for (int col = 0; col < w; ++col) {
                    int src = (row + y) * this.getSizeX() * bpp * 4 + (x + col) * bpp * 4 + 1;
                    int dst = row * destRowLen + col * bpp * 3;
                    if (src + 3 > t2.length || dst + 3 > buf.length) continue;
                    System.arraycopy(t2, src, buf, dst, 3);
                }
                continue;
            }
            System.arraycopy(t2, (row + y) * srcRowLen + x * bpp * this.getSizeC(), buf, row * destRowLen, destRowLen);
        }
        if (!(this.bitsPerPixel != 40 && this.bitsPerPixel != 8 || code.equals("mjpb"))) {
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(255 - buf[i]);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.prevPixels = null;
            this.altCodec = null;
            this.codec = null;
            this.rawSize = 0;
            this.bitsPerPixel = 0;
            this.pixelOffset = this.pixelBytes = (long)0;
            this.altPlanes = 0;
            this.prevPlane = 0;
            this.canUsePrevious = false;
            this.scale = 0;
            this.chunkSizes = null;
            this.flip = false;
            this.separatedFork = false;
            this.interlaced = false;
            this.forkFile = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.separatedFork = true;
        this.offsets = new Vector();
        this.chunkSizes = new Vector();
        LOGGER.info("Parsing tags");
        this.parse(0, 0L, this.in.length());
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.imageCount = this.offsets.size();
        if (this.chunkSizes.size() < this.getImageCount() && this.chunkSizes.size() > 0) {
            m4.imageCount = this.chunkSizes.size();
        }
        LOGGER.info("Populating metadata");
        int bytes = this.bitsPerPixel / 8 % 4;
        m4.pixelType = bytes == 2 ? 3 : 1;
        m4.sizeZ = 1;
        m4.dimensionOrder = "XYCZT";
        m4.littleEndian = false;
        m4.metadataComplete = true;
        m4.indexed = false;
        m4.falseColor = false;
        if (this.separatedFork) {
            String base = null;
            base = id.indexOf(".", id.lastIndexOf(File.separator) + 1) != -1 ? id.substring(0, id.lastIndexOf(".")) : id;
            Location f = new Location(base + ".qtr");
            LOGGER.debug("Searching for resource fork:");
            if (f.exists()) {
                LOGGER.debug("\t Found: {}", (Object)f);
                if (this.in != null) {
                    this.in.close();
                }
                this.in = new RandomAccessInputStream(f.getAbsolutePath());
                this.forkFile = f.getAbsolutePath();
                this.stripHeader();
                this.parse(0, 0L, this.in.length());
                m4.imageCount = this.offsets.size();
            } else {
                LOGGER.debug("\tAbsent: {}", (Object)f);
                f = new Location(id.substring(0, id.lastIndexOf(File.separator) + 1) + "._" + id.substring(base.lastIndexOf(File.separator) + 1));
                if (f.exists()) {
                    LOGGER.debug("\t Found: {}", (Object)f);
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.in = new RandomAccessInputStream(f.getAbsolutePath());
                    this.forkFile = f.getAbsolutePath();
                    this.stripHeader();
                    this.parse(0, this.in.getFilePointer(), this.in.length());
                    m4.imageCount = this.offsets.size();
                } else {
                    LOGGER.debug("\tAbsent: {}", (Object)f);
                    f = new Location(id + "/..namedfork/rsrc");
                    if (f.exists()) {
                        LOGGER.debug("\t Found: {}", (Object)f);
                        if (this.in != null) {
                            this.in.close();
                        }
                        this.in = new RandomAccessInputStream(f.getAbsolutePath());
                        this.forkFile = f.getAbsolutePath();
                        this.stripHeader();
                        this.parse(0, this.in.getFilePointer(), this.in.length());
                        m4.imageCount = this.offsets.size();
                    } else {
                        LOGGER.debug("\tAbsent: {}", (Object)f);
                        throw new FormatException("QuickTime resource fork not found.  To avoid this issue, please flatten your QuickTime movies before importing with Bio-Formats.");
                    }
                }
            }
            if (this.in != null) {
                this.in.close();
            }
            this.in = new RandomAccessInputStream(this.currentId);
        }
        m4.rgb = this.bitsPerPixel < 40;
        m4.sizeC = this.isRGB() ? 3 : 1;
        m4.interleaved = this.isRGB();
        m4.sizeT = this.getImageCount();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(int depth, long offset, long length) throws FormatException, IOException {
        while (offset < length) {
            this.in.seek(offset);
            long atomSize = (long)this.in.readInt() & 0xFFFFFFFFL;
            String atomType = this.in.readString(4);
            if (atomSize == 1L) {
                atomSize = this.in.readLong();
            }
            if (atomSize < 0L) {
                LOGGER.warn("QTReader: invalid atom size: {}", (Object)atomSize);
            } else if (atomSize > this.in.length()) {
                offset += 4L;
                continue;
            }
            LOGGER.debug("Seeking to {}; atomType={}; atomSize={}", offset, atomType, atomSize);
            if (this.isContainer(atomType)) {
                this.parse(depth++, this.in.getFilePointer(), offset + atomSize);
            } else {
                int i;
                int i2;
                if (atomSize == 0L) {
                    atomSize = this.in.length();
                }
                long oldpos = this.in.getFilePointer();
                if (atomType.equals("mdat")) {
                    this.pixelOffset = this.in.getFilePointer();
                    this.pixelBytes = atomSize;
                    if (this.pixelBytes > this.in.length() - this.pixelOffset) {
                        this.pixelBytes = this.in.length() - this.pixelOffset;
                    }
                } else if (atomType.equals("tkhd")) {
                    this.in.skipBytes(38);
                    int[][] matrix = new int[3][3];
                    for (i2 = 0; i2 < matrix.length; ++i2) {
                        for (int j = 0; j < matrix[0].length; ++j) {
                            matrix[i2][j] = this.in.readInt();
                        }
                    }
                    boolean bl = this.flip = matrix[0][0] == 0 && matrix[1][0] != 0;
                    if (this.getSizeX() == 0) {
                        ((CoreMetadata)this.core.get((int)0)).sizeX = this.in.readInt();
                    }
                    if (this.getSizeY() == 0) {
                        ((CoreMetadata)this.core.get((int)0)).sizeY = this.in.readInt();
                    }
                } else if (atomType.equals("cmov")) {
                    this.in.skipBytes(8);
                    if (!"zlib".equals(this.in.readString(4))) throw new UnsupportedCompressionException("Compressed header not supported.");
                    atomSize = this.in.readInt();
                    this.in.skipBytes(4);
                    int uncompressedSize = this.in.readInt();
                    byte[] b = new byte[(int)(atomSize - 12L)];
                    this.in.read(b);
                    byte[] output = new ZlibCodec().decompress(b, null);
                    RandomAccessInputStream oldIn = this.in;
                    try {
                        this.in = new RandomAccessInputStream(output);
                        this.parse(0, 0L, output.length);
                    }
                    finally {
                        this.in.close();
                    }
                    this.in = oldIn;
                } else if (atomType.equals("stco")) {
                    if (this.offsets.size() > 0) return;
                    this.separatedFork = false;
                    this.in.skipBytes(4);
                    int numPlanes = this.in.readInt();
                    if (numPlanes != this.getImageCount()) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        int off = this.in.readInt();
                        this.offsets.add(off);
                        for (i = 1; i < this.getImageCount(); ++i) {
                            if (this.chunkSizes.size() > 0 && i < this.chunkSizes.size()) {
                                this.rawSize = this.chunkSizes.get(i);
                            } else {
                                i = this.getImageCount();
                            }
                            this.offsets.add(off += this.rawSize);
                        }
                    } else {
                        for (i2 = 0; i2 < numPlanes; ++i2) {
                            this.offsets.add(this.in.readInt());
                        }
                    }
                } else if (atomType.equals("stsd")) {
                    this.in.skipBytes(4);
                    int numEntries = this.in.readInt();
                    this.in.skipBytes(4);
                    for (i2 = 0; i2 < numEntries; ++i2) {
                        if (i2 == 0) {
                            this.codec = this.in.readString(4);
                            if (!(this.codec.equals("raw ") || this.codec.equals("rle ") || this.codec.equals("rpza") || this.codec.equals("mjpb") || this.codec.equals("jpeg"))) {
                                throw new UnsupportedCompressionException("Unsupported codec: " + this.codec);
                            }
                            this.in.skipBytes(16);
                            if (this.in.readShort() != 0) continue;
                            this.in.skipBytes(56);
                            this.bitsPerPixel = this.in.readShort();
                            if (this.codec.equals("rpza")) {
                                this.bitsPerPixel = 8;
                            }
                            this.in.skipBytes(10);
                            this.interlaced = this.in.read() == 2;
                            this.addGlobalMeta("Codec", this.codec);
                            this.addGlobalMeta("Bits per pixel", this.bitsPerPixel);
                            this.in.skipBytes(9);
                            continue;
                        }
                        this.altCodec = this.in.readString(4);
                        this.addGlobalMeta("Second codec", this.altCodec);
                    }
                } else if (atomType.equals("stsz")) {
                    this.in.skipBytes(4);
                    this.rawSize = this.in.readInt();
                    ((CoreMetadata)this.core.get((int)0)).imageCount = this.in.readInt();
                    if (this.rawSize == 0) {
                        this.in.seek(this.in.getFilePointer() - 4L);
                        for (int b = 0; b < this.getImageCount(); ++b) {
                            this.chunkSizes.add(this.in.readInt());
                        }
                    }
                } else if (atomType.equals("stsc")) {
                    this.in.skipBytes(4);
                    int numChunks = this.in.readInt();
                    if (this.altCodec != null) {
                        int prevChunk = 0;
                        for (i = 0; i < numChunks; ++i) {
                            int chunk = this.in.readInt();
                            int planesPerChunk = this.in.readInt();
                            int id = this.in.readInt();
                            if (id == 2) {
                                this.altPlanes += planesPerChunk * (chunk - prevChunk);
                            }
                            prevChunk = chunk;
                        }
                    }
                } else if (atomType.equals("stts")) {
                    this.in.skipBytes(12);
                    int fps = this.in.readInt();
                    this.addGlobalMeta("Frames per second", fps);
                }
                if (oldpos + atomSize >= this.in.length()) return;
                this.in.seek(oldpos + atomSize);
            }
            offset = atomSize == 0L ? this.in.length() : (offset += atomSize);
            if (atomType.equals("udta")) {
                offset += 4L;
            }
            this.print(depth, atomSize, atomType);
        }
    }

    private boolean isContainer(String type) {
        for (int i = 0; i < CONTAINER_TYPES.length; ++i) {
            if (!type.equals(CONTAINER_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private void print(int depth, long size, String type) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append(" ");
        }
        sb.append(type + " : [" + size + "]");
        LOGGER.debug(sb.toString());
    }

    private byte[] uncompress(byte[] pixs, String code) throws FormatException, IOException {
        MJPBCodecOptions options = new MJPBCodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = this.bitsPerPixel;
        options.channels = this.bitsPerPixel < 40 ? this.bitsPerPixel / 8 : (this.bitsPerPixel - 32) / 8;
        options.previousImage = this.canUsePrevious ? this.prevPixels : null;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isRGB();
        if (code.equals("raw ")) {
            return pixs;
        }
        if (code.equals("rle ")) {
            return new QTRLECodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("rpza")) {
            return new RPZACodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("mjpb")) {
            options.interlaced = this.interlaced;
            return new MJPBCodec().decompress(pixs, (CodecOptions)options);
        }
        if (code.equals("jpeg")) {
            return new JPEGCodec().decompress(pixs, (CodecOptions)options);
        }
        throw new UnsupportedCompressionException("Unsupported codec : " + code);
    }

    private void stripHeader() throws IOException {
        this.in.seek(0L);
        while (!this.in.readString(4).equals("moov")) {
            this.in.seek(this.in.getFilePointer() - 2L);
        }
        this.in.seek(this.in.getFilePointer() - 8L);
    }
}

