/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.estimation;

import java.util.Arrays;
import org.apache.commons.math.estimation.EstimatedParameter;
import org.apache.commons.math.estimation.EstimationException;
import org.apache.commons.math.estimation.EstimationProblem;
import org.apache.commons.math.estimation.Estimator;
import org.apache.commons.math.estimation.WeightedMeasurement;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.RealMatrixImpl;

public abstract class AbstractEstimator
implements Estimator {
    protected WeightedMeasurement[] measurements;
    protected EstimatedParameter[] parameters;
    protected double[] jacobian;
    protected int cols;
    protected int rows;
    protected double[] residuals;
    protected double cost;
    private int maxCostEval;
    private int costEvaluations;
    private int jacobianEvaluations;

    protected AbstractEstimator() {
    }

    public final void setMaxCostEval(int maxCostEval) {
        this.maxCostEval = maxCostEval;
    }

    public final int getCostEvaluations() {
        return this.costEvaluations;
    }

    public final int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    protected void updateJacobian() {
        this.incrementJacobianEvaluationsCounter();
        Arrays.fill(this.jacobian, 0.0);
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            WeightedMeasurement wm = this.measurements[i];
            double factor = -Math.sqrt(wm.getWeight());
            for (int j = 0; j < this.cols; ++j) {
                this.jacobian[index++] = factor * wm.getPartial(this.parameters[j]);
            }
        }
    }

    protected final void incrementJacobianEvaluationsCounter() {
        ++this.jacobianEvaluations;
    }

    protected void updateResidualsAndCost() throws EstimationException {
        if (++this.costEvaluations > this.maxCostEval) {
            throw new EstimationException("maximal number of evaluations exceeded ({0})", new Object[]{new Integer(this.maxCostEval)});
        }
        this.cost = 0.0;
        int i = 0;
        int index = 0;
        while (i < this.rows) {
            WeightedMeasurement wm = this.measurements[i];
            double residual = wm.getResidual();
            this.residuals[i] = Math.sqrt(wm.getWeight()) * residual;
            this.cost += wm.getWeight() * residual * residual;
            ++i;
            index += this.cols;
        }
        this.cost = Math.sqrt(this.cost);
    }

    public double getRMS(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double criterion = 0.0;
        for (int i = 0; i < wm.length; ++i) {
            double residual = wm[i].getResidual();
            criterion += wm[i].getWeight() * residual * residual;
        }
        return Math.sqrt(criterion / (double)wm.length);
    }

    public double getChiSquare(EstimationProblem problem) {
        WeightedMeasurement[] wm = problem.getMeasurements();
        double chiSquare = 0.0;
        for (int i = 0; i < wm.length; ++i) {
            double residual = wm[i].getResidual();
            chiSquare += residual * residual / wm[i].getWeight();
        }
        return chiSquare;
    }

    public double[][] getCovariances(EstimationProblem problem) throws EstimationException {
        this.updateJacobian();
        int rows = problem.getMeasurements().length;
        int cols = problem.getAllParameters().length;
        int max = cols * rows;
        double[][] jTj = new double[cols][cols];
        for (int i = 0; i < cols; ++i) {
            for (int j = i; j < cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < max; k += cols) {
                    sum += this.jacobian[k + i] * this.jacobian[k + j];
                }
                jTj[i][j] = sum;
                jTj[j][i] = sum;
            }
        }
        try {
            return new RealMatrixImpl(jTj).inverse().getData();
        }
        catch (InvalidMatrixException ime) {
            throw new EstimationException("unable to compute covariances: singular problem", new Object[0]);
        }
    }

    public double[] guessParametersErrors(EstimationProblem problem) throws EstimationException {
        int p;
        int m4 = problem.getMeasurements().length;
        if (m4 <= (p = problem.getAllParameters().length)) {
            throw new EstimationException("no degrees of freedom ({0} measurements, {1} parameters)", new Object[]{new Integer(m4), new Integer(p)});
        }
        double[] errors = new double[problem.getAllParameters().length];
        double c = Math.sqrt(this.getChiSquare(problem) / (double)(m4 - p));
        double[][] covar = this.getCovariances(problem);
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = Math.sqrt(covar[i][i]) * c;
        }
        return errors;
    }

    protected void initializeEstimate(EstimationProblem problem) {
        this.costEvaluations = 0;
        this.jacobianEvaluations = 0;
        this.measurements = problem.getMeasurements();
        this.parameters = problem.getUnboundParameters();
        this.rows = this.measurements.length;
        this.cols = this.parameters.length;
        this.jacobian = new double[this.rows * this.cols];
        this.residuals = new double[this.rows];
        this.cost = Double.POSITIVE_INFINITY;
    }

    public abstract void estimate(EstimationProblem var1) throws EstimationException;
}

