/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPIntercepts {
    private static final Logger logger = LoggerFactory.getLogger(HTTPIntercepts.class);
    public static Printer logprinter = new Printer(){

        @Override
        public void print(String s2) {
            logger.debug(s2);
        }

        @Override
        public void println(String s2) {
            logger.debug(s2);
        }
    };
    protected static boolean defaultinterception = false;
    protected static Printer defaultprinter = null;
    protected Printer printer = logprinter;
    protected HttpResponseInterceptor CEKILL = null;
    protected List<HttpRequestInterceptor> reqintercepts = new CopyOnWriteArrayList<HttpRequestInterceptor>();
    protected List<HttpResponseInterceptor> rspintercepts = new CopyOnWriteArrayList<HttpResponseInterceptor>();
    protected List<HttpRequestInterceptor> dbgreq = new CopyOnWriteArrayList<HttpRequestInterceptor>();
    protected List<HttpResponseInterceptor> dbgrsp = new CopyOnWriteArrayList<HttpResponseInterceptor>();

    public static void setGlobalDebugInterceptors(boolean tf) {
        defaultinterception = true;
    }

    public static void setGlobalPrinter(Printer printer) {
        defaultprinter = printer;
    }

    public DebugInterceptRequest debugRequestInterceptor() {
        for (HttpRequestInterceptor hri : this.reqintercepts) {
            if (!(hri instanceof DebugInterceptRequest)) continue;
            return (DebugInterceptRequest)hri;
        }
        return null;
    }

    public DebugInterceptResponse debugResponseInterceptor() {
        for (HttpResponseInterceptor hri : this.rspintercepts) {
            if (!(hri instanceof DebugInterceptResponse)) continue;
            return (DebugInterceptResponse)hri;
        }
        return null;
    }

    public HTTPIntercepts() {
        if (defaultinterception) {
            this.addDebugInterceptors();
        } else {
            this.removeDebugIntercepts();
        }
        this.printer = defaultprinter;
    }

    public void setCEKILL(boolean tf) {
        this.CEKILL = tf ? new ContentEncodingInterceptor() : null;
    }

    public void activateInterceptors(HttpClientBuilder cb) {
        for (HttpRequestInterceptor hrq : this.reqintercepts) {
            cb.addInterceptorLast(hrq);
        }
        for (HttpResponseInterceptor hrs : this.rspintercepts) {
            cb.addInterceptorLast(hrs);
        }
        for (HttpRequestInterceptor hrq : this.dbgreq) {
            cb.addInterceptorFirst(hrq);
        }
        for (HttpResponseInterceptor hrs : this.dbgrsp) {
            cb.addInterceptorFirst(hrs);
        }
        cb.addInterceptorFirst(this.CEKILL);
    }

    protected synchronized void addDebugInterceptors() {
        HttpRequestInterceptor hr;
        int i;
        DebugInterceptRequest rq = new DebugInterceptRequest();
        DebugInterceptResponse rs = new DebugInterceptResponse();
        rq.setPrint(this.printer);
        rs.setPrint(this.printer);
        for (i = this.reqintercepts.size() - 1; i >= 0; --i) {
            hr = this.reqintercepts.get(i);
            if (!(hr instanceof InterceptCommon)) continue;
            this.reqintercepts.remove(i);
        }
        for (i = this.rspintercepts.size() - 1; i >= 0; --i) {
            hr = this.rspintercepts.get(i);
            if (!(hr instanceof InterceptCommon)) continue;
            this.rspintercepts.remove(i);
        }
        this.reqintercepts.add(rq);
        this.rspintercepts.add(rs);
    }

    public synchronized void resetInterceptors() {
        for (HttpRequestInterceptor hri : this.reqintercepts) {
            if (!(hri instanceof InterceptCommon)) continue;
            ((InterceptCommon)hri).clear();
        }
    }

    public void setGzipCompression() {
        GZIPResponseInterceptor hrsi = new GZIPResponseInterceptor();
        this.rspintercepts.add(hrsi);
    }

    public void setDeflateCompression() {
        DeflateResponseInterceptor hrsi = new DeflateResponseInterceptor();
        this.rspintercepts.add(hrsi);
    }

    public synchronized void removeCompression() {
        for (int i = this.rspintercepts.size() - 1; i >= 0; --i) {
            HttpResponseInterceptor hrsi = this.rspintercepts.get(i);
            if (!(hrsi instanceof GZIPResponseInterceptor) && !(hrsi instanceof DeflateResponseInterceptor)) continue;
            this.rspintercepts.remove(i);
        }
    }

    public synchronized void removeDebugIntercepts() {
        HttpResponseInterceptor hrsi;
        int i;
        for (i = this.rspintercepts.size() - 1; i >= 0; --i) {
            hrsi = this.rspintercepts.get(i);
            if (!(hrsi instanceof DebugInterceptResponse)) continue;
            this.rspintercepts.remove(i);
        }
        for (i = this.reqintercepts.size() - 1; i >= 0; --i) {
            hrsi = this.reqintercepts.get(i);
            if (!(hrsi instanceof DebugInterceptRequest)) continue;
            this.reqintercepts.remove(i);
        }
    }

    static class DeflateResponseInterceptor
    implements HttpResponseInterceptor {
        DeflateResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static class GZIPResponseInterceptor
    implements HttpResponseInterceptor {
        GZIPResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static class ContentEncodingInterceptor
    extends InterceptCommon
    implements HttpResponseInterceptor {
        ContentEncodingInterceptor() {
        }

        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity;
            if (response == null) {
                return;
            }
            Header[] hdrs = response.getAllHeaders();
            if (hdrs == null) {
                return;
            }
            boolean modified = false;
            for (int i = 0; i < hdrs.length; ++i) {
                String value;
                Header h2 = hdrs[i];
                if (!h2.getName().equalsIgnoreCase("content-encoding") || !(value = h2.getValue()).trim().toLowerCase().endsWith("-endian")) continue;
                hdrs[i] = new BasicHeader("X-Content-Encoding", value);
                modified = true;
            }
            if (modified) {
                response.setHeaders(hdrs);
            }
            if ((entity = response.getEntity()) != null && (ceheader = entity.getContentEncoding()) != null) {
                String string = ceheader.getValue();
            }
        }
    }

    public static class DebugInterceptRequest
    extends InterceptCommon
    implements HttpRequestInterceptor {
        protected RequestLine requestline = null;

        public String getMethod() {
            return this.requestline == null ? null : this.requestline.getMethod();
        }

        public String getUri() {
            return this.requestline == null ? null : this.requestline.getUri();
        }

        public synchronized void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            this.request = request;
            this.context = context;
            this.requestline = request.getRequestLine();
            if (this.printer != null) {
                this.printHeaders();
            }
            if (this.request != null) {
                Header[] hdrs = this.request.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    public static class DebugInterceptResponse
    extends InterceptCommon
    implements HttpResponseInterceptor {
        protected StatusLine statusline = null;

        public int getStatusCode() {
            return this.statusline == null ? -1 : this.statusline.getStatusCode();
        }

        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.response = response;
            this.context = context;
            this.statusline = response.getStatusLine();
            if (this.printer != null) {
                this.printHeaders();
            }
            if (this.response != null) {
                Header[] hdrs = this.response.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    static abstract class InterceptCommon {
        private static final Logger logger = LoggerFactory.getLogger(InterceptCommon.class);
        protected HttpContext context = null;
        protected List<Header> headers = new ArrayList<Header>();
        protected HttpRequest request = null;
        protected HttpResponse response = null;
        protected Printer printer = null;

        InterceptCommon() {
        }

        public InterceptCommon setPrint(Printer printer) {
            this.printer = printer;
            return this;
        }

        public void clear() {
            this.context = null;
            this.headers.clear();
            this.request = null;
            this.response = null;
        }

        public synchronized HttpRequest getRequest() {
            return this.request;
        }

        public synchronized HttpResponse getResponse() {
            return this.response;
        }

        public synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized HttpEntity getRequestEntity() {
            if (this.request != null && this.request instanceof HttpEntityEnclosingRequest) {
                return ((HttpEntityEnclosingRequest)this.request).getEntity();
            }
            return null;
        }

        synchronized HttpEntity getResponseEntity() {
            if (this.response != null) {
                return this.response.getEntity();
            }
            return null;
        }

        public synchronized List<Header> getHeaders(String key) {
            ArrayList<Header> keyh = new ArrayList<Header>();
            for (Header h2 : this.headers) {
                if (!h2.getName().equalsIgnoreCase(key.trim())) continue;
                keyh.add(h2);
            }
            return keyh;
        }

        public synchronized List<Header> getHeaders() {
            return this.headers;
        }

        public void printHeaders() {
            Header[] hdrs;
            if (this.request != null) {
                DebugInterceptRequest thisreq = (DebugInterceptRequest)this;
                this.printer.println("Request: method=" + thisreq.getMethod() + "; uri=" + thisreq.getUri());
                hdrs = this.request.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                this.printer.println("Request Headers:");
                for (Header h2 : hdrs) {
                    this.printer.println(h2.toString());
                }
            }
            if (this.response != null) {
                DebugInterceptResponse thisresp = (DebugInterceptResponse)this;
                this.printer.println("Response: code=" + thisresp.getStatusCode());
                hdrs = this.response.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                this.printer.println("Response Headers:");
                for (Header h2 : hdrs) {
                    this.printer.println(h2.toString());
                }
            }
        }
    }

    public static interface Printer {
        public void print(String var1);

        public void println(String var1);
    }
}

