/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BioRadSCNReader
extends FormatReader {
    private static final String MAGIC = "Generated by Image Lab";
    private long pixelsOffset;
    private Double gain;
    private Double exposureTime;
    private String imageName;
    private String serialNumber;
    private String acquisitionDate;
    private String binning;
    private String model;
    private Double physicalSizeX;
    private Double physicalSizeY;

    public BioRadSCNReader() {
        super("Bio-Rad SCN", "scn");
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)64, (boolean)false)) {
            return false;
        }
        String check = stream.readString(64);
        return check.indexOf(MAGIC) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(this.pixelsOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.pixelsOffset = 0L;
        this.gain = null;
        this.exposureTime = null;
        this.imageName = null;
        this.serialNumber = null;
        this.acquisitionDate = null;
        this.binning = null;
        this.model = null;
        this.physicalSizeX = null;
        this.physicalSizeY = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        String line = this.in.readLine();
        String currentBoundary = "";
        String currentType = "";
        int currentLength = 0;
        ArrayList<String> xml = new ArrayList<String>();
        while (this.in.getFilePointer() < this.in.length() && line != null) {
            if ((line = line.trim()).startsWith("Content-Type")) {
                currentType = line.substring(line.indexOf(32) + 1);
                int boundary = currentType.indexOf("boundary");
                if (boundary > 0) {
                    currentBoundary = currentType.substring(boundary + 10, currentType.length() - 1);
                }
                if (currentType.indexOf(59) > 0) {
                    currentType = currentType.substring(0, currentType.indexOf(59));
                }
            } else if (line.equals("--" + currentBoundary)) {
                currentLength = 0;
            } else if (line.startsWith("Content-Length")) {
                currentLength = Integer.parseInt(line.substring(line.indexOf(32) + 1));
            } else if (line.length() == 0) {
                if (currentType.equals("application/octet-stream")) {
                    this.pixelsOffset = this.in.getFilePointer();
                    this.in.skipBytes(currentLength);
                } else if (currentType.equals("text/xml")) {
                    String xmlBlock = this.in.readString(currentLength);
                    xml.add(xmlBlock);
                }
            }
            line = this.in.readLine();
        }
        SCNHandler handler = new SCNHandler();
        for (String block : xml) {
            XMLTools.parseXML((String)block, (DefaultHandler)((Object)handler));
        }
        m.sizeZ = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYCZT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (this.exposureTime != null ? 1 : 0) != 0);
        store.setInstrumentID(MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0}), 0);
        if (this.serialNumber != null) {
            store.setMicroscopeSerialNumber(this.serialNumber, 0);
        }
        if (this.model != null) {
            store.setMicroscopeModel(this.model, 0);
        }
        if (this.imageName != null) {
            store.setImageName(this.imageName, 0);
        }
        if (this.acquisitionDate != null) {
            store.setImageAcquisitionDate(new Timestamp(this.acquisitionDate), 0);
        }
        if (this.gain != null || this.binning != null) {
            String detector = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, 0});
            store.setDetectorID(detector, 0, 0);
            store.setDetectorSettingsID(detector, 0, 0);
        }
        if (this.gain != null) {
            store.setDetectorSettingsGain(this.gain, 0, 0);
        }
        if (this.binning != null) {
            store.setDetectorSettingsBinning(MetadataTools.getBinning((String)this.binning), 0, 0);
        }
        if (this.exposureTime != null) {
            store.setPlaneExposureTime(new Time((Number)this.exposureTime, UNITS.SECOND), 0, 0);
        }
        if (this.physicalSizeX != null) {
            store.setPixelsPhysicalSizeX(FormatTools.createLength((Double)this.physicalSizeX, (Unit)UNITS.MICROMETER), 0);
        }
        if (this.physicalSizeY != null) {
            store.setPixelsPhysicalSizeY(FormatTools.createLength((Double)this.physicalSizeY, (Unit)UNITS.MICROMETER), 0);
        }
    }

    class SCNHandler
    extends BaseHandler {
        private String key;

        SCNHandler() {
        }

        public void endElement(String uri, String localName, String qName) {
            this.key = null;
        }

        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            BioRadSCNReader.this.addGlobalMeta(this.key, value);
            if ("endian".equals(this.key)) {
                ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).littleEndian = value.equals("little");
            } else if ("channel_count".equals(this.key)) {
                ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).sizeC = Integer.parseInt(value);
            } else if ("application_gain".equals(this.key)) {
                BioRadSCNReader.this.gain = DataTools.parseDouble((String)value);
            } else if ("exposure_time".equals(this.key)) {
                BioRadSCNReader.this.exposureTime = DataTools.parseDouble((String)value);
            } else if ("name".equals(this.key)) {
                BioRadSCNReader.this.imageName = value;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.key = qName;
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrKey = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                BioRadSCNReader.this.addGlobalMeta(this.key + " " + attrKey, attrValue);
                if (this.key.equals("size_pix")) {
                    if (attrKey.equals("width")) {
                        ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).sizeX = Integer.parseInt(attrValue);
                        continue;
                    }
                    if (!attrKey.equals("height")) continue;
                    ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).sizeY = Integer.parseInt(attrValue);
                    continue;
                }
                if (this.key.equals("scanner")) {
                    if (!attrKey.equals("max_value")) continue;
                    long value = Long.parseLong(attrValue);
                    if (value <= 256L) {
                        ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).pixelType = 1;
                        continue;
                    }
                    if (value > 65535L) continue;
                    ((CoreMetadata)((BioRadSCNReader)BioRadSCNReader.this).core.get((int)0)).pixelType = 3;
                    continue;
                }
                if (this.key.equals("size_mm")) {
                    Double size;
                    if (attrKey.equals("width")) {
                        Double size2 = DataTools.parseDouble((String)attrValue);
                        if (size2 == null) continue;
                        BioRadSCNReader.this.physicalSizeX = size2 / (double)BioRadSCNReader.this.getSizeX();
                        BioRadSCNReader.this.physicalSizeX = BioRadSCNReader.this.physicalSizeX * 1000.0;
                        continue;
                    }
                    if (!attrKey.equals("height") || (size = DataTools.parseDouble((String)attrValue)) == null) continue;
                    BioRadSCNReader.this.physicalSizeY = size / (double)BioRadSCNReader.this.getSizeY();
                    BioRadSCNReader.this.physicalSizeY = BioRadSCNReader.this.physicalSizeY * 1000.0;
                    continue;
                }
                if (this.key.equals("serial_number")) {
                    if (!attrKey.equals("value")) continue;
                    BioRadSCNReader.this.serialNumber = attrValue;
                    continue;
                }
                if (this.key.equals("binning")) {
                    if (!attrKey.equals("value")) continue;
                    BioRadSCNReader.this.binning = attrValue;
                    continue;
                }
                if (this.key.equals("image_date")) {
                    if (!attrKey.equals("value")) continue;
                    BioRadSCNReader.this.acquisitionDate = attrValue;
                    continue;
                }
                if (!this.key.equals("imager") || !attrKey.equals("value")) continue;
                BioRadSCNReader.this.model = attrValue;
            }
        }
    }
}

