/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.NDPIReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.Color;

public class NDPISReader
extends FormatReader {
    private String[] ndpiFiles;
    private ChannelSeparator[] readers;
    private int[] bandUsed;
    private static final int TAG_CHANNEL = 65434;
    private static final int TAG_EMISSION_WAVELENGTH = 65451;
    private static final int METADATA_TAG = 65449;

    public NDPISReader() {
        super("Hamamatsu NDPIS", "ndpis");
        this.domains = new String[]{"Histology"};
        this.datasetDescription = "One .ndpis file and at least one .ndpi file";
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.readers[0].getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.readers[0].getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int[] zct = this.getZCTCoords(no);
        int channel = zct[1];
        this.readers[channel].setId(this.ndpiFiles[channel]);
        this.readers[channel].setCoreIndex(this.getCoreIndex());
        int cIndex = this.bandUsed[channel] < this.readers[channel].getSizeC() ? this.bandUsed[channel] : 0;
        int plane = this.readers[channel].getIndex(zct[0], cIndex, zct[2]);
        this.readers[channel].openBytes(plane, buf, x, y, w, h);
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] files = new String[this.ndpiFiles.length + 1];
        files[0] = this.currentId;
        System.arraycopy(this.ndpiFiles, 0, files, 1, this.ndpiFiles.length);
        return files;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.ndpiFiles = null;
            if (this.readers != null) {
                for (ChannelSeparator reader : this.readers) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        for (String line : lines = DataTools.readFile((String)this.currentId).split("\r\n")) {
            int eq = line.indexOf(61);
            if (eq < 0) continue;
            String key = line.substring(0, eq).trim();
            String value = line.substring(eq + 1).trim();
            if (key.equals("NoImages")) {
                this.ndpiFiles = new String[Integer.parseInt(value)];
                this.readers = new ChannelSeparator[this.ndpiFiles.length];
                continue;
            }
            if (!key.startsWith("Image")) continue;
            int index = Integer.parseInt(key.replaceAll("Image", ""));
            this.ndpiFiles[index] = new Location(parent, value).getAbsolutePath();
            this.readers[index] = new ChannelSeparator((IFormatReader)new NDPIReader());
            this.readers[index].setFlattenedResolutions(this.hasFlattenedResolutions());
        }
        MetadataStore store = this.makeFilterMetadata();
        this.readers[0].getReader().setMetadataStore(store);
        this.readers[0].setId(this.ndpiFiles[0]);
        this.core = new ArrayList(this.readers[0].getCoreMetadataList());
        for (int i = 0; i < this.core.size(); ++i) {
            CoreMetadata ms = (CoreMetadata)this.core.get(i);
            ms.sizeC = this.readers.length;
            ms.rgb = false;
            ms.imageCount = ms.sizeC * ms.sizeZ * ms.sizeT;
        }
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        this.bandUsed = new int[this.ndpiFiles.length];
        for (int c = 0; c < this.readers.length; ++c) {
            String[] metadataLines;
            IFD ifd;
            try (RandomAccessInputStream in = new RandomAccessInputStream(this.ndpiFiles[c]);){
                TiffParser tp = new TiffParser(in);
                ifd = (IFD)tp.getMainIFDs().get(0);
            }
            String channelName = ifd.getIFDStringValue(65434);
            Float wavelength = (Float)ifd.getIFDValue(65451);
            store.setChannelName(channelName, 0, c);
            if (wavelength != null) {
                store.setChannelEmissionWavelength(FormatTools.getEmissionWavelength((Double)wavelength.doubleValue()), 0, c);
            }
            this.bandUsed[c] = 0;
            if (ifd.getSamplesPerPixel() < 3) continue;
            if (wavelength != null) {
                if (380.0f < wavelength.floatValue() && wavelength.floatValue() <= 490.0f) {
                    this.bandUsed[c] = 2;
                } else if (490.0f < wavelength.floatValue() && wavelength.floatValue() <= 580.0f) {
                    this.bandUsed[c] = 1;
                } else if (580.0f < wavelength.floatValue() && wavelength.floatValue() <= 780.0f) {
                    this.bandUsed[c] = 0;
                }
            }
            String extraMetadata = ifd.getIFDStringValue(65449);
            for (String line : metadataLines = extraMetadata.split("\r\n")) {
                String[] pairs;
                if (!line.trim().startsWith(";NDP Shading Data")) continue;
                for (String pair : pairs = line.split(";")) {
                    int eq = pair.indexOf("=");
                    if (eq < 0) continue;
                    String key = pair.substring(0, eq);
                    String value = pair.substring(eq + 1).trim();
                    this.addGlobalMetaList(key, value);
                    if (wavelength == null && key.startsWith("Transmittance") && !value.equals("-")) {
                        this.bandUsed[c] = "RGB".indexOf(key.charAt(key.length() - 1));
                        store.setChannelColor(new Color(this.bandUsed[c] == 0 ? 255 : 0, this.bandUsed[c] == 1 ? 255 : 0, this.bandUsed[c] == 2 ? 255 : 0, 255), 0, c);
                    }
                    if (!key.equals("Name") || value.length() <= 0) continue;
                    store.setChannelName(value, 0, c);
                }
            }
        }
    }
}

