/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.out;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.formats.FormatException;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.IFD;
import loci.formats.utests.out.Plane;
import loci.formats.utests.out.WriterUtilities;
import loci.formats.utests.tiff.TiffWriterMock;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.junit.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TiffWriterTest {
    private IFD ifd;
    private TiffWriter writer;
    private IMetadata metadata;
    final long BIG_TIFF_CUTOFF = 4183818240L;
    private static final byte[] buf = new byte[0x100000];
    private static final int TILE_GRANULARITY = 16;
    private static int percentageOfTilingTests = 0;
    private static int percentageOfSaveBytesTests = 0;

    @DataProvider(name="bigTiffSuffixes")
    public Object[][] createSuffixes() {
        return new Object[][]{{"tf2"}, {"tf8"}, {"btf"}, {"tif"}, {"tiff"}};
    }

    @DataProvider(name="codecs")
    public Object[][] createCodecs() {
        return WriterUtilities.getCodecs();
    }

    @DataProvider(name="tiling")
    public Object[][] createTiling() {
        if (percentageOfTilingTests == 0) {
            return new Object[][]{{0, false, false, 0, 0, 0, null, 0, false}};
        }
        int[] tileSizes = new int[]{1, 32, 43, 64, 160};
        int[] channelCounts = new int[]{1, 3};
        int[] seriesCounts = new int[]{1, 5};
        int[] timeCounts = new int[]{1};
        String[] compressions = new String[]{WriterUtilities.COMPRESSION_UNCOMPRESSED, WriterUtilities.COMPRESSION_LZW, WriterUtilities.COMPRESSION_J2K, WriterUtilities.COMPRESSION_J2K_LOSSY, WriterUtilities.COMPRESSION_JPEG};
        return WriterUtilities.getData(tileSizes, channelCounts, seriesCounts, timeCounts, compressions, percentageOfTilingTests);
    }

    @DataProvider(name="nonTiling")
    public Object[][] createNonTiling() {
        if (percentageOfSaveBytesTests == 0) {
            return new Object[][]{{0, false, false, 0, 0, 0, null, 0, false}};
        }
        int[] tileSizes = new int[]{0};
        int[] channelCounts = new int[]{1, 3};
        int[] seriesCounts = new int[]{1};
        int[] timeCounts = new int[]{1, 5};
        String[] compressions = new String[]{WriterUtilities.COMPRESSION_UNCOMPRESSED, WriterUtilities.COMPRESSION_LZW, WriterUtilities.COMPRESSION_J2K, WriterUtilities.COMPRESSION_J2K_LOSSY, WriterUtilities.COMPRESSION_JPEG};
        return WriterUtilities.getData(tileSizes, channelCounts, seriesCounts, timeCounts, compressions, percentageOfSaveBytesTests);
    }

    @BeforeClass
    public void readProperty() throws Exception {
        percentageOfTilingTests = WriterUtilities.getPropValue("testng.runWriterTilingTests");
        percentageOfSaveBytesTests = WriterUtilities.getPropValue("testng.runWriterSaveBytesTests");
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.ifd = new IFD();
        this.writer = new TiffWriterMock();
        this.metadata = WriterUtilities.createMetadata();
        for (int i = 0; i < 0x100000; ++i) {
            TiffWriterTest.buf[i] = (byte)(i % 255);
        }
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.writer.close();
    }

    @Test
    public void testSetBigTiffFileTooLarge() throws IOException, FormatException {
        boolean thrown;
        block3: {
            this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
            ((TiffWriterMock)this.writer).createOutputBuffer(true);
            long length = 0x100000000L - (long)(buf.length * 4);
            ((TiffWriterMock)this.writer).setBufferLength(length);
            this.writer.setId("test.tiff");
            this.writer.saveBytes(0, buf, this.ifd);
            thrown = false;
            try {
                this.writer.saveBytes(1, buf, this.ifd);
            }
            catch (FormatException e) {
                if (!e.getMessage().contains("File is too large; call setBigTiff(true)")) break block3;
                thrown = true;
            }
        }
        assert (thrown);
    }

    @Test
    public void testSetBigTiff() throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        ((TiffWriterMock)this.writer).createOutputBuffer(true);
        long length = 0x100000000L - (long)(buf.length * 2);
        ((TiffWriterMock)this.writer).setBufferLength(length);
        this.writer.setBigTiff(true);
        this.writer.setId("test.tiff");
        this.writer.saveBytes(0, buf, this.ifd);
    }

    @Test
    public void testSetBigTiffAutomatic() throws IOException, FormatException {
        this.metadata.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1000)), 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        ((TiffWriterMock)this.writer).createOutputBuffer(true);
        long length = 0x100000000L;
        ((TiffWriterMock)this.writer).setBufferLength(length);
        this.writer.setId("test.tiff");
        this.writer.saveBytes(0, buf, this.ifd);
    }

    @Test(dataProvider="bigTiffSuffixes")
    public void testSetBigTiffSuffixes(String suffix) throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        ((TiffWriterMock)this.writer).createOutputBuffer(true);
        long length = 0x100000000L;
        ((TiffWriterMock)this.writer).setBufferLength(length);
        this.writer.setId("test." + suffix);
        boolean thrown = false;
        try {
            this.writer.saveBytes(0, buf, this.ifd);
        }
        catch (FormatException e) {
            thrown = true;
        }
        if (suffix.contains("tif")) {
            org.testng.Assert.assertEquals((boolean)true, (boolean)thrown);
        } else {
            org.testng.Assert.assertEquals((boolean)false, (boolean)thrown);
        }
    }

    @Test(dataProvider="codecs")
    public void testgetPixelTypes(String codec, int[] pixelTypes) {
        Assert.assertArrayEquals((int[])pixelTypes, (int[])this.writer.getPixelTypes(codec));
    }

    @Test
    public void testGetPlaneCount() throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        this.writer.setSeries(0);
        org.testng.Assert.assertEquals((int)80, (int)this.writer.getPlaneCount());
        this.metadata.setPixelsSizeC(new PositiveInteger(Integer.valueOf(4)), 0);
        this.metadata.setPixelsType(PixelType.INT16, 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        org.testng.Assert.assertEquals((int)320, (int)this.writer.getPlaneCount());
    }

    @Test
    public void testGetTileSizeX() throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeX());
        this.writer.close();
        this.writer = new TiffWriter();
        this.metadata.setPixelsSizeX(new PositiveInteger(Integer.valueOf(100)), 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeX());
    }

    @Test
    public void testSetTileSizeX() {
        block5: {
            this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
            try {
                int i;
                for (i = 16; i < 1024; i += 16) {
                    this.writer.setTileSizeX(i);
                    org.testng.Assert.assertEquals((int)i, (int)this.writer.getTileSizeX());
                }
                this.writer.setTileSizeX(1024);
                org.testng.Assert.assertEquals((int)1024, (int)this.writer.getTileSizeX());
                for (i = 1; i < 24; ++i) {
                    this.writer.setTileSizeX(i);
                    org.testng.Assert.assertEquals((int)16, (int)this.writer.getTileSizeX());
                }
                for (i = 24; i < 40; ++i) {
                    this.writer.setTileSizeX(i);
                    org.testng.Assert.assertEquals((int)32, (int)this.writer.getTileSizeX());
                }
            }
            catch (FormatException fe) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testGetTileSizeY() throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeY());
        this.writer.close();
        this.writer = new TiffWriter();
        this.metadata.setPixelsSizeY(new PositiveInteger(Integer.valueOf(100)), 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeY());
    }

    @Test
    public void testSetTileSizeY() {
        block5: {
            this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
            try {
                int i;
                for (i = 16; i < 1024; i += 16) {
                    this.writer.setTileSizeY(i);
                    org.testng.Assert.assertEquals((int)i, (int)this.writer.getTileSizeY());
                }
                this.writer.setTileSizeY(1024);
                org.testng.Assert.assertEquals((int)1024, (int)this.writer.getTileSizeY());
                for (i = 1; i < 24; ++i) {
                    this.writer.setTileSizeY(i);
                    org.testng.Assert.assertEquals((int)16, (int)this.writer.getTileSizeY());
                }
                for (i = 24; i < 40; ++i) {
                    this.writer.setTileSizeY(i);
                    org.testng.Assert.assertEquals((int)32, (int)this.writer.getTileSizeY());
                }
            }
            catch (FormatException fe) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testExplicitlyDisableTiling() {
        block2: {
            try {
                this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
                this.writer.setTileSizeX(0);
                org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeX());
                this.writer.setTileSizeY(0);
                org.testng.Assert.assertEquals((int)0, (int)this.writer.getTileSizeY());
            }
            catch (FormatException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Test
    public void testTileFormatExceptions() {
        boolean thrown;
        block31: {
            int tile_size;
            block30: {
                thrown = false;
                tile_size = 16;
                try {
                    this.writer.setTileSizeY(tile_size);
                }
                catch (FormatException e) {
                    if (!e.getMessage().contains("Size Y must not be null")) break block30;
                    thrown = true;
                }
            }
            assert (thrown);
            thrown = false;
            try {
                this.writer.setTileSizeX(tile_size);
            }
            catch (FormatException e) {
                if (!e.getMessage().contains("Size X must not be null")) break block31;
                thrown = true;
            }
        }
        assert (thrown);
        thrown = false;
        try {
            this.writer.getTileSizeX();
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.getTileSizeY();
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        thrown = false;
        try {
            this.writer.setTileSizeX(0);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.setTileSizeY(0);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.setTileSizeX(1024);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.setTileSizeY(1024);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.setTileSizeX(1040);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
        thrown = false;
        try {
            this.writer.setTileSizeY(1040);
        }
        catch (FormatException e) {
            thrown = true;
        }
        assert (!thrown);
    }

    @Test(dataProvider="tiling")
    public void testSaveBytesTiling(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfTilingTests == 0) {
            return;
        }
        File tmp = File.createTempFile("tiffWriterTest_Tiling", ".tiff");
        tmp.deleteOnExit();
        Plane originalPlane = WriterUtilities.writeImage(tmp, tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
        TiffReader reader = new TiffReader();
        reader.setId(tmp.getAbsolutePath());
        int expectedTileSize = tileSize;
        expectedTileSize = tileSize < 16 ? 16 : Math.round((float)tileSize / 16.0f) * 16;
        IFD tileIFd = (IFD)reader.getIFDs().get(0);
        org.testng.Assert.assertEquals((int)tileIFd.getIFDIntValue(323), (int)expectedTileSize);
        org.testng.Assert.assertEquals((int)tileIFd.getIFDIntValue(322), (int)expectedTileSize);
        WriterUtilities.checkImage(reader, originalPlane, interleaved, rgbChannels, seriesCount, sizeT, compression);
        tmp.delete();
        reader.close();
    }

    @Test(dataProvider="nonTiling")
    public void testSaveBytes(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfSaveBytesTests == 0) {
            return;
        }
        File tmp = File.createTempFile("tiffWriterTest", ".tiff");
        tmp.deleteOnExit();
        Plane originalPlane = WriterUtilities.writeImage(tmp, tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
        TiffReader reader = new TiffReader();
        reader.setId(tmp.getAbsolutePath());
        WriterUtilities.checkImage(reader, originalPlane, interleaved, rgbChannels, seriesCount, sizeT, compression);
        tmp.delete();
        reader.close();
    }

    @Test(dataProvider="nonTiling")
    public void testSaveBytesInMemory(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfSaveBytesTests == 0) {
            return;
        }
        ByteArrayHandle handle = new ByteArrayHandle();
        String id = Math.random() + "-" + System.currentTimeMillis() + ".tif";
        Location.mapFile((String)id, (IRandomAccess)handle);
        Plane originalPlane = WriterUtilities.writeImage(id, tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
        ByteBuffer bytes = handle.getByteBuffer();
        byte[] file = new byte[(int)handle.length()];
        bytes.position(0);
        bytes.get(file);
        handle = new ByteArrayHandle(file);
        Location.mapFile((String)id, (IRandomAccess)handle);
        TiffReader reader = new TiffReader();
        reader.setId(id);
        WriterUtilities.checkImage(reader, originalPlane, interleaved, rgbChannels, seriesCount, sizeT, compression);
        reader.close();
        Location.mapFile((String)id, null);
    }
}

