/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import ome.specification.SchemaResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.ls.LSInput;

@Test(groups={"all"})
public class SchemaResolverTest {
    private static final String[][] SCHEMAS = new String[][]{{"/XMLschemas/OME/FC/2003-FC"}, {"/Schemas/2007-06"}, {"/Schemas/2008-02"}, {"/Schemas/2008-04"}, {"/Schemas/2008-09"}, {"/Schemas/2009-09"}, {"/Schemas/2010-04"}, {"/Schemas/2010-06"}, {"/Schemas/2011-06"}, {"/Schemas/2012-06"}, {"/Schemas/2012-06"}, {"/Schemas/2013-06"}, {"/Schemas/2015-01"}, {"/Schemas/2016-06"}};
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private SchemaResolver resolver = null;

    @BeforeClass
    protected void setUp() throws Exception {
        this.resolver = new SchemaResolver();
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.resolver = null;
    }

    @DataProvider(name="schemas")
    public Object[][] getSchemas() {
        return SCHEMAS;
    }

    @Test(dataProvider="schemas")
    public void testResolution(String schema) {
        String schemaPath = "http://www.openmicroscopy.org" + schema + "/ome.xsd";
        LSInput resolvedSchema = this.resolver.resolveResource((String)null, (String)null, (String)null, schemaPath, (String)null);
        assert (resolvedSchema != null);
    }
}

