/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.utests;

import ome.xml.model.primitives.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimestampTest {
    public static final String TIMESTAMP = "2011-10-20T15:07:14.732Z";
    private final Timestamp a = new Timestamp("2011-10-20T15:07:14.732Z");

    private void assertYMDHMSS(Instant i) {
        LocalDateTime lt = new LocalDateTime((Object)i);
        Assert.assertEquals((int)lt.getYear(), (int)2011);
        Assert.assertEquals((int)lt.getMonthOfYear(), (int)10);
        Assert.assertEquals((int)lt.getDayOfMonth(), (int)20);
        Assert.assertEquals((int)lt.getHourOfDay(), (int)15);
        Assert.assertEquals((int)lt.getMinuteOfHour(), (int)7);
        Assert.assertEquals((int)lt.getSecondOfMinute(), (int)14);
        Assert.assertEquals((int)lt.getMillisOfSecond(), (int)732);
    }

    @Test
    public void testAsInstant() {
        Instant i = this.a.asInstant();
        this.assertYMDHMSS(i);
    }

    @Test
    public void testAsDateTime() {
        DateTime d = this.a.asDateTime(null);
        this.assertYMDHMSS(d.toInstant());
    }

    @Test
    public void testInstantConstructor() {
        Timestamp b = new Timestamp(this.a.asInstant());
        Assert.assertEquals((Object)b, (Object)this.a);
        this.assertYMDHMSS(b.asInstant());
    }

    @Test
    public void testDateTimeConstructor() {
        Timestamp b = new Timestamp(this.a.asDateTime(null));
        Assert.assertEquals((Object)b, (Object)this.a);
        this.assertYMDHMSS(b.asInstant());
    }

    @Test
    public void testString() {
        Timestamp t1 = Timestamp.valueOf((String)"2003-08-26T19:46:38");
        Timestamp t2 = Timestamp.valueOf((String)"2003-08-26T19:46:38.762");
        Timestamp t3 = Timestamp.valueOf((String)"2003-08-26T19:46:38.762Z");
        Timestamp t4 = Timestamp.valueOf((String)"2003-08-26T19:46:38.762+0400");
        Timestamp t5 = Timestamp.valueOf((String)"invalid");
        Timestamp t6 = Timestamp.valueOf((String)"2011-10-20T15:07:14");
        Timestamp t7 = Timestamp.valueOf((String)"2011-10-20T15:07:14Z");
        Timestamp t8 = Timestamp.valueOf((String)"2011-10-20T15:07:14.632Z");
        Assert.assertEquals((String)t1.toString(), (String)"2003-08-26T19:46:38");
        Assert.assertEquals((String)t2.toString(), (String)"2003-08-26T19:46:38.762");
        Assert.assertEquals((String)t3.toString(), (String)"2003-08-26T19:46:38.762");
        Assert.assertEquals((String)t4.toString(), (String)"2003-08-26T15:46:38.762");
        Assert.assertEquals((Object)t5, null);
        Assert.assertEquals((String)t6.toString(), (String)"2011-10-20T15:07:14");
        Assert.assertEquals((String)t7.toString(), (String)"2011-10-20T15:07:14");
        Assert.assertEquals((String)t8.toString(), (String)"2011-10-20T15:07:14.632");
    }
}

