/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model.enums.handlers;

import java.util.Hashtable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsTemperature;

import ome.xml.model.primitives.*;
import ome.units.quantity.Temperature;
import ome.units.unit.Unit;
import ome.units.UNITS;


/**
 * Enumeration handler for UnitsTemperature.
 */
public class UnitsTemperatureEnumHandler implements IEnumerationHandler {

  // -- Constants --

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(UnitsTemperatureEnumHandler.class);

  // -- Fields --

  /** Every UnitsTemperature value must match one of these patterns. */
  private static final Hashtable<String, String> patterns = makePatterns();

  private static Hashtable<String, String> makePatterns() {
    Hashtable<String, String> p = new Hashtable<>();
    // BEGIN Schema enumeration mappings
    p.put("^\\s*°C\\s*", "°C");
    p.put("^\\s*°F\\s*", "°F");
    p.put("^\\s*K\\s*", "K");
    p.put("^\\s*°R\\s*", "°R");
    return p;
  }

  // -- IEnumerationHandler API methods --

  /* @see IEnumerationHandler#getEnumeration(String) */
  public Enumeration getEnumeration(String value)
    throws EnumerationException
  {
    if (value != null) {
      for (String pattern : patterns.keySet()) {
        // case sensitive compare
        if (value.matches(pattern)) {
          String v = patterns.get(pattern);
          return UnitsTemperature.fromString(v);
        }
      }
    }
    LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"",
      "UnitsTemperature", value);
    throw new EnumerationException(this.getClass().getName() +
      " could not find enumeration for " + value);
  }


  @SuppressWarnings("unused")
  public Enumeration getEnumeration(Temperature inUnit)
    throws EnumerationException {
    return getEnumeration(inUnit.unit().getSymbol());
  }

  public static Unit<Temperature> getBaseUnit(UnitsTemperature inModelUnit)
  {
    Unit<Temperature> theResult;
    // begin: should be lookup in template
    theResult = UNITS.KELVIN;
    if (UnitsTemperature.CELSIUS.equals(inModelUnit))
    {
      theResult = UNITS.CELSIUS;
    }
    if (UnitsTemperature.FAHRENHEIT.equals(inModelUnit))
    {
      theResult = UNITS.FAHRENHEIT;
    }
    // Skip default unit KELVIN
    if (UnitsTemperature.RANKINE.equals(inModelUnit))
    {
      theResult = UNITS.RANKINE;
    }
    // end: should be lookup in template
    return theResult;
  }

  public static <T extends PrimitiveNumber> Temperature getQuantity(T inValue, UnitsTemperature inModelUnit)
    throws EnumerationException
  {
    // "Positive" variants are listed before "NonNegative" variants because they extend the "NonNegative" variants and
    // would otherwise be ignored because the "NonNegative" test would be chosen for both "Positive" and "NonNegative"
    // types.  We also process Long before Integer for the same reason since the static analyser also found this led
    // to the Long codepath being picked for the Integer type, though it's not as clear why that is happening.  The
    // current order passes static analysis with all codepaths being correctly visited.
    if (inValue instanceof PercentFraction) {
      PercentFraction typedValue = (PercentFraction) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof PositiveFloat) {
      PositiveFloat typedValue = (PositiveFloat) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof NonNegativeFloat) {
      NonNegativeFloat typedValue = (NonNegativeFloat) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof PositiveLong) {
      PositiveLong typedValue = (PositiveLong) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof NonNegativeLong) {
      NonNegativeLong typedValue = (NonNegativeLong) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof PositiveInteger) {
      PositiveInteger typedValue = (PositiveInteger) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    if (inValue instanceof NonNegativeInteger) {
      NonNegativeInteger typedValue = (NonNegativeInteger) inValue;
      return new ome.units.quantity.Temperature(typedValue.getValue(), getBaseUnit(inModelUnit));
    }
    LOGGER.warn("Unknown type '{}' cannot be used to create a 'Temperature' quantity",
      inValue.getClass().getName());
    throw new EnumerationException("UnitsTemperatureEnumHandler: type '"
      + inValue.getClass().getName() + "' cannot be used to create a quantity");
  }

  public static <T extends Number> Temperature getQuantity(T inValue, UnitsTemperature inModelUnit)
    throws EnumerationException
  {
    if (inValue instanceof Double) {
      Double doubleValue = (Double) inValue;
      return new ome.units.quantity.Temperature(doubleValue, getBaseUnit(inModelUnit));
    }
    if (inValue instanceof Integer) {
      Integer intValue = (Integer) inValue;
      return new ome.units.quantity.Temperature(intValue, getBaseUnit(inModelUnit));
    }
    LOGGER.warn("Unknown type '{}' cannot be used to create a 'Temperature' quantity",
      inValue.getClass().getName());
    throw new EnumerationException("UnitsTemperatureEnumHandler: type '"
      + inValue.getClass().getName() + "' cannot be used to create a quantity");
  }

  /* @see IEnumerationHandler#getEntity() */
  public Class<? extends Enumeration> getEntity() {
    return UnitsTemperature.class;
  }

}
