/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.util.Locale;
import loci.common.DateTools;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DateToolsTest {
    private Locale originalLocale;
    String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    String DATE_FORMAT_AA = "yyyy-MM-dd hh:mm:ss aa";
    String DATE_FORMAT_MS = "yyyy-MM-dd HH:mm:ss:SSS";
    String DATE_FORMAT_MMM = "yyyy-MMM-dd HH:mm:ss Z";
    String DATE_FORMAT_MS_AA = "yyyy-MM-dd hh:mm:ss:SSS aa";
    String REFERENCE_DATE = "1970-01-01 00:00:00";
    String REFERENCE_ISO8601 = "1970-01-01T00:00:00";
    String[] DATE_FORMATS = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss aa"};
    String[] DATE_FORMATS_MS = new String[]{"yyyy:MM:dd HH:mm:ss:SSS", "yyyy-MM-dd HH:mm:ss:SSS", "yyyy-MM-dd hh:mm:ss:SSS aa"};

    @DataProvider(name="times_no_ms")
    public Object[][] createTimes() {
        return new Object[][]{{"1970-01-01 00:00:01", 1000L, "1970-01-01T00:00:01"}, {"1970-01-01 00:01:00", 60000L, "1970-01-01T00:01:00"}, {"1970-01-01 01:00:00", 3600000L, "1970-01-01T01:00:00"}, {"1970-01-02 00:00:00", 86400000L, "1970-01-02T00:00:00"}};
    }

    @DataProvider(name="times_ms_1")
    public Object[][] createTimesMs1() {
        return new Object[][]{{"1970-01-01 00:00:00:1", 100L, "1970-01-01T00:00:00.100"}, {"1970-01-01 00:00:00:10", 100L, "1970-01-01T00:00:00.100"}, {"1970-01-01 00:00:00:100", 100L, "1970-01-01T00:00:00.100"}, {"1970-01-01 00:00:00:010", 10L, "1970-01-01T00:00:00.010"}, {"1970-01-01 00:00:00:001", 1L, "1970-01-01T00:00:00.001"}};
    }

    @DataProvider(name="times_ms_2")
    public Object[][] createTimesMs2() {
        return new Object[][]{{"1970-01-01 00:00:00:1", 1L, "1970-01-01T00:00:00.001"}, {"1970-01-01 00:00:00:10", 10L, "1970-01-01T00:00:00.010"}, {"1970-01-01 00:00:00:100", 100L, "1970-01-01T00:00:00.100"}, {"1970-01-01 00:00:00:010", 10L, "1970-01-01T00:00:00.010"}, {"1970-01-01 00:00:00:001", 1L, "1970-01-01T00:00:00.001"}};
    }

    @DataProvider(name="times_aa")
    public Object[][] createTimesAA() {
        return new Object[][]{{"1970-01-01 01:00:00 AM", 3600000L, "1970-01-01T01:00:00"}, {"1970-01-01 01:00:00 PM", 46800000L, "1970-01-01T13:00:00"}};
    }

    @DataProvider(name="times_ms_aa_1")
    public Object[][] createTimesMsAA1() {
        return new Object[][]{{"1970-01-01 01:00:00:10 AM", 3600100L, "1970-01-01T01:00:00.100"}, {"1970-01-01 01:00:00:10 PM", 46800100L, "1970-01-01T13:00:00.100"}};
    }

    @DataProvider(name="times_ms_aa_2")
    public Object[][] createTimesMsAA2() {
        return new Object[][]{{"1970-01-01 01:00:00:10 AM", 3600010L, "1970-01-01T01:00:00.010"}, {"1970-01-01 01:00:00:10 PM", 46800010L, "1970-01-01T13:00:00.010"}};
    }

    @DataProvider(name="times_ms_separators")
    public Object[][] createTimesSeparators() {
        return new Object[][]{{"1970-01-01 00:00:00:10", 10L, ":", "1970-01-01T00:00:00.010"}, {"1970-01-01 00:00:00.10", 10L, ".", "1970-01-01T00:00:00.010"}, {"1970-01-01 00:00:00-10", 10L, "-", "1970-01-01T00:00:00.010"}};
    }

    @DataProvider(name="timesLocaleDependent")
    public Object[][] createLocaleDependentTimes() {
        return new Object[][]{{"1970-Feb-01 00:00:00 +0000", 2678400000L, "DE"}, {"1970-Feb-01 00:00:00 +0000", 2678400000L, "ES"}, {"1970-Feb-01 00:00:00 +0000", 2678400000L, "FR"}, {"1970-f\u00e9vr.-01 00:00:00 +0000", 2678400000L, "FR"}};
    }

    @BeforeMethod
    public void getLocale() {
        this.originalLocale = Locale.getDefault();
    }

    @AfterMethod
    public void setLocale() {
        Locale.setDefault(this.originalLocale);
    }

    @Test(dataProvider="times_no_ms")
    public void testNoMilliseconds(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, null));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)"."));
    }

    @Test
    public void testInvalidTime() {
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)"wrongdate", (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)"wrongdate", (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)"wrongdate", (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String)this.DATE_FORMAT, (boolean)false));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS, (boolean)false));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS, (boolean)false, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)"wrongdate", (String[])this.DATE_FORMATS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_ms_1")
    public void testTimeMsNoSeparator(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS, (boolean)false));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS, (boolean)false, null));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS, (boolean)false, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_ms_2")
    public void testTimeMsSeparator(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, (String)":"));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (String)":"));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, (String)":"));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, null));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)":"));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)":"));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_aa")
    public void testTimeAa(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false, null));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_ms_aa_1")
    public void testTimeMsAaNoSeparator(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS_AA));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA, (boolean)false));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS_AA, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA, (boolean)false, null));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MS_AA, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_MS_AA, (boolean)false, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (String)"."));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS_MS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_ms_aa_2")
    public void testTimeMsAaSeparator(String date, long ms, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA, (String)":"));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (String)":"));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false, (String)":"));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, null));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false, null));
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_AA, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT_AA, (boolean)false, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)":"));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, null));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)":"));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date, (String[])this.DATE_FORMATS, (boolean)false, (String)"."));
    }

    @Test(dataProvider="times_ms_separators")
    public void testTimeMsSeparators(String date, long ms, String separator, String date2) {
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT, (String)separator));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (String)separator));
        AssertJUnit.assertEquals((String)date2, (String)DateTools.formatDate((String)date, (String)this.DATE_FORMAT, (boolean)false, (String)separator));
    }

    @Test
    public void testDateNoMsWithSeparator() {
        AssertJUnit.assertEquals((long)0L, (long)DateTools.getTime((String)this.REFERENCE_DATE, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)this.REFERENCE_DATE, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)this.REFERENCE_DATE, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
    }

    @Test
    public void testGetTimeConflictingSeparator() {
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)this.REFERENCE_DATE, (String)this.DATE_FORMAT, (String)":"));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)this.REFERENCE_DATE, (String)this.DATE_FORMAT, (String)":"));
    }

    @Test
    public void testUnrecognizedTrailingPattern() {
        String date1 = this.REFERENCE_DATE + ".000 AM";
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date1, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date1, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date1, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
        String date2 = this.REFERENCE_DATE + ".000Z";
        AssertJUnit.assertEquals((long)-1L, (long)DateTools.getTime((String)date2, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date2, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals(null, (String)DateTools.formatDate((String)date2, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
    }

    @Test
    public void testParseLongException() {
        String date1 = this.REFERENCE_DATE + ".a11";
        AssertJUnit.assertEquals((long)0L, (long)DateTools.getTime((String)date1, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date1, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date1, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
        String date2 = this.REFERENCE_DATE + ".a11 aa";
        AssertJUnit.assertEquals((long)0L, (long)DateTools.getTime((String)date2, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date2, (String)this.DATE_FORMAT, (String)"."));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date2, (String)this.DATE_FORMAT, (boolean)false, (String)"."));
    }

    @Test
    public void testTrim() {
        String date1 = " " + this.REFERENCE_DATE;
        AssertJUnit.assertEquals((long)0L, (long)DateTools.getTime((String)date1, (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date1, (String)this.DATE_FORMAT));
        String date2 = this.REFERENCE_DATE + " ";
        AssertJUnit.assertEquals((long)0L, (long)DateTools.getTime((String)date2, (String)this.DATE_FORMAT));
        AssertJUnit.assertEquals((String)this.REFERENCE_ISO8601, (String)DateTools.formatDate((String)date2, (String)this.DATE_FORMAT));
    }

    @Test(dataProvider="timesLocaleDependent")
    public void testParseDate(String date, long ms, String locale) {
        Locale.setDefault(new Locale(locale));
        AssertJUnit.assertEquals((long)ms, (long)DateTools.getTime((String)date, (String)this.DATE_FORMAT_MMM));
    }
}

