/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.File;
import java.io.IOException;
import loci.common.BZip2Handle;
import loci.common.GZipHandle;
import loci.common.ZipHandle;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class TypeDetectionTest {
    @Test
    public void testBZip2TypeDetection() throws IOException {
        File invalidFile = File.createTempFile("invalid", ".bz2");
        invalidFile.deleteOnExit();
        AssertJUnit.assertEquals((boolean)BZip2Handle.isBZip2File((String)invalidFile.getAbsolutePath()), (boolean)false);
    }

    @Test
    public void testGZipTypeDetection() throws IOException {
        File invalidFile = File.createTempFile("invalid", ".gz");
        invalidFile.deleteOnExit();
        AssertJUnit.assertEquals((boolean)GZipHandle.isGZipFile((String)invalidFile.getAbsolutePath()), (boolean)false);
    }

    @Test
    public void testZipTypeDetection() throws IOException {
        File invalidFile = File.createTempFile("invalid", ".zip");
        invalidFile.deleteOnExit();
        AssertJUnit.assertEquals((boolean)ZipHandle.isZipFile((String)invalidFile.getAbsolutePath()), (boolean)false);
    }
}

