/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class CrawlingUtils {
    private static Random random = new Random();

    public static class TDSdatasetReader
    implements Runnable {
        private boolean showDetail;
        private String who;
        private String datasetUrl;
        private CancelTask cancel;

        public TDSdatasetReader(String who, String datasetUrl, CancelTask cancel, boolean showDetail) {
            this.who = who;
            this.datasetUrl = datasetUrl;
            this.cancel = cancel;
            this.showDetail = showDetail;
        }

        @Override
        public void run() {
            int count = 0;
            long total = 0L;
            long time = 0L;
            System.out.printf("TDSdatasetReader %s started url=%s%n", this.who, this.datasetUrl);
            try (NetcdfFile ncfile = NetcdfDataset.openFile(this.datasetUrl, this.cancel);){
                for (Variable var : ncfile.getVariables()) {
                    double rate;
                    long start = System.currentTimeMillis();
                    Array result = this.doLimitedRead(var);
                    long took = System.currentTimeMillis() - start;
                    long size = result.getSize();
                    double d = rate = took == 0L ? 0.0 : (double)size / (double)took / 1000.0;
                    if (this.showDetail) {
                        System.out.printf(" took= %d msecs rate= %f MB/sec%n", took, rate);
                    }
                    total += size;
                    time += took;
                    ++count;
                }
                double totald = (double)total / 1000000.0;
                double rate = time == 0L ? 0.0 : (double)total / (double)time / 1000.0;
                System.out.printf("%n%s%n", ncfile.getLocation());
                System.out.printf(" took= %f secs rate= %f MB/sec%n", totald, rate);
            }
            catch (IOException | InvalidRangeException e) {
                e.printStackTrace();
            }
            System.out.printf(" thread done %d%n", count);
        }

        private Array doLimitedRead(Variable v) throws IOException, InvalidRangeException {
            long size = v.getSize() * (long)v.getElementSize();
            if (size < 1000000L || v.getRank() < 3) {
                if (this.showDetail) {
                    System.out.printf(" thread %s read %s bytes = %d ", this.who, v.getFullName(), size);
                }
                return v.read();
            }
            int rank = v.getRank();
            ArrayList<Range> ranges = new ArrayList<Range>();
            int i = 0;
            for (Dimension dim : v.getDimensions()) {
                if (i < rank - 2) {
                    int first = random.nextInt(dim.getLength());
                    ranges.add(new Range(first, first));
                } else {
                    ranges.add(new Range(0, dim.getLength() - 1));
                }
                ++i;
            }
            Section s2 = new Section(ranges);
            if (this.showDetail) {
                System.out.printf(" thread %s read %s(%s) bytes= %d ", this.who, v.getFullName(), s2, s2.computeSize());
            }
            Array result = v.read(s2);
            assert (result.getSize() == s2.computeSize());
            return result;
        }
    }
}

