/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import ucar.units.BaseQuantity;
import ucar.units.BaseUnit;
import ucar.units.DerivedUnit;
import ucar.units.DerivedUnitImpl;
import ucar.units.Factor;
import ucar.units.NameException;
import ucar.units.OffsetUnit;
import ucar.units.OperationException;
import ucar.units.ParseException;
import ucar.units.Prefix;
import ucar.units.PrefixDB;
import ucar.units.PrefixDBException;
import ucar.units.PrefixDBManager;
import ucar.units.ScaledUnit;
import ucar.units.SimpleCharStream;
import ucar.units.SpecificationException;
import ucar.units.StandardUnitFormatConstants;
import ucar.units.StandardUnitFormatTokenManager;
import ucar.units.TimeScaleUnit;
import ucar.units.Token;
import ucar.units.TokenMgrError;
import ucar.units.Unit;
import ucar.units.UnitClassException;
import ucar.units.UnitDB;
import ucar.units.UnitDBAccessException;
import ucar.units.UnitDBException;
import ucar.units.UnitFormatImpl;
import ucar.units.UnitParseException;
import ucar.units.UnitSystemException;
import ucar.units.UnitSystemManager;
import ucar.units.UnknownUnit;

public final class StandardUnitFormat
extends UnitFormatImpl
implements StandardUnitFormatConstants {
    private static final long serialVersionUID = 2L;
    private static StandardUnitFormat _instance;
    private static final SimpleDateFormat dateFormat;
    private static final Comparator<Factor> factorComparator;
    public StandardUnitFormatTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[36];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private StandardUnitFormat() {
        this(new StringReader(""));
    }

    public static synchronized StandardUnitFormat instance() {
        if (_instance == null) {
            _instance = new StandardUnitFormat();
        }
        return _instance;
    }

    private static boolean isTimeUnit(Unit unit) throws UnitSystemException {
        return unit.isCompatible(UnitSystemManager.instance().getBaseUnit(BaseQuantity.TIME));
    }

    @Override
    public Unit parse(String spec, UnitDB unitDB) throws UnitParseException, SpecificationException, UnitDBException, PrefixDBException, UnitSystemException {
        if (spec == null) {
            throw new UnitParseException(spec);
        }
        this.ReInit(new StringReader(spec.trim()));
        try {
            Unit unit = this.unitSpec(unitDB);
            return unit;
        }
        catch (TokenMgrError e) {
            throw new UnitParseException(spec, e);
        }
        catch (ParseException e) {
            throw new UnitParseException(spec, (Throwable)e);
        }
        catch (OperationException e) {
            throw new SpecificationException(spec, (Throwable)e);
        }
    }

    @Override
    public StringBuffer format(Factor factor, StringBuffer buf) {
        return buf.append(factor.toString());
    }

    @Override
    public StringBuffer format(Unit unit, StringBuffer buf) throws UnitClassException {
        return this.format(unit, buf, true);
    }

    @Override
    public StringBuffer longFormat(Unit unit, StringBuffer buf) throws UnitClassException {
        return this.format(unit, buf, false);
    }

    private StringBuffer format(Unit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        boolean done = false;
        if (!normalize) {
            String id = unit.getSymbol();
            if (id == null) {
                id = unit.getName();
            }
            if (id != null) {
                buf.append(id.replace(' ', '_'));
                done = true;
            }
        }
        if (!done) {
            if (unit instanceof BaseUnit) {
                this.format((BaseUnit)unit, buf);
            } else if (unit instanceof DerivedUnit) {
                this.format((DerivedUnit)unit, buf);
            } else if (unit instanceof ScaledUnit) {
                this.format((ScaledUnit)unit, buf, normalize);
            } else if (unit instanceof OffsetUnit) {
                this.format((OffsetUnit)unit, buf, normalize);
            } else if (unit instanceof TimeScaleUnit) {
                this.format((TimeScaleUnit)unit, buf, normalize);
            } else {
                throw new UnitClassException(unit);
            }
        }
        return buf;
    }

    private StringBuffer format(BaseUnit baseUnit, StringBuffer buf) {
        return buf.append(baseUnit.getSymbol());
    }

    private StringBuffer format(DerivedUnit unit, StringBuffer buf) {
        Factor[] factors = unit.getDimension().getFactors();
        Arrays.sort(factors, factorComparator);
        for (int i = 0; i < factors.length; ++i) {
            this.format(factors[i], buf).append('.');
        }
        if (factors.length != 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf;
    }

    private StringBuffer format(ScaledUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        double scale = unit.getScale();
        if (scale != 0.0) {
            if (scale == 1.0) {
                this.format(unit.getUnit(), buf, normalize);
            } else {
                buf.append(scale).append(' ');
                int start = buf.length();
                this.format(unit.getUnit(), buf, normalize);
                if (start == buf.length()) {
                    buf.setLength(start - 1);
                }
            }
        }
        return buf;
    }

    private StringBuffer format(OffsetUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        double offset = unit.getOffset();
        if (offset != 0.0) {
            int start = buf.length();
            this.format(unit.getUnit(), buf, normalize);
            return (StandardUnitFormat.isBlackSpace(buf, start) ? buf : buf.insert(start, '(').append(')')).append(" @ ").append(offset);
        }
        this.format(unit.getUnit(), buf, normalize);
        return buf;
    }

    private static boolean isBlackSpace(StringBuffer buf, int start) {
        return buf.substring(start).indexOf(32) == -1;
    }

    private StringBuffer format(TimeScaleUnit unit, StringBuffer buf, boolean normalize) throws UnitClassException {
        return this.format(unit.getUnit(), buf, normalize).append(dateFormat.format(unit.getOrigin()));
    }

    private static Unit getUnit(UnitDB unitDB, String string) throws UnitDBAccessException {
        return unitDB.get(string);
    }

    private static Prefix getPrefix(String string) throws PrefixDBException {
        PrefixDB prefixDB = PrefixDBManager.instance();
        Prefix prefix = prefixDB.getPrefixByName(string);
        if (prefix == null) {
            prefix = prefixDB.getPrefixBySymbol(string);
        }
        return prefix;
    }

    public final Unit unitSpec(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit = DerivedUnitImpl.DIMENSIONLESS;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                unit = this.shiftExpr(unitDB);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        return unit;
    }

    public final Unit shiftExpr(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit = this.productExpr(unitDB);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                if (StandardUnitFormat.isTimeUnit(unit)) {
                    Date timestamp = this.timeOriginExpr();
                    unit = unit.shiftTo(timestamp);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 12: {
                        double origin = this.number();
                        unit = unit.shiftTo(origin);
                        break block0;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        return unit;
    }

    public final Unit productExpr(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit;
        block15: {
            unit = this.powerExpr(unitDB);
            block14: while (true) {
                Unit unit2;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        unit2 = this.powerExpr(unitDB);
                        unit = unit.divideBy(unit2);
                        continue block14;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                if (!this.jj_2_1(2)) break;
                block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 12: 
                    case 13: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 12: {
                                this.jj_consume_token(12);
                                break block6;
                            }
                            case 13: {
                                this.jj_consume_token(13);
                                break block6;
                            }
                            case 1: {
                                this.jj_consume_token(1);
                                break block6;
                            }
                        }
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                unit2 = this.powerExpr(unitDB);
                unit = unit.multiplyBy(unit2);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return unit;
    }

    public final Unit powerExpr(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit = this.basicExpr(unitDB);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                int exponent = this.integer();
                unit = unit.raiseTo(exponent);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        return unit;
    }

    public final Unit basicExpr(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        Unit unit;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: 
            case 12: {
                double number = this.number();
                unit = DerivedUnitImpl.DIMENSIONLESS.multiplyBy(number);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                unit = this.unitIdentifier(unitDB);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                unit = this.logExpr(unitDB);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                    }
                }
                unit = this.shiftExpr(unitDB);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return unit;
    }

    public final Unit logExpr(UnitDB unitDB) throws ParseException, OperationException, UnitSystemException, PrefixDBException, UnitDBException {
        double base;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                base = 2.0;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                base = Math.E;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                base = 10.0;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Unit ref = this.productExpr(unitDB);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        return ref.log(base);
    }

    public final double number() throws ParseException {
        double number;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            number = this.real();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 5: {
                    number = this.integer();
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return number;
    }

    public final double real() throws ParseException {
        double udecimal;
        int sign = 1;
        double tenFactor = 1.0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        if (this.jj_2_3(2)) {
            udecimal = this.unsignedDecimal();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: {
                    tenFactor = this.tenFactor();
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break;
                }
            }
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    udecimal = this.unsignedInteger();
                    tenFactor = this.tenFactor();
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return (double)sign * udecimal * tenFactor;
    }

    public final int sign() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                return 1;
            }
            case 3: {
                this.jj_consume_token(3);
                return -1;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double unsignedDecimal() throws ParseException {
        int integer = 0;
        double fraction = 0.0;
        if (this.jj_2_4(3)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    integer = this.unsignedInteger();
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                }
            }
            this.jj_consume_token(12);
            Token token = this.jj_consume_token(5);
            fraction = Double.valueOf("." + token.image);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    integer = this.unsignedInteger();
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return (double)integer + fraction;
    }

    public final double tenFactor() throws ParseException {
        Token token = this.jj_consume_token(10);
        return Double.valueOf("1" + token.image);
    }

    public final int integer() throws ParseException {
        int sign = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        int magnitude = this.unsignedInteger();
        return sign * magnitude;
    }

    public final int unsignedInteger() throws ParseException {
        Token token = this.jj_consume_token(5);
        return Integer.valueOf(token.image);
    }

    public final Unit unitIdentifier(UnitDB unitDB) throws ParseException, UnitDBException, UnitSystemException, PrefixDBException, OperationException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 18: {
                token = this.jj_consume_token(18);
                break;
            }
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = token.image;
        double scale = 1.0;
        Unit unit = StandardUnitFormat.getUnit(unitDB, string);
        while (unit == null) {
            Prefix prefix = StandardUnitFormat.getPrefix(string);
            if (prefix == null) {
                try {
                    unit = UnknownUnit.create(string);
                    break;
                }
                catch (NameException nameException) {
                    // empty catch block
                }
            }
            scale *= prefix.getValue();
            string = string.substring(prefix.length());
            unit = StandardUnitFormat.getUnit(unitDB, string);
        }
        unit = unit.multiplyBy(scale);
        return unit;
    }

    public final Date timeOriginExpr() throws ParseException {
        Calendar calendar = this.dateExpr();
        if (this.jj_2_6(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    break;
                }
                case 1: {
                    this.jj_consume_token(1);
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.clockExpr(calendar);
            if (this.jj_2_5(2)) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                this.zoneExpr(calendar);
            }
        }
        return calendar.getTime();
    }

    public final Calendar dateExpr() throws ParseException {
        int sign = 1;
        int month = 1;
        int day = 1;
        boolean packed = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        int year = this.unsignedInteger();
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                month = this.unsignedInteger();
                packed = false;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 3: {
                        this.jj_consume_token(3);
                        day = this.unsignedInteger();
                        break block3;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        if (packed) {
            if (year >= 10000101) {
                day = year % 100;
                year /= 100;
            }
            if (year >= 100001) {
                month = year % 100;
                year /= 100;
            }
            if (sign < 0) {
                year = -year;
            }
        }
        if (month < 1 || month > 12) {
            throw new ParseException("invalid month in timestamp");
        }
        if (day < 1 || day > 31) {
            throw new ParseException("invalid day in timestamp");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, month - 1, day);
        return calendar;
    }

    public final Calendar clockExpr(Calendar calendar) throws ParseException {
        double hour;
        int minute = 0;
        double seconds = 0.0;
        boolean packed = true;
        if (this.jj_2_7(Integer.MAX_VALUE)) {
            hour = this.unsignedDecimal();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    hour = this.unsignedInteger();
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                minute = this.unsignedInteger();
                packed = false;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        this.jj_consume_token(4);
                        if (this.jj_2_8(Integer.MAX_VALUE)) {
                            seconds = this.unsignedDecimal();
                            break block3;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                seconds = this.unsignedInteger();
                                break block3;
                            }
                        }
                        this.jj_la1[29] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        if (packed) {
            if (hour >= 100000.0) {
                seconds = hour % 100.0;
                hour /= 100.0;
            }
            if (hour >= 1000.0) {
                minute = (int)(hour % 100.0);
                hour /= 100.0;
            }
        }
        if (hour < 0.0 || hour > 23.0) {
            throw new ParseException("invalid hour in timestamp");
        }
        if (minute < 0 || minute > 59) {
            throw new ParseException("invalid minute in timestamp");
        }
        if (seconds < 0.0 || seconds > 61.0) {
            throw new ParseException("invalid seconds in timestamp");
        }
        calendar.set(11, (int)Math.round(hour));
        calendar.set(12, minute);
        int s2 = (int)seconds;
        calendar.set(13, s2);
        int ms = (int)((seconds - (double)s2) * 1000.0);
        calendar.set(14, ms);
        return calendar;
    }

    public final Calendar zoneExpr(Calendar calendar) throws ParseException {
        TimeZone timeZone;
        int sign = 1;
        int zoneMinute = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 5: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: 
                    case 3: {
                        sign = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                int zoneHour = this.unsignedInteger();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 5: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 4: {
                                this.jj_consume_token(4);
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                            }
                        }
                        zoneMinute = this.unsignedInteger();
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                if (zoneHour >= 100) {
                    zoneMinute += zoneHour % 100;
                    zoneHour /= 100;
                }
                if (zoneHour > 23 || zoneMinute > 59) {
                    throw new ParseException("invalid time-zone in timestamp");
                }
                timeZone = TimeZone.getTimeZone("UTC");
                timeZone.setRawOffset(sign * (zoneHour * 60 + zoneMinute) * 60 * 1000);
                break;
            }
            case 18: {
                Token token = this.jj_consume_token(18);
                timeZone = TimeZone.getTimeZone(token.image);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_40() {
        return this.jj_scan_token(21);
    }

    private boolean jj_3R_33() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_41() {
        return this.jj_3R_3();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_8() {
        return this.jj_3R_5();
    }

    private boolean jj_3_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_7();
    }

    private boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_40()) {
                    return true;
                }
            }
        }
        return this.jj_3R_41();
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(1)) {
                return true;
            }
        }
        return this.jj_3R_8();
    }

    private boolean jj_3R_13() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_32();
    }

    private boolean jj_3R_21() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_20() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_6() {
        return this.jj_3R_14();
    }

    private boolean jj_3_7() {
        return this.jj_3R_5();
    }

    private boolean jj_3_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_6()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_19() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_18() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_32() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_17() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_21()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_22()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_35()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3R_25() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_3() {
        if (this.jj_3R_5()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_3() {
        if (this.jj_3R_9()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_10()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_11() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_4() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_12()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_4();
    }

    private boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(18)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(16)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(4)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_27() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_3R_23();
    }

    private boolean jj_3R_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(12)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(13)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(1)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_36() {
        return this.jj_3R_4();
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_2()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_3();
    }

    private boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_16()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_37()) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4133164, 4140, 32768, 4157742, 12290, 12290, 16384, 2048, 2092, 2, 2, 4133164, 0x380000, 2, 44, 12, 1024, 32, 12, 32, 32, 12, 458752, 131074, 2, 12, 8, 8, 32, 32, 16, 16, 12, 16, 48, 262188};
    }

    public StandardUnitFormat(InputStream stream) {
        this(stream, null);
    }

    public StandardUnitFormat(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new StandardUnitFormatTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StandardUnitFormat(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new StandardUnitFormatTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public StandardUnitFormat(StandardUnitFormatTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(StandardUnitFormatTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 36; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t2 = this.token;
        for (int i = 0; i < index; ++i) {
            t2 = t2.next != null ? t2.next : (t2.next = this.token_source.getNextToken());
        }
        return t2;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[22];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 36; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 22; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        factorComparator = new Comparator<Factor>(){

            @Override
            public int compare(Factor f1, Factor f2) {
                int comp = f2.getExponent() - f1.getExponent();
                if (comp == 0) {
                    comp = f1.getID().compareTo(f2.getID());
                }
                return comp;
            }
        };
        dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.applyPattern(" '@' yyyy-MM-dd HH:mm:ss.SSS 'UTC'");
        StandardUnitFormat.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

