/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.MetadataList;
import loci.formats.utests.Elem;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

public class MetadataListTest {
    @Test
    public void testConstructEmpty() {
        MetadataList list = new MetadataList();
        AssertJUnit.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testConstructSize1() {
        MetadataList list = new MetadataList(5);
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{0, 0, 0, 0, 0});
    }

    @Test
    public void testConstructSize2() {
        MetadataList list = new MetadataList(4, 3);
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{3, 3, 3, 3});
    }

    @Test
    public void testConstructSize3() {
        MetadataList list = new MetadataList(new int[]{5, 4, 3, 2, 1, 0});
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{5, 4, 3, 2, 1, 0});
    }

    @Test
    public void testACoreMetadatadd1() {
        MetadataList list = new MetadataList();
        for (int i = 0; i < 3; ++i) {
            list.add();
        }
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{0, 0, 0});
    }

    @Test
    public void testAdd1() {
        MetadataList list = new MetadataList();
        for (int i = 0; i < 2; ++i) {
            list.add((Object)new Elem());
        }
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{1, 1});
    }

    @Test
    public void testAdd2() {
        int[] sizes;
        MetadataList list = new MetadataList();
        for (int s : sizes = new int[]{6, 2, 1, 5, 9, 2, 1}) {
            list.add(s);
        }
        this.checkContainerSize((MetadataList<Elem>)list, sizes);
    }

    @DataProvider(name="itemlist")
    public Object[][] createList() {
        int[][] values0 = new int[][]{};
        int[] expected0 = new int[]{};
        int[][] values1 = new int[][]{{1}};
        int[] expected1 = new int[]{1};
        int[][] values2 = new int[][]{{0, 1, 2}};
        int[] expected2 = new int[]{3};
        int[][] values3 = new int[][]{{1}, {1}, {1}, {1}, {1}, {1}};
        int[] expected3 = new int[]{1, 1, 1, 1, 1, 1};
        int[][] values4 = new int[][]{{0, 1, 2}, {3}, {4, 5}, {6, 7, 8}};
        int[] expected4 = new int[]{3, 1, 2, 3};
        return new Object[][]{{values0, expected0}, {values1, expected1}, {values2, expected2}, {values3, expected3}, {values4, expected4}};
    }

    @Test(dataProvider="itemlist")
    public void testCountsAppend(int[][] data, int[] expected) {
        MetadataList list = new MetadataList();
        for (int i = 0; i < data.length; ++i) {
            list.add();
            for (int j = 0; j < data[i].length; ++j) {
                Elem e = new Elem();
                e.value = data[i][j];
                list.add(i, (Object)e);
            }
        }
        this.checkContainerSize((MetadataList<Elem>)list, expected);
        this.checkContainer((MetadataList<Elem>)list, data);
    }

    @Test(dataProvider="itemlist")
    public void testCountsSized(int[][] data, int[] expected) {
        MetadataList list = new MetadataList(expected);
        ArrayAsserts.assertArrayEquals((int[])expected, (int[])list.sizes());
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                Elem e = new Elem();
                e.value = data[i][j];
                list.set(i, j, (Object)e);
            }
        }
        this.checkContainerSize((MetadataList<Elem>)list, expected);
        this.checkContainer((MetadataList<Elem>)list, data);
    }

    @Test(dataProvider="itemlist")
    public void testCopy(int[][] data, int[] expected) {
        MetadataList list = new MetadataList();
        for (int i = 0; i < data.length; ++i) {
            list.add();
            for (int j = 0; j < data[i].length; ++j) {
                Elem e = new Elem();
                e.value = data[i][j];
                list.add(i, (Object)e);
            }
        }
        MetadataList list2 = new MetadataList(list);
        this.checkContainerSize((MetadataList<Elem>)list, expected);
        this.checkContainer((MetadataList<Elem>)list, data);
        this.checkContainer((MetadataList<Elem>)list2, data);
    }

    @Test
    public void testRemove1() {
        MetadataList list = new MetadataList(new int[]{5, 4, 3, 2, 1, 0});
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{5, 4, 3, 2, 1, 0});
        list.clear();
        this.checkContainerSize((MetadataList<Elem>)list, new int[0]);
    }

    @Test
    public void testRemove2() {
        MetadataList list = new MetadataList(new int[]{5, 4, 3, 2, 1, 0});
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{5, 4, 3, 2, 1, 0});
        list.clear(2);
        list.clear(4);
        this.checkContainerSize((MetadataList<Elem>)list, new int[]{5, 4, 0, 2, 0, 0});
    }

    private void checkContainer(MetadataList<Elem> list, int[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                AssertJUnit.assertEquals((int)((Elem)list.get((int)i, (int)j)).value, (int)data[i][j]);
            }
        }
    }

    private void checkContainerSize(MetadataList<Elem> list, int[] size) {
        AssertJUnit.assertEquals((int)size.length, (int)list.size());
        ArrayAsserts.assertArrayEquals((int[])size, (int[])list.sizes());
        for (int i = 0; i < size.length; ++i) {
            AssertJUnit.assertEquals((int)size[i], (int)list.size(i));
        }
    }
}

