/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.InputStream;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Upgrade200809Test {
    private static final String XML_FILE = "2008-09.ome";
    private OMEXMLService service;
    private String xml;
    private OMEXMLMetadata metadata;
    private OME ome;

    @BeforeMethod
    public void setUp() throws Exception {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        InputStream s = Upgrade200809Test.class.getResourceAsStream(XML_FILE);
        byte[] b = new byte[s.available()];
        s.read(b);
        s.close();
        this.xml = new String(b);
        this.metadata = this.service.createOMEXMLMetadata(this.xml);
        this.ome = (OME)this.metadata.getRoot();
    }

    @Test
    public void getOMEXMLVersion() throws ServiceException {
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)this.metadata));
    }

    @Test
    public void validateUpgrade() throws ServiceException {
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Image image = this.ome.getImage(0);
        Pixels pixels = image.getPixels();
        AssertJUnit.assertNotNull((Object)pixels);
    }

    @Test
    public void testChannelColor() {
        AssertJUnit.assertEquals((int)-1, (int)((Integer)this.metadata.getChannelColor(0, 0).getValue()));
    }

    @Test
    public void testCustomAttributes() throws ServiceException {
        AssertJUnit.assertNotNull((Object)this.ome.getStructuredAnnotations());
        AssertJUnit.assertEquals((int)4, (int)this.metadata.getXMLAnnotationCount());
        String expectedAnnotation = "<OriginalMetadata ID=\"OriginalMetadata:7\" Name=\"Custom Metadata 7\" Value=\"7\"/>";
        AssertJUnit.assertEquals((String)expectedAnnotation, (String)this.metadata.getXMLAnnotationValue(2));
    }
}

