/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.CompressionType;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConversionTest {
    private static final int WIDTH = 64;
    private static final int HEIGHT = 64;
    private static final boolean[] LITTLE_ENDIAN = new boolean[]{true, false};
    private static final String[] DEFAULT_TYPES = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float", "double"};

    private byte[] getPlane(int width, int height, int bytes) {
        byte[] plane = new byte[width * height * bytes];
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = (byte)i;
        }
        return plane;
    }

    private IMetadata createMetadata(String pixelType, int rgbChannels, int seriesCount, boolean littleEndian) throws Exception {
        OMEXMLMetadata metadata;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            metadata = service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        for (int i = 0; i < seriesCount; ++i) {
            MetadataTools.populateMetadata((MetadataStore)metadata, (int)i, (String)("image #" + i), (boolean)littleEndian, (String)"XYCZT", (String)pixelType, (int)64, (int)64, (int)1, (int)rgbChannels, (int)1, (int)rgbChannels);
        }
        return metadata;
    }

    private void testCompressDecompress(String ext, String compression, boolean lossy, int seriesCount, String pixelType) throws Exception {
        this.testCompressDecompress(ext, compression, lossy, 1, seriesCount, pixelType, true);
        this.testCompressDecompress(ext, compression, lossy, 1, seriesCount, pixelType, false);
        this.testCompressDecompress(ext, compression, lossy, 3, seriesCount, pixelType, true);
        this.testCompressDecompress(ext, compression, lossy, 3, seriesCount, pixelType, false);
    }

    private void testCompressDecompress(String ext, String compression, boolean lossy, int rgbChannels, int seriesCount, String pixelType, boolean littleEndian) throws Exception {
        File tmp = File.createTempFile("conversionTest", ext);
        tmp.deleteOnExit();
        ImageWriter writer = new ImageWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)this.createMetadata(pixelType, rgbChannels, seriesCount, littleEndian));
        writer.setId(tmp.getAbsolutePath());
        int bytes = FormatTools.getBytesPerPixel((String)pixelType);
        byte[] plane = this.getPlane(64, 64, bytes * rgbChannels);
        Plane originalPlane = new Plane(plane, littleEndian, !writer.isInterleaved(), rgbChannels, pixelType);
        for (int s = 0; s < seriesCount; ++s) {
            writer.setSeries(s);
            writer.saveBytes(0, plane);
        }
        writer.close();
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        reader.setId(tmp.getAbsolutePath());
        Assert.assertEquals((int)reader.getSeriesCount(), (int)seriesCount);
        for (int s = 0; s < seriesCount; ++s) {
            reader.setSeries(s);
            Assert.assertEquals((int)reader.getSizeC(), (int)rgbChannels);
            Assert.assertTrue((reader.getImageCount() == rgbChannels || reader.isRGB() ? 1 : 0) != 0);
            byte[] readPlane = reader.openBytes(0);
            if (lossy) continue;
            Plane newPlane = new Plane(readPlane, reader.isLittleEndian(), !reader.isInterleaved(), reader.getRGBChannelCount(), FormatTools.getPixelTypeString((int)reader.getPixelType()));
            Assert.assertTrue((boolean)originalPlane.equals(newPlane), (String)tmp.getAbsolutePath());
        }
        reader.close();
    }

    @Test
    public void testTIFF() throws Exception {
        String compression;
        String ext = ".tiff";
        String[] jpegTypes = new String[]{"int8", "uint8", "int16", "uint16"};
        String[] jpeg2000Types = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float"};
        for (String jpegType : jpegTypes) {
            compression = CompressionType.JPEG.getCompression();
            this.testCompressDecompress(ext, compression, true, 1, jpegType);
        }
        for (String jpeg2KType : jpeg2000Types) {
            compression = CompressionType.J2K.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, jpeg2KType);
        }
        for (String type : DEFAULT_TYPES) {
            compression = CompressionType.UNCOMPRESSED.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, type);
            compression = CompressionType.LZW.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, type);
        }
    }

    @Test
    public void testOMETIFF() throws Exception {
        int[] seriesCounts;
        String ext = ".ome.tiff";
        String[] jpegTypes = new String[]{"int8", "uint8", "int16", "uint16"};
        String[] jpeg2000Types = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float"};
        for (int seriesCount : seriesCounts = new int[]{1, 2}) {
            String compression;
            for (String jpegType : jpegTypes) {
                compression = CompressionType.JPEG.getCompression();
                this.testCompressDecompress(ext, compression, true, seriesCount, jpegType);
            }
            for (String jpeg2KType : jpeg2000Types) {
                compression = CompressionType.J2K.getCompression();
                this.testCompressDecompress(ext, compression, false, seriesCount, jpeg2KType);
            }
            for (String type : DEFAULT_TYPES) {
                compression = CompressionType.UNCOMPRESSED.getCompression();
                this.testCompressDecompress(ext, compression, false, seriesCount, type);
                compression = CompressionType.LZW.getCompression();
                this.testCompressDecompress(ext, compression, false, seriesCount, type);
            }
        }
    }

    @Test
    public void testOMEXML() throws Exception {
        String ext = ".ome";
        int[] seriesCounts = new int[]{1, 2};
        String[] types = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float"};
        for (int seriesCount : seriesCounts) {
            for (String type : types) {
                String compression = CompressionType.UNCOMPRESSED.getCompression();
                this.testCompressDecompress(ext, compression, false, seriesCount, type);
                compression = CompressionType.ZLIB.getCompression();
                this.testCompressDecompress(ext, compression, false, seriesCount, type);
            }
        }
    }

    @Test
    public void testAPNG() throws Exception {
        String[] pixelTypes;
        String ext = ".png";
        for (String type : pixelTypes = new String[]{"int8", "uint8", "int16", "uint16"}) {
            String compression = CompressionType.UNCOMPRESSED.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, type);
        }
    }

    @Test
    public void testAVI() throws Exception {
        String ext = ".avi";
        String compression = CompressionType.UNCOMPRESSED.getCompression();
        this.testCompressDecompress(ext, compression, false, 1, "uint8");
    }

    @Test
    public void testEPS() throws Exception {
        String ext = ".eps";
        String compression = CompressionType.UNCOMPRESSED.getCompression();
        this.testCompressDecompress(ext, compression, false, 1, "uint8");
    }

    @Test
    public void testICS() throws Exception {
        String[] pixelTypes;
        String ext = ".ics";
        for (String type : pixelTypes = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float"}) {
            String compression = CompressionType.UNCOMPRESSED.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, type);
        }
    }

    @Test
    public void testJPEG2000() throws Exception {
        String[] pixelTypes;
        String ext = ".jp2";
        for (String type : pixelTypes = new String[]{"int8", "uint8", "int16", "uint16"}) {
            String compression = CompressionType.J2K.getCompression();
            this.testCompressDecompress(ext, compression, false, 1, type);
            compression = CompressionType.J2K_LOSSY.getCompression();
            this.testCompressDecompress(ext, compression, true, 1, type);
        }
    }

    @Test
    public void testJPEG() throws Exception {
        String ext = ".jpg";
        String compression = CompressionType.JPEG.getCompression();
        this.testCompressDecompress(ext, compression, true, 1, "uint8");
    }

    @Test
    public void testQuickTime() throws Exception {
        String ext = ".mov";
        String compression = CompressionType.UNCOMPRESSED.getCompression();
        this.testCompressDecompress(ext, compression, false, 1, "uint8");
    }

    class Plane {
        public ByteBuffer backingBuffer;
        public boolean rgbPlanar;
        public int rgbChannels;
        public String pixelType;

        public Plane(byte[] buffer, boolean littleEndian, boolean planar, int rgbChannels, String pixelType) {
            this.backingBuffer = ByteBuffer.wrap(buffer);
            this.backingBuffer.order(littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            this.rgbPlanar = planar;
            this.pixelType = pixelType;
            this.rgbChannels = rgbChannels;
        }

        public boolean equals(Plane other) {
            this.backingBuffer.position(0);
            other.backingBuffer.position(0);
            int bytes = FormatTools.getBytesPerPixel((String)this.pixelType);
            boolean fp = FormatTools.isFloatingPoint((int)FormatTools.pixelTypeFromString((String)this.pixelType));
            block6: while (this.backingBuffer.position() < this.backingBuffer.capacity()) {
                int otherPos = this.backingBuffer.position();
                if (this.rgbPlanar != other.rgbPlanar) {
                    int channel = -1;
                    int pixel = -1;
                    int pos = this.backingBuffer.position() / bytes;
                    int capacity = this.backingBuffer.capacity();
                    if (this.rgbPlanar) {
                        pixel = pos % (capacity / (this.rgbChannels * bytes));
                        channel = pos / (capacity / (this.rgbChannels * bytes));
                    } else {
                        channel = pos % this.rgbChannels;
                        pixel = pos / this.rgbChannels;
                    }
                    otherPos = other.rgbPlanar ? channel * (capacity / this.rgbChannels) + pixel * bytes : (pixel * this.rgbChannels + channel) * bytes;
                }
                if (otherPos >= other.backingBuffer.capacity()) break;
                other.backingBuffer.position(otherPos);
                switch (bytes) {
                    case 1: {
                        byte thisB = this.backingBuffer.get();
                        byte otherB = other.backingBuffer.get();
                        if (thisB == otherB) break;
                        if (!this.pixelType.equals(other.pixelType)) {
                            if ((byte)(thisB - 128) == otherB) break;
                            return false;
                        }
                        return false;
                    }
                    case 2: {
                        short thisS = this.backingBuffer.getShort();
                        short otherS = other.backingBuffer.getShort();
                        if (thisS == otherS) break;
                        if (!this.pixelType.equals(other.pixelType)) {
                            if ((short)(thisS - 32768) == otherS) break;
                            return false;
                        }
                        return false;
                    }
                    case 4: {
                        int otherI;
                        int thisI;
                        float otherF;
                        float thisF;
                        if (!(fp ? (double)Math.abs((thisF = this.backingBuffer.getFloat()) - (otherF = other.backingBuffer.getFloat())) > 1.0E-6 : (thisI = this.backingBuffer.getInt()) != (otherI = other.backingBuffer.getInt()))) continue block6;
                        return false;
                    }
                    case 8: {
                        long otherL;
                        if (fp) {
                            double otherD;
                            double thisD = this.backingBuffer.getDouble();
                            if (!(Math.abs(thisD - (otherD = other.backingBuffer.getDouble())) > 1.0E-6)) continue block6;
                            return false;
                        }
                        long thisL = this.backingBuffer.getLong();
                        if (thisL == (otherL = other.backingBuffer.getLong())) break;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

