/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.dicom;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomTag;
import loci.formats.dicom.DicomVR;
import loci.formats.in.DicomReader;
import loci.formats.in.FakeReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.out.DicomWriter;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ProvidedMetadataTest {
    public Path doConversion(String jsonMetadata) throws FormatException, IOException {
        Path jsonFile = Files.createTempFile("dicom", ".json", new FileAttribute[0]);
        Path dicomFile = Files.createTempFile("metadata-test", ".dcm", new FileAttribute[0]);
        FakeReader reader = new FakeReader();
        DicomWriter writer = new DicomWriter();
        try {
            Files.write(jsonFile, jsonMetadata.getBytes("UTF-8"), new OpenOption[0]);
            IMetadata meta = MetadataTools.createOMEXMLMetadata();
            reader.setMetadataStore((MetadataStore)meta);
            reader.setId("test.fake");
            writer.setExtraMetadata((Object)jsonFile.toString());
            writer.setMetadataRetrieve((MetadataRetrieve)meta);
            writer.setId(dicomFile.toString());
            writer.saveBytes(0, reader.openBytes(0));
        }
        catch (Throwable e) {
            Files.delete(dicomFile);
            throw e;
        }
        finally {
            reader.close();
            writer.close();
            Files.delete(jsonFile);
        }
        return dicomFile;
    }

    public List<DicomTag> getTags(Path dicomFile) throws FormatException, IOException {
        DicomReader reader = new DicomReader();
        reader.setGroupFiles(false);
        reader.setId(dicomFile.toString());
        List tags = reader.getTags();
        reader.close();
        return tags;
    }

    public DicomTag lookup(List<DicomTag> tags, DicomAttribute attr) {
        for (DicomTag t : tags) {
            if (!attr.equals((Object)t.attribute)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleTagWithDefaults() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"BodyPartExamined\": {\"Value\": \"BRAIN\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.BODY_PART_EXAMINED);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((Object)found.value, (Object)"BRAIN ");
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.CS);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSingleInvalidTagName() throws FormatException, IOException {
        String json = "{\"not a valid tag\": {\"Value\": \"x\"}}";
        this.doConversion(json);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSingleTagWeirdNameWithWhitespace() throws FormatException, IOException {
        String json = "{\"bOdy PaRt examiNeD \": {\"Value\": \"x\"}}";
        this.doConversion(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleTagWeirdName() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"bOdyPaRtexamiNeD\": {\"Value\": \"BRAIN\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.BODY_PART_EXAMINED);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((Object)found.value, (Object)"BRAIN ");
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.CS);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleTagCustomVR() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"BodyPartExamined\": {\"Value\": \"0\",\"VR\": \"SH\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.BODY_PART_EXAMINED);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((Object)found.value, (Object)"0 ");
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.SH);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceExistingTag() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"SpecimenLabelInImage\": {\"Value\": \"NO\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.SPECIMEN_LABEL_IN_IMAGE);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((Object)found.value, (Object)"NO");
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.CS);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreExistingTag() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"SpecimenLabelInImage\": {\"Value\": \"NO\",\"ResolutionStrategy\": \"IGNORE\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.SPECIMEN_LABEL_IN_IMAGE);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((Object)found.value, (Object)"YES ");
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.CS);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceOpticalPath() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"OpticalPathSequence\": {\"Sequence\": {\"IlluminationTypeCodeSequence\": {\"Sequence\": {\"CodeValue\": {\"VR\": \"SH\",\"Value\": \"111743\"},\"CodingSchemeDesignator\": {\"VR\": \"SH\",\"Value\": \"DCM\"},\"CodeMeaning\": {\"VR\": \"LO\",\"Tag\": \"(0008,0104)\",\"Value\": \"Epifluorescence illumination\"}}},\"IlluminationWaveLength\": {\"Value\": \"488.0\"},\"OpticalPathIdentifier\": {\"Value\": \"1\"},\"OpticalPathDescription\": {\"Value\": \"replacement channel\" }},\"ResolutionStrategy\": \"REPLACE\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.OPTICAL_PATH_SEQUENCE);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)found.children.size(), (int)4);
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.SQ);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)0)).attribute, (Object)DicomAttribute.ILLUMINATION_TYPE_CODE_SEQUENCE);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).attribute, (Object)DicomAttribute.ILLUMINATION_WAVELENGTH);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).value, (Object)Float.valueOf(488.0f));
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).attribute, (Object)DicomAttribute.OPTICAL_PATH_ID);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).value, (Object)"1 ");
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).attribute, (Object)DicomAttribute.OPTICAL_PATH_DESCRIPTION);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).value, (Object)"replacement channel ");
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendOpticalPath() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"OpticalPathSequence\": {\"Sequence\": {\"IlluminationTypeCodeSequence\": {\"Sequence\": {\"CodeValue\": {\"VR\": \"SH\",\"Value\": \"111743\"},\"CodingSchemeDesignator\": {\"VR\": \"SH\",\"Value\": \"DCM\"},\"CodeMeaning\": {\"VR\": \"LO\",\"Tag\": \"(0008,0104)\",\"Value\": \"Epifluorescence illumination\"}}},\"IlluminationWaveLength\": {\"Value\": \"488.0\"},\"OpticalPathIdentifier\": {\"Value\": \"1\"},\"OpticalPathDescription\": {\"Value\": \"replacement channel\" }},\"ResolutionStrategy\": \"APPEND\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.OPTICAL_PATH_SEQUENCE);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)found.children.size(), (int)8);
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.SQ);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)0)).attribute, (Object)DicomAttribute.ILLUMINATION_TYPE_CODE_SEQUENCE);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).attribute, (Object)DicomAttribute.ILLUMINATION_WAVELENGTH);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).value, (Object)Float.valueOf(1.0f));
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).attribute, (Object)DicomAttribute.OPTICAL_PATH_ID);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).value, (Object)"0 ");
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).attribute, (Object)DicomAttribute.OPTICAL_PATH_DESCRIPTION);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).value, (Object)"");
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)4)).attribute, (Object)DicomAttribute.ILLUMINATION_TYPE_CODE_SEQUENCE);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)5)).attribute, (Object)DicomAttribute.ILLUMINATION_WAVELENGTH);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)5)).value, (Object)Float.valueOf(488.0f));
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)6)).attribute, (Object)DicomAttribute.OPTICAL_PATH_ID);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)6)).value, (Object)"1 ");
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)7)).attribute, (Object)DicomAttribute.OPTICAL_PATH_DESCRIPTION);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)7)).value, (Object)"replacement channel ");
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreOpticalPath() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"OpticalPathSequence\": {\"Sequence\": {\"IlluminationTypeCodeSequence\": {\"Sequence\": {\"CodeValue\": {\"VR\": \"SH\",\"Value\": \"111743\"},\"CodingSchemeDesignator\": {\"VR\": \"SH\",\"Value\": \"DCM\"},\"CodeMeaning\": {\"VR\": \"LO\",\"Tag\": \"(0008,0104)\",\"Value\": \"Epifluorescence illumination\"}}},\"IlluminationWaveLength\": {\"Value\": \"488.0\"},\"OpticalPathIdentifier\": {\"Value\": \"1\"},\"OpticalPathDescription\": {\"Value\": \"replacement channel\" }},\"ResolutionStrategy\": \"IGNORE\"}}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.OPTICAL_PATH_SEQUENCE);
            AssertJUnit.assertNotNull((Object)found);
            AssertJUnit.assertEquals((int)found.children.size(), (int)4);
            AssertJUnit.assertEquals((Object)found.vr, (Object)DicomVR.SQ);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)0)).attribute, (Object)DicomAttribute.ILLUMINATION_TYPE_CODE_SEQUENCE);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).attribute, (Object)DicomAttribute.ILLUMINATION_WAVELENGTH);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)1)).value, (Object)Float.valueOf(1.0f));
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).attribute, (Object)DicomAttribute.OPTICAL_PATH_ID);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)2)).value, (Object)"0 ");
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).attribute, (Object)DicomAttribute.OPTICAL_PATH_DESCRIPTION);
            AssertJUnit.assertEquals((Object)((DicomTag)found.children.get((int)3)).value, (Object)"");
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreInvalidJSON() throws FormatException, IOException {
        Path dicomFile = null;
        try {
            String json = "{\"BodyPartExamined\": {\"Value\": \"BRAIN\"}";
            dicomFile = this.doConversion(json);
            List<DicomTag> tags = this.getTags(dicomFile);
            DicomTag found = this.lookup(tags, DicomAttribute.BODY_PART_EXAMINED);
            AssertJUnit.assertEquals((Object)found, null);
        }
        catch (Throwable throwable) {
            Files.delete(dicomFile);
            throw throwable;
        }
        Files.delete(dicomFile);
    }
}

