/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import loci.common.IniList;
import loci.common.IniParser;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class MetaSupportAutogen {
    private static final String FORMAT_PAGES = "format-pages.txt";
    private static final String METADATA_SUMMARY = System.getProperty("metadata-summary");
    private static final String MODEL_VERSION = System.getProperty("data-model.version");
    private static final String SPHINX_DIR = System.getProperty("sphinx_builddir");

    public static void main(String[] args) throws Exception {
        boolean success;
        boolean success2;
        File doc = new File("doc");
        if (!doc.exists() && !(success2 = doc.mkdir())) {
            throw new IOException("Could not create " + doc.getAbsolutePath());
        }
        File docMeta = new File(doc, "meta");
        if (!docMeta.exists() && !(success = docMeta.mkdir())) {
            throw new IOException("Could not create " + docMeta.getAbsolutePath());
        }
        VelocityEngine ve = VelocityTools.createEngine();
        VelocityContext context = VelocityTools.createContext();
        MetaSupportList supportList = new MetaSupportList(MODEL_VERSION);
        context.put("q", (Object)supportList);
        IniParser parser = new IniParser();
        parser.setCommentDelimiter(null);
        IniList data = parser.parseINI(FORMAT_PAGES, MetaSupportAutogen.class);
        for (String handler : supportList.handlers()) {
            supportList.setHandler(handler);
            supportList.setPageName("metadata/" + handler);
        }
        VelocityTools.processTemplate(ve, context, "templates/meta-summary.vm", METADATA_SUMMARY);
        for (String handler : supportList.handlers()) {
            supportList.setHandler(handler);
            String pagename = supportList.getPageName();
            if (pagename == null) continue;
            File file = new File(SPHINX_DIR + "/" + pagename + ".rst");
            file.getParentFile().mkdirs();
            VelocityTools.processTemplate(ve, context, "templates/MetadataSupport.vm", SPHINX_DIR + "/" + pagename + ".rst");
        }
    }
}

