/*
 * Decompiled with CFR 0.152.
 */
package ome.metakit.utests;

import java.io.IOException;
import ome.metakit.MetakitException;
import ome.metakit.MetakitReader;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ColumnTest {
    private static final String FILENAME = "src/test/resources/test.mk";
    private static final String INVALID_TABLE = "this cannot be a valid table";
    private MetakitReader reader;

    @BeforeMethod
    public void setUp() throws IOException, MetakitException {
        this.reader = new MetakitReader(System.getProperty("filename", FILENAME));
    }

    @Test
    public void testValidColumnNames() {
        String[] tableNames = this.reader.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            String[] namesByIndex = this.reader.getColumnNames(i);
            String[] namesByName = this.reader.getColumnNames(tableNames[i]);
            AssertJUnit.assertNotNull((Object)namesByIndex);
            AssertJUnit.assertNotNull((Object)namesByName);
            AssertJUnit.assertEquals((int)namesByIndex.length, (int)namesByName.length);
            for (int j = 0; j < namesByIndex.length; ++j) {
                AssertJUnit.assertNotNull((Object)namesByIndex[j]);
                AssertJUnit.assertEquals((String)namesByIndex[j], (String)namesByName[j]);
            }
        }
    }

    @Test
    public void testValidColumnTypes() {
        String[] tableNames = this.reader.getTableNames();
        for (int i = 0; i < tableNames.length; ++i) {
            Class[] typesByIndex = this.reader.getColumnTypes(i);
            Class[] typesByName = this.reader.getColumnTypes(tableNames[i]);
            AssertJUnit.assertNotNull((Object)typesByIndex);
            AssertJUnit.assertNotNull((Object)typesByName);
            AssertJUnit.assertEquals((int)typesByIndex.length, (int)typesByName.length);
            for (int j = 0; j < typesByIndex.length; ++j) {
                AssertJUnit.assertNotNull((Object)typesByIndex[j]);
                AssertJUnit.assertEquals((Object)typesByIndex[j], (Object)typesByName[j]);
            }
        }
    }

    @Test
    public void testColumnCounts() {
        for (int i = 0; i < this.reader.getTableCount(); ++i) {
            String[] names = this.reader.getColumnNames(i);
            Class[] types = this.reader.getColumnTypes(i);
            AssertJUnit.assertNotNull((Object)names);
            AssertJUnit.assertNotNull((Object)types);
            AssertJUnit.assertEquals((int)names.length, (int)types.length);
        }
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testColumnNameTableIndexTooSmall() {
        this.reader.getColumnNames(-1);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testColumnTypeTableIndexTooSmall() {
        this.reader.getColumnTypes(-1);
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testColumnNameTableIndexTooLarge() {
        this.reader.getColumnNames(this.reader.getTableCount());
    }

    @Test(expectedExceptions={ArrayIndexOutOfBoundsException.class})
    public void testColumnTypeTableIndexTooLarge() {
        this.reader.getColumnTypes(this.reader.getTableCount());
    }

    @Test
    public void testColumnNameInvalidTableNames() {
        AssertJUnit.assertNull((Object)this.reader.getColumnNames(null));
        AssertJUnit.assertNull((Object)this.reader.getColumnNames(INVALID_TABLE));
    }

    @Test
    public void testColumnTypeInvalidTableNames() {
        AssertJUnit.assertNull((Object)this.reader.getColumnTypes(null));
        AssertJUnit.assertNull((Object)this.reader.getColumnTypes(INVALID_TABLE));
    }
}

