/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.nio.charset.Charset;
import java.util.Random;
import ome.codecs.CodecOptions;
import ome.codecs.LZWCodec;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class LZWCodecTest {
    LZWCodec codec = new LZWCodec();

    @Test
    public void testCompressShortUniqueSequence() throws Exception {
        byte[] in = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] expected = new byte[]{-128, 0, 0, 32, 32, 24, 16, 10, 6, 3, -126, 1, 32, -88, 8};
        byte[] comp = this.codec.compress(in, null);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }

    @Test
    public void testCompressShortNonUniqueSequence() throws Exception {
        byte[] in = "This is the first day of the rest of your life".getBytes(Charset.forName("UTF-8"));
        byte[] expected = new byte[]{-128, 21, 13, 6, -109, -104, -126, 8, 32, 58, 26, 12, -94, 3, 49, -92, -28, 115, 58, 8, 12, -122, 19, -56, -128, -34, 102, -124, 66, -124, 7, 35, 44, 66, 45, 24, 60, -101, -50, -89, 33, 1, -80, -46, 102, 50, -64, 64};
        byte[] comp = this.codec.compress(in, null);
        AssertJUnit.assertEquals((byte[])expected, (byte[])comp);
    }

    @Test
    public void testCompressUncompressParity() throws Exception {
        for (int j = 0; j < 100; ++j) {
            byte[] in = new byte[50000];
            new Random().nextBytes(in);
            byte[] comp = this.codec.compress(in, null);
            CodecOptions opt = new CodecOptions();
            opt.maxBytes = in.length;
            byte[] out = this.codec.decompress(comp, opt);
            AssertJUnit.assertEquals((byte[])in, (byte[])out);
        }
    }
}

