/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model.enums;

import ome.xml.model.enums.handlers.UnitsFrequencyEnumHandler;
import ome.xml.model.primitives.*;
import ome.units.quantity.Frequency;
import ome.units.unit.Unit;
import ome.units.UNITS;

@SuppressWarnings("SpellCheckingInspection")
public enum UnitsFrequency implements Enumeration
{
  /** yottahertz unit. */
  YOTTAHERTZ("YHz"),
  /** zettahertz unit. */
  ZETTAHERTZ("ZHz"),
  /** exahertz unit. */
  EXAHERTZ("EHz"),
  /** petahertz unit. */
  PETAHERTZ("PHz"),
  /** terahertz unit. */
  TERAHERTZ("THz"),
  /** gigahertz unit. */
  GIGAHERTZ("GHz"),
  /** megahertz unit. */
  MEGAHERTZ("MHz"),
  /** kilohertz unit. */
  KILOHERTZ("kHz"),
  /** hectohertz unit. */
  HECTOHERTZ("hHz"),
  /** decahertz unit. */
  DECAHERTZ("daHz"),
  /** hertz unit. */
  HERTZ("Hz"),
  /** decihertz unit. */
  DECIHERTZ("dHz"),
  /** centihertz unit. */
  CENTIHERTZ("cHz"),
  /** millihertz unit. */
  MILLIHERTZ("mHz"),
  /** microhertz unit. */
  MICROHERTZ("µHz"),
  /** nanohertz unit. */
  NANOHERTZ("nHz"),
  /** picohertz unit. */
  PICOHERTZ("pHz"),
  /** femtohertz unit. */
  FEMTOHERTZ("fHz"),
  /** attohertz unit. */
  ATTOHERTZ("aHz"),
  /** zeptohertz unit. */
  ZEPTOHERTZ("zHz"),
  /** yoctohertz unit. */
  YOCTOHERTZ("yHz");

  UnitsFrequency(String value)
  {
    this.value = value;
  }

  public static UnitsFrequency fromString(String value)
    throws EnumerationException
  {
    if ("YHz".equals(value))
    {
      return YOTTAHERTZ;
    }
    if ("ZHz".equals(value))
    {
      return ZETTAHERTZ;
    }
    if ("EHz".equals(value))
    {
      return EXAHERTZ;
    }
    if ("PHz".equals(value))
    {
      return PETAHERTZ;
    }
    if ("THz".equals(value))
    {
      return TERAHERTZ;
    }
    if ("GHz".equals(value))
    {
      return GIGAHERTZ;
    }
    if ("MHz".equals(value))
    {
      return MEGAHERTZ;
    }
    if ("kHz".equals(value))
    {
      return KILOHERTZ;
    }
    if ("hHz".equals(value))
    {
      return HECTOHERTZ;
    }
    if ("daHz".equals(value))
    {
      return DECAHERTZ;
    }
    if ("Hz".equals(value))
    {
      return HERTZ;
    }
    if ("dHz".equals(value))
    {
      return DECIHERTZ;
    }
    if ("cHz".equals(value))
    {
      return CENTIHERTZ;
    }
    if ("mHz".equals(value))
    {
      return MILLIHERTZ;
    }
    if ("µHz".equals(value))
    {
      return MICROHERTZ;
    }
    if ("nHz".equals(value))
    {
      return NANOHERTZ;
    }
    if ("pHz".equals(value))
    {
      return PICOHERTZ;
    }
    if ("fHz".equals(value))
    {
      return FEMTOHERTZ;
    }
    if ("aHz".equals(value))
    {
      return ATTOHERTZ;
    }
    if ("zHz".equals(value))
    {
      return ZEPTOHERTZ;
    }
    if ("yHz".equals(value))
    {
      return YOCTOHERTZ;
    }

    String s = String.format("'%s' not a supported value of '%s'",
                             value, UnitsFrequency.class);
    throw new EnumerationException(s);
  }

  @SuppressWarnings("unused")
  public String getValue()
  {
    return value;
  }

  @Override
  public String toString()
  {
    return value;
  }

  public static <T extends PrimitiveNumber> Frequency create(T newValue, UnitsFrequency newUnit)
  {
    Frequency theQuantity = null;

    try
    {
      theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
    }
    catch (EnumerationException ignored)
    {
    }

    return theQuantity;
  }

  public static <T extends Number> Frequency create(T newValue, UnitsFrequency newUnit)
  {
    Frequency theQuantity = null;

    try
    {
      theQuantity = UnitsFrequencyEnumHandler.getQuantity(newValue, newUnit);
    }
    catch (EnumerationException ignored)
    {
    }

    return theQuantity;
  }

  private final String value;
}
