/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.out;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CompressionType;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.TiffWriter;
import loci.formats.services.OMEXMLService;
import loci.formats.utests.out.Plane;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.Assert;

public final class WriterUtilities {
    public static final int PLANE_WIDTH = 160;
    public static final int PLANE_HEIGHT = 160;
    public static final int SIZE_X = 1024;
    public static final int SIZE_Y = 1024;
    public static final int SIZE_Z = 4;
    public static final int SIZE_C = 1;
    public static final int SIZE_T = 20;
    public static final String COMPRESSION_UNCOMPRESSED = CompressionType.UNCOMPRESSED.getCompression();
    public static final String COMPRESSION_LZW = CompressionType.LZW.getCompression();
    public static final String COMPRESSION_J2K = CompressionType.J2K.getCompression();
    public static final String COMPRESSION_J2K_LOSSY = CompressionType.J2K_LOSSY.getCompression();
    public static final String COMPRESSION_JPEG = CompressionType.JPEG.getCompression();
    public static final int[] pixelTypesJPEG = new int[]{0, 1, 2, 3};
    public static final int[] pixelTypesJ2K = new int[]{0, 1, 2, 3, 4, 5, 6};
    public static final int[] pixelTypesOther = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int[] pixelTypesICS = new int[]{0, 1, 2, 3, 4, 5, 6};

    public static IMetadata createMetadata(String pixelType, int rgbChannels, int seriesCount, boolean littleEndian, int sizeT) throws Exception {
        OMEXMLMetadata metadata;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            metadata = service.createOMEXMLMetadata();
        }
        catch (DependencyException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        catch (ServiceException exc) {
            throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
        }
        for (int i = 0; i < seriesCount; ++i) {
            MetadataTools.populateMetadata((MetadataStore)metadata, (int)i, (String)("image #" + i), (boolean)littleEndian, (String)"XYCZT", (String)pixelType, (int)160, (int)160, (int)1, (int)rgbChannels, (int)sizeT, (int)rgbChannels);
        }
        return metadata;
    }

    public static Plane writeImage(File file, int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        return WriterUtilities.writeImage(file.getAbsolutePath(), tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
    }

    public static Plane writeImage(String file, int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        TiffWriter writer = new TiffWriter();
        String pixelTypeString = FormatTools.getPixelTypeString((int)pixelType);
        writer.setMetadataRetrieve((MetadataRetrieve)WriterUtilities.createMetadata(pixelTypeString, rgbChannels, seriesCount, littleEndian, sizeT));
        writer.setCompression(compression);
        writer.setInterleaved(interleaved);
        writer.setBigTiff(bigTiff);
        if (tileSize != 0) {
            writer.setTileSizeX(tileSize);
            writer.setTileSizeY(tileSize);
        }
        writer.setId(file);
        int bytes = FormatTools.getBytesPerPixel((int)pixelType);
        byte[] plane = WriterUtilities.getPlane(160, 160, bytes * rgbChannels);
        Plane originalPlane = new Plane(plane, littleEndian, !writer.isInterleaved(), rgbChannels, FormatTools.getPixelTypeString((int)pixelType));
        for (int s = 0; s < seriesCount; ++s) {
            writer.setSeries(s);
            for (int t = 0; t < sizeT; ++t) {
                writer.saveBytes(t, plane);
            }
        }
        writer.close();
        return originalPlane;
    }

    public static void checkImage(TiffReader reader, Plane originalPlane, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression) throws FormatException, IOException {
        for (int s = 0; s < reader.getSeriesCount(); ++s) {
            reader.setSeries(s);
            Assert.assertEquals((int)reader.getSizeC(), (int)rgbChannels);
            int imageCount = reader.isRGB() ? seriesCount * sizeT : rgbChannels * sizeT * seriesCount;
            Assert.assertEquals((int)reader.getImageCount(), (int)imageCount);
            for (int image = 0; image < reader.getImageCount(); ++image) {
                boolean interleavedDiffs;
                byte[] readPlane = reader.openBytes(image);
                boolean lossy = compression.equals(COMPRESSION_JPEG) || compression.equals(COMPRESSION_J2K_LOSSY);
                boolean isJ2K = compression.equals(COMPRESSION_J2K) || compression.equals(COMPRESSION_J2K_LOSSY);
                boolean bl = interleavedDiffs = interleaved || isJ2K && !interleaved;
                if (lossy || interleavedDiffs) continue;
                Plane newPlane = new Plane(readPlane, reader.isLittleEndian(), !reader.isInterleaved(), reader.getRGBChannelCount(), FormatTools.getPixelTypeString((int)reader.getPixelType()));
                assert (originalPlane.equals(newPlane));
            }
        }
    }

    public static byte[] getPlane(int width, int height, int bytes) {
        byte[] plane = new byte[width * height * bytes];
        for (int i = 0; i < plane.length; ++i) {
            plane[i] = (byte)i;
        }
        return plane;
    }

    public static Object[][] getData(int[] tileSizes, int[] channelCounts, int[] seriesCounts, int[] timeCounts, String[] compressions, int percentage) {
        boolean[] booleanValues = new boolean[]{true, false};
        int compressionPixelTypeSizes = 2 * pixelTypesOther.length + pixelTypesOther.length - 1 + pixelTypesJ2K.length + 2;
        int paramSize = tileSizes.length * compressionPixelTypeSizes * 8 * channelCounts.length * seriesCounts.length * timeCounts.length;
        Object[][] data = new Object[paramSize][];
        int index = 0;
        for (int tileSize : tileSizes) {
            for (boolean endianness : booleanValues) {
                for (boolean interleaved : booleanValues) {
                    for (int channelCount : channelCounts) {
                        for (int seriesCount : seriesCounts) {
                            for (int timeCount : timeCounts) {
                                boolean[] blArray = booleanValues;
                                int n = blArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Boolean bigTiff = blArray[i];
                                    for (String compression : compressions) {
                                        int[] pixelTypes = pixelTypesOther;
                                        if (compression.equals(COMPRESSION_J2K)) {
                                            pixelTypes = pixelTypesJ2K;
                                        }
                                        if (compression.equals(COMPRESSION_J2K_LOSSY)) {
                                            pixelTypes = new int[]{0, 1, 2, 3, 4, 5, 6};
                                        } else if (compression.equals(COMPRESSION_JPEG)) {
                                            pixelTypes = new int[]{0, 1};
                                        }
                                        for (int pixelType : pixelTypes) {
                                            data[index] = FormatTools.getBytesPerPixel((int)pixelType) > 2 && (compression.equals(COMPRESSION_J2K) || compression.equals(COMPRESSION_J2K_LOSSY)) ? new Object[]{tileSize, endianness, false, channelCount, seriesCount, timeCount, compression, pixelType, bigTiff} : new Object[]{tileSize, endianness, interleaved, channelCount, seriesCount, timeCount, compression, pixelType, bigTiff};
                                            ++index;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (percentage > 0 && percentage < 100) {
            int numTests = paramSize / 100 * percentage;
            Object[][] returnSubset = new Object[numTests][];
            for (int i = 0; i < numTests; ++i) {
                Random rand = new Random();
                int randIndex = rand.nextInt(paramSize);
                returnSubset[i] = data[randIndex];
            }
            return returnSubset;
        }
        return data;
    }

    public static Object[][] getCodecs() {
        return new Object[][]{{null, pixelTypesOther}, {COMPRESSION_UNCOMPRESSED, pixelTypesOther}, {COMPRESSION_LZW, pixelTypesOther}, {COMPRESSION_J2K, pixelTypesJ2K}, {COMPRESSION_J2K_LOSSY, pixelTypesOther}, {COMPRESSION_JPEG, pixelTypesJPEG}};
    }

    public static int getPropValue(String propertyName) {
        String prop = System.getProperty(propertyName);
        if (prop == null || prop.equals("${" + propertyName + "}")) {
            return 0;
        }
        if (DataTools.parseInteger((String)prop) == null) {
            return 0;
        }
        int propertyValue = DataTools.parseInteger((String)prop);
        if (propertyValue < 0) {
            propertyValue = 0;
        }
        if (propertyValue > 100) {
            propertyValue = 100;
        }
        return propertyValue;
    }

    public static IMetadata createMetadata() throws DependencyException, ServiceException {
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        OMEXMLMetadata metadata = service.createOMEXMLMetadata();
        metadata.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
        metadata.setPixelsSizeX(new PositiveInteger(Integer.valueOf(1024)), 0);
        metadata.setPixelsSizeY(new PositiveInteger(Integer.valueOf(1024)), 0);
        metadata.setPixelsSizeT(new PositiveInteger(Integer.valueOf(20)), 0);
        metadata.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(4)), 0);
        metadata.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
        metadata.setPixelsType(PixelType.UINT8, 0);
        metadata.setPixelsBinDataBigEndian(Boolean.valueOf(true), 0, 0);
        metadata.setImageID("Image:1", 0);
        metadata.setPixelsID("Pixels:1", 0);
        metadata.setChannelID("Channel:1", 0, 0);
        metadata.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, 0);
        return metadata;
    }
}

