/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

public class CBlkInfo {
    public int ulx;
    public int uly;
    public int w;
    public int h;
    public int msbSkipped;
    public int[] len;
    public int[] off;
    public int[] ntp;
    public int ctp;
    public int[][] segLen;
    public int[] pktIdx;

    public CBlkInfo(int ulx, int uly, int w, int h2, int nl) {
        this.ulx = ulx;
        this.uly = uly;
        this.w = w;
        this.h = h2;
        this.off = new int[nl];
        this.len = new int[nl];
        this.ntp = new int[nl];
        this.segLen = new int[nl][];
        this.pktIdx = new int[nl];
        for (int i = nl - 1; i >= 0; --i) {
            this.pktIdx[i] = -1;
        }
    }

    public void addNTP(int l, int newtp) {
        this.ntp[l] = newtp;
        this.ctp = 0;
        for (int lIdx = 0; lIdx <= l; ++lIdx) {
            this.ctp += this.ntp[lIdx];
        }
    }

    public String toString() {
        String string = "(ulx,uly,w,h)= " + this.ulx + "," + this.uly + "," + this.w + "," + this.h;
        string = string + ", " + this.msbSkipped + " MSB bit(s) skipped\n";
        if (this.len != null) {
            for (int i = 0; i < this.len.length; ++i) {
                string = string + "\tl:" + i + ", start:" + this.off[i] + ", len:" + this.len[i] + ", ntp:" + this.ntp[i] + ", pktIdx=" + this.pktIdx[i];
                if (this.segLen != null && this.segLen[i] != null) {
                    string = string + " { ";
                    for (int j = 0; j < this.segLen[i].length; ++j) {
                        string = string + this.segLen[i][j] + " ";
                    }
                    string = string + "}";
                }
                string = string + "\n";
            }
        }
        string = string + "\tctp=" + this.ctp;
        return string;
    }
}

