/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.util.Random;
import ome.codecs.Base64Codec;
import ome.codecs.CodecException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class Base64CodecTest {
    Base64Codec codec = new Base64Codec();

    @Test
    public void testRoundtripShortSequence() throws Exception {
        byte[] in = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        this.roundtrip(in);
    }

    @Test
    public void testRoundtripCheckerboard() throws Exception {
        byte[] in = new byte[]{0, -1, 0, -1, -1, 0, -1, 0, 0, -1, 0, -1, -1, 0, -1, 0};
        this.roundtrip(in);
    }

    @Test
    public void testCompressUncompressParity() throws Exception {
        for (int j = 0; j < 100; ++j) {
            byte[] in = new byte[50000];
            new Random().nextBytes(in);
            this.roundtrip(in);
        }
    }

    private void roundtrip(byte[] in) throws CodecException {
        byte[] encoded = this.codec.compress(in, null);
        byte[] decoded = this.codec.decompress(encoded, null);
        AssertJUnit.assertEquals((byte[])in, (byte[])decoded);
    }
}

