/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;

class ROI {
    public static final int TEXT = 512;
    public static final int SCALE_BAR = 8192;
    public static final int POLYGON = 32;
    public static final int RECTANGLE = 16;
    public static final int LINE = 256;
    public static final int ARROW = 2;
    public static final long METER_MULTIPLY = 1000000L;
    public int type;
    public List<Double> x = new ArrayList<Double>();
    public List<Double> y = new ArrayList<Double>();
    public double transX;
    public double transY;
    public double scaleX;
    public double scaleY;
    public double rotation;
    public long color;
    public int linewidth;
    public String text;
    public String fontName;
    public String fontSize;
    public String name;
    private boolean normalized = false;

    ROI() {
    }

    public void storeROI(MetadataStore store, int series, int roi, int roiIndex, int sizeX, int sizeY, boolean alternateCenter, MetadataLevel level) {
        Length fontSize;
        Double size;
        if (level == MetadataLevel.NO_OVERLAYS || level == MetadataLevel.MINIMUM) {
            return;
        }
        String roiID = MetadataTools.createLSID((String)"ROI", (int[])new int[]{roi});
        store.setImageROIRef(roiID, series, roiIndex);
        store.setROIID(roiID, roi);
        store.setLabelID(MetadataTools.createLSID((String)"Shape", (int[])new int[]{roi, 0}), roi, 0);
        if (this.text == null) {
            this.text = this.name;
        }
        store.setLabelText(this.text, roi, 0);
        if (this.fontSize != null && (size = DataTools.parseDouble((String)this.fontSize)) != null && (fontSize = FormatTools.getFontSize((Integer)size.intValue())) != null) {
            store.setLabelFontSize(fontSize, roi, 0);
        }
        Length l = new Length((Number)this.linewidth, UNITS.PIXEL);
        store.setLabelStrokeWidth(l, roi, 0);
        if (!this.normalized) {
            this.normalize();
        }
        double cornerX = this.x.get(0);
        double cornerY = this.y.get(0);
        store.setLabelX(Double.valueOf(cornerX), roi, 0);
        store.setLabelY(Double.valueOf(cornerY), roi, 0);
        int centerX = sizeX / 2 - 1;
        int centerY = sizeY / 2 - 1;
        double roiX = (double)centerX + this.transX;
        double roiY = (double)centerY + this.transY;
        if (alternateCenter) {
            roiX = this.transX - 2.0 * cornerX;
            roiY = this.transY - 2.0 * cornerY;
        }
        String shapeID = MetadataTools.createLSID((String)"Shape", (int[])new int[]{roi, 1});
        switch (this.type) {
            case 32: {
                StringBuilder points = new StringBuilder();
                for (int i = 0; i < this.x.size(); ++i) {
                    points.append(this.x.get(i) * this.scaleX + roiX);
                    points.append(",");
                    points.append(this.y.get(i) * this.scaleY + roiY);
                    if (i >= this.x.size() - 1) continue;
                    points.append(" ");
                }
                store.setPolygonID(shapeID, roi, 1);
                store.setPolygonPoints(points.toString(), roi, 1);
                break;
            }
            case 16: 
            case 512: {
                store.setRectangleID(shapeID, roi, 1);
                store.setRectangleX(Double.valueOf(roiX - Math.abs(cornerX)), roi, 1);
                store.setRectangleY(Double.valueOf(roiY - Math.abs(cornerY)), roi, 1);
                double width = 2.0 * Math.abs(cornerX);
                double height = 2.0 * Math.abs(cornerY);
                store.setRectangleWidth(Double.valueOf(width), roi, 1);
                store.setRectangleHeight(Double.valueOf(height), roi, 1);
                break;
            }
            case 2: 
            case 256: 
            case 8192: {
                store.setLineID(shapeID, roi, 1);
                store.setLineX1(Double.valueOf(roiX + this.x.get(0)), roi, 1);
                store.setLineY1(Double.valueOf(roiY + this.y.get(0)), roi, 1);
                store.setLineX2(Double.valueOf(roiX + this.x.get(1)), roi, 1);
                store.setLineY2(Double.valueOf(roiY + this.y.get(1)), roi, 1);
            }
        }
    }

    private void normalize() {
        double coordinate;
        int i;
        if (this.normalized) {
            return;
        }
        this.transX *= 1000000.0;
        this.transY *= 1000000.0;
        this.transX *= 1.0;
        this.transY *= 1.0;
        for (i = 0; i < this.x.size(); ++i) {
            coordinate = this.x.get(i) * 1000000.0;
            this.x.set(i, coordinate *= 1.0);
        }
        for (i = 0; i < this.y.size(); ++i) {
            coordinate = this.y.get(i) * 1000000.0;
            this.y.set(i, coordinate *= 1.0);
        }
        this.normalized = true;
    }
}

