/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.nio.ByteOrder;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class EndiannessTest {
    private static final byte[] PAGE = new byte[]{15, 14, 15, 14, 15, 14, 15, 14};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 4;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 4);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
    }

    @Test
    public void testSeekBigEndian() throws IOException {
        this.fileHandle.seek(6L);
        AssertJUnit.assertEquals((int)3854, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekLittleEndian() throws IOException {
        this.fileHandle.setOrder(ByteOrder.LITTLE_ENDIAN);
        this.fileHandle.seek(6L);
        AssertJUnit.assertEquals((int)3599, (int)this.fileHandle.readShort());
    }

    @Test
    public void testReadShortBigEndian() throws IOException {
        AssertJUnit.assertEquals((int)3854, (int)this.fileHandle.readShort());
    }

    @Test
    public void testReadShortLittleEndian() throws IOException {
        this.fileHandle.setOrder(ByteOrder.LITTLE_ENDIAN);
        AssertJUnit.assertEquals((int)3599, (int)this.fileHandle.readShort());
    }

    @Test
    public void testReadIntBigEndian() throws IOException {
        AssertJUnit.assertEquals((int)0xF0E0F0E, (int)this.fileHandle.readInt());
    }

    @Test
    public void testReadIntLittleEndian() throws IOException {
        this.fileHandle.setOrder(ByteOrder.LITTLE_ENDIAN);
        AssertJUnit.assertEquals((int)0xE0F0E0F, (int)this.fileHandle.readInt());
    }

    @Test
    public void testReadLongBigEndian() throws IOException {
        AssertJUnit.assertEquals((long)0xF0E0F0E0F0E0F0EL, (long)this.fileHandle.readLong());
    }

    @Test
    public void testReadLongLittleEndian() throws IOException {
        this.fileHandle.setOrder(ByteOrder.LITTLE_ENDIAN);
        AssertJUnit.assertEquals((long)0xE0F0E0F0E0F0E0FL, (long)this.fileHandle.readLong());
    }
}

