/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.radial.AbstractRadialAdapter;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class UF2RadialAdapter
extends AbstractRadialAdapter {
    private NetcdfDataset ds;
    double latv;
    double lonv;
    double elev;
    DateFormatter formatter = new DateFormatter();

    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ncd, Formatter errlog) {
        String format;
        String convention = ncd.getRootGroup().findAttValueIgnoreCase("Conventions", null);
        if ("_Coordinates".equals(convention) && "UNIVERSALFORMAT".equals(format = ncd.getRootGroup().findAttValueIgnoreCase("Format", null))) {
            return this;
        }
        return null;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) {
        return new UF2RadialAdapter(ncd);
    }

    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public UF2RadialAdapter() {
    }

    public UF2RadialAdapter(NetcdfDataset ds) {
        super(ds);
        this.ds = ds;
        this.desc = "UF 2 radar dataset";
        this.setEarthLocation();
        try {
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect bb;
        if (this.origin == null) {
            return;
        }
        double dLat = Math.toDegrees(this.getMaximumRadialDist() / Earth.getRadius());
        double latRadians = Math.toRadians(this.origin.getLatitude());
        double dLon = dLat * Math.cos(latRadians);
        double lat1 = this.origin.getLatitude() - dLat / 2.0;
        double lon1 = this.origin.getLongitude() - dLon / 2.0;
        this.boundingBox = bb = new LatLonRect(new LatLonPointImpl(lat1, lon1), dLat, dLon);
    }

    double getMaximumRadialDist() {
        double maxdist = 0.0;
        for (VariableSimpleIF dataVariable : this.getDataVariables()) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)dataVariable;
            RadialDatasetSweep.Sweep sp = rv.getSweep(0);
            double dist = (float)sp.getGateNumber() * sp.getGateSize();
            if (!(dist > maxdist)) continue;
            maxdist = dist;
        }
        return maxdist;
    }

    @Override
    protected void setEarthLocation() {
        Attribute ga = this.ds.findGlobalAttribute("StationLatitude");
        this.latv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationLongitude");
        this.lonv = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        ga = this.ds.findGlobalAttribute("StationElevationInMeters");
        this.elev = ga != null ? ga.getNumericValue().doubleValue() : 0.0;
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("instrument_name");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("site_name");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    @Override
    public String getDataFormat() {
        return "Universal Format";
    }

    @Override
    public boolean isVolume() {
        return true;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    protected void setTimeUnits() throws Exception {
        for (CoordinateAxis axis : this.ds.getCoordinateAxes()) {
            if (axis.getAxisType() != AxisType.Time) continue;
            String units = axis.getUnitsString();
            this.dateUnits = new DateUnit(units);
            this.calDateUnits = CalendarDateUnit.of(null, units);
            return;
        }
        this.parseInfo.append("*** Time Units not Found\n");
    }

    @Override
    protected void setStartDate() {
        String start_datetime = this.ds.getRootGroup().findAttValueIgnoreCase("time_coverage_start", null);
        if (start_datetime != null) {
            this.startDate = this.formatter.getISODate(start_datetime);
        } else {
            this.parseInfo.append("*** start_datetime not Found\n");
        }
    }

    @Override
    protected void setEndDate() {
        String end_datetime = this.ds.getRootGroup().findAttValueIgnoreCase("time_coverage_end", null);
        if (end_datetime != null) {
            this.endDate = this.formatter.getISODate(end_datetime);
        } else {
            this.parseInfo.append("*** end_datetime not Found\n");
        }
    }

    @Override
    public void clearDatasetMemory() {
        for (VariableSimpleIF rvar : this.getDataVariables()) {
            RadialDatasetSweep.RadialVariable radVar = (RadialDatasetSweep.RadialVariable)rvar;
            radVar.clearVariableMemory();
        }
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        int rnk = var.getRank();
        if (rnk == 3) {
            rsvar = this.makeRadialVariable(nds, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, Variable v0) {
        return new UF2Variable(nds, v0);
    }

    public String getInfo() {
        String sbuff = "UF2Dataset\n" + super.getDetailInfo() + "\n\n" + this.parseInfo;
        return sbuff;
    }

    private class UF2Variable
    extends AbstractRadialAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        int nsweeps;
        ArrayList<UF2Sweep> sweeps;

        private UF2Variable(NetcdfDataset nds, Variable v0) {
            super(v0.getShortName(), v0);
            this.sweeps = new ArrayList();
            int[] shape = v0.getShape();
            int count = v0.getRank() - 1;
            int ngates = shape[count];
            int nrays = shape[--count];
            this.nsweeps = shape[--count];
            for (int i = 0; i < this.nsweeps; ++i) {
                this.sweeps.add(new UF2Sweep(v0, i, nrays, ngates));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getNumSweeps() {
            return this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return this.sweeps.get(sweepNo);
        }

        public int getNumRadials() {
            return 0;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = this.sweeps.get(this.sweeps.size() - 1);
            Variable v = spn.getsweepVar();
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            return (float[])allData.get1DJavaArray(Float.TYPE);
        }

        @Override
        public void clearVariableMemory() {
        }

        private class UF2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int nrays;
            int ngates;
            int sweepno;
            Variable sweepVar;
            String abbrev;

            UF2Sweep(Variable v, int sweepno, int rays, int gates) {
                this.sweepVar = v;
                this.sweepno = sweepno;
                this.nrays = rays;
                this.ngates = gates;
                this.abbrev = this.sweepVar.attributes().findAttValueIgnoreCase("abbrev", null);
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                return this.sweepData(this.sweepno);
            }

            private float[] sweepData(int swpNumber) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[shape.length];
                origin[0] = swpNumber;
                shape[0] = 1;
                try {
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float[] readData(int ray) throws IOException {
                return this.rayData(this.sweepno, ray);
            }

            public float[] rayData(int swpNumber, int ray) throws IOException {
                int[] shape = this.sweepVar.getShape();
                int[] origin = new int[shape.length];
                origin[0] = swpNumber;
                origin[1] = ray;
                shape[0] = 1;
                shape[1] = 1;
                try {
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            public void setMeanElevation() {
                String eleName = "elevation" + this.abbrev;
                this.setMeanEle(eleName, this.sweepno);
            }

            private void setMeanEle(String elevName, int swpNumber) {
                try {
                    float[] eleData = this.getEle(elevName, swpNumber);
                    float sum = 0.0f;
                    int sumSize = 0;
                    for (float v : eleData) {
                        if (Float.isNaN(v)) continue;
                        sum += v;
                        ++sumSize;
                    }
                    if (sumSize > 0) {
                        this.meanElevation = sum / (float)sumSize;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            public double meanDouble(Array a) {
                double sum = 0.0;
                int size = 0;
                IndexIterator iterA = a.getIndexIterator();
                while (iterA.hasNext()) {
                    double s2 = iterA.getDoubleNext();
                    if (Double.isNaN(s2)) continue;
                    sum += s2;
                    ++size;
                }
                if (size > 0) {
                    return sum / (double)size;
                }
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.nrays;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return UF2RadialAdapter.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return UF2RadialAdapter.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return UF2RadialAdapter.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            public void setMeanAzimuth() {
                String aziName = "azimuth" + this.abbrev;
                this.setMeanAzi(aziName, this.sweepno);
            }

            private void setMeanAzi(String aziName, int swpNumber) {
                if (this.getType() != null) {
                    try {
                        Array data = UF2RadialAdapter.this.ds.findVariable(aziName).read();
                        int[] aziOrigin = new int[]{swpNumber, 0};
                        int[] aziShape = new int[]{1, this.getRadialNumber()};
                        Array aziData = data.section(aziOrigin, aziShape);
                        this.meanAzimuth = MAMath.sumDouble(aziData) / (double)aziData.getSize();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.meanAzimuth = 0.0;
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.meanAzimuth = 0.0;
                }
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                String eleName = "elevation" + this.abbrev;
                return this.getEle(eleName, this.sweepno, ray);
            }

            public float getEle(String elevName, int swpNumber, int ray) throws IOException {
                float[] eleData = this.getEle(elevName, swpNumber);
                return eleData[ray];
            }

            @Override
            public float[] getElevation() throws IOException {
                String eleName = "elevation" + this.abbrev;
                return this.getEle(eleName, this.sweepno);
            }

            public float[] getEle(String elevName, int swpNumber) throws IOException {
                try {
                    Array eleData = UF2RadialAdapter.this.ds.findVariable(elevName).read();
                    int[] eleOrigin = new int[]{swpNumber, 0};
                    int[] eleShape = new int[]{1, this.getRadialNumber()};
                    eleData = eleData.section(eleOrigin, eleShape);
                    return (float[])eleData.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float[] getAzimuth() throws IOException {
                String aziName = "azimuth" + this.abbrev;
                return this.getAzi(aziName, this.sweepno);
            }

            public float[] getAzi(String aziName, int swpNumber) throws IOException {
                try {
                    Array aziData = UF2RadialAdapter.this.ds.findVariable(aziName).read();
                    int[] aziOrigin = new int[]{swpNumber, 0};
                    int[] aziShape = new int[]{1, this.getRadialNumber()};
                    aziData = aziData.section(aziOrigin, aziShape);
                    return (float[])aziData.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                String aziName = "azimuth" + this.abbrev;
                return this.getAzi(aziName, this.sweepno, ray);
            }

            public float getAzi(String aziName, int swpNumber, int ray) throws IOException {
                float[] aziData = this.getAzi(aziName, swpNumber);
                return aziData[ray];
            }

            public float getRadialDistance(int gate) throws IOException {
                String disName = "distance" + this.abbrev;
                return this.getRadialDist(disName, gate);
            }

            public float getRadialDist(String dName, int gate) throws IOException {
                Array data = UF2RadialAdapter.this.ds.findVariable(dName).read();
                Index index = data.getIndex();
                return data.getFloat(index.set(gate));
            }

            @Override
            public float getTime(int ray) throws IOException {
                String tName = "time" + this.abbrev;
                return this.getT(tName, this.sweepno, ray);
            }

            public float getT(String tName, int swpNumber, int ray) throws IOException {
                Array timeData = UF2RadialAdapter.this.ds.findVariable(tName).read();
                Index timeIndex = timeData.getIndex();
                return timeData.getFloat(timeIndex.set(swpNumber, ray));
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    return this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

