/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureMembers;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.PointFeatureImpl;

public class PointFeatureCopyFactory {
    private static final int POINTER_SIZE = 8;
    private static final int OBJECT_SIZE = 40;
    private static final int ARRAY_SIZE = 8;
    private final StructureMembers sm;
    private final int sizeInBytes;

    public PointFeatureCopyFactory(PointFeature proto) throws IOException {
        StructureData sdata = proto.getFeatureData();
        this.sm = new StructureMembers(sdata.getStructureMembers());
        this.sizeInBytes = 364 + this.sm.getStructureSize();
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public PointFeature deepCopy(PointFeature from) throws IOException {
        PointFeatureCopy deep = new PointFeatureCopy(from);
        deep.data = StructureDataDeep.copy(from.getFeatureData(), this.sm);
        return deep;
    }

    private static class PointFeatureCopy
    extends PointFeatureImpl {
        StructureData data;

        PointFeatureCopy(PointFeature pf) {
            super(pf.getFeatureCollection(), pf.getLocation(), pf.getObservationTime(), pf.getNominalTime(), pf.getFeatureCollection().getTimeUnit());
        }

        @Override
        @Nonnull
        public StructureData getDataAll() {
            return this.data;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.data;
        }
    }
}

