/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class AtmosSigma
extends VerticalTransformImpl {
    public static final String PTOP = "PressureTop_variableName";
    public static final String PS = "SurfacePressure_variableName";
    public static final String SIGMA = "Sigma_variableName";
    private Variable psVar;
    private double[] sigma;
    private double ptop;

    public AtmosSigma(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String psName = this.getParameterStringValue(params, PS);
        this.psVar = ds.findVariable(psName);
        String ptopName = this.getParameterStringValue(params, PTOP);
        Variable ptopVar = ds.findVariable(ptopName);
        try {
            this.ptop = ptopVar.readScalarDouble();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosSigma failed to read " + ptopVar + " err= " + e.getMessage());
        }
        String sigmaName = this.getParameterStringValue(params, SIGMA);
        Variable sigmaVar = ds.findVariable(sigmaName);
        try {
            Array data = sigmaVar.read();
            this.sigma = (double[])data.get1DJavaArray(Double.TYPE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AtmosSigma failed to read " + sigmaName + " err= " + e.getMessage());
        }
        this.units = this.psVar.findAttValueIgnoreCase("units", "none");
        String ptopUnitStr = ptopVar.findAttValueIgnoreCase("units", "none");
        if (!this.units.equalsIgnoreCase(ptopUnitStr)) {
            SimpleUnit psUnit = SimpleUnit.factory(this.units);
            SimpleUnit ptopUnit = SimpleUnit.factory(ptopUnitStr);
            double factor = ptopUnit.convertTo(1.0, psUnit);
            this.ptop *= factor;
        }
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array ps = this.readArray(this.psVar, timeIndex);
        Index psIndex = ps.getIndex();
        int nz = this.sigma.length;
        int[] shape2D = ps.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        ArrayDouble.D3 result = new ArrayDouble.D3(nz, ny, nx);
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double psVal = ps.getDouble(psIndex.set(y, x));
                for (int z = 0; z < nz; ++z) {
                    result.set(z, y, x, this.ptop + this.sigma[z] * (psVal - this.ptop));
                }
            }
        }
        return result;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array ps = this.readArray(this.psVar, timeIndex);
        Index psIndex = ps.getIndex();
        int nz = this.sigma.length;
        ArrayDouble.D1 result = new ArrayDouble.D1(nz);
        double psVal = ps.getDouble(psIndex.set(yIndex, xIndex));
        for (int z = 0; z < nz; ++z) {
            result.set(z, this.ptop + this.sigma[z] * (psVal - this.ptop));
        }
        return result;
    }
}

