/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;

public class FileExportSPW {
    private final int sizeT = 3;
    private final int rows = 2;
    private final int cols = 2;
    private final int fovPerWell = 2;
    private ImageWriter writer;
    private final String outputFile;

    public FileExportSPW(String outputFile) {
        this.outputFile = outputFile;
    }

    public void export() {
        int width = 4;
        int height = 4;
        int pixelType = 3;
        Object exception = null;
        IMetadata omexml = this.initializeMetadata(width, height, pixelType);
        int series = 0;
        int nSeries = 8;
        boolean initializationSuccess = this.initializeWriter(omexml);
        if (initializationSuccess) {
            while (series < nSeries) {
                for (int p = 0; p < 3; ++p) {
                    this.savePlane(width, height, pixelType, p, series);
                }
                if (++series >= nSeries) continue;
                try {
                    this.writer.setSeries(series);
                }
                catch (FormatException e) {
                    System.err.println("Fatal error unable to select correct image in series! " + e.getMessage());
                    break;
                }
            }
        }
        this.cleanup();
    }

    private boolean initializeWriter(IMetadata omexml) {
        this.writer = new ImageWriter();
        this.writer.setMetadataRetrieve((MetadataRetrieve)omexml);
        Throwable exception = null;
        try {
            this.writer.setId(this.outputFile);
        }
        catch (FormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            System.err.println("Failed to initialize file writer.");
            exception.printStackTrace();
        }
        return exception == null;
    }

    private IMetadata initializeMetadata(int width, int height, int pixelType) {
        Throwable exception = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            meta.createRoot();
            int plateIndex = 0;
            int series = 0;
            int well = 0;
            meta.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
            meta.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
            meta.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
            meta.setPlateRows(new PositiveInteger(Integer.valueOf(2)), 0);
            meta.setPlateColumns(new PositiveInteger(Integer.valueOf(2)), 0);
            meta.setPlateName("First test Plate", 0);
            PositiveInteger pwidth = new PositiveInteger(Integer.valueOf(width));
            PositiveInteger pheight = new PositiveInteger(Integer.valueOf(height));
            char rowChar = 'A';
            for (int row = 0; row < 2; ++row) {
                for (int column = 0; column < 2; ++column) {
                    String wellID = MetadataTools.createLSID((String)"Well:", (int[])new int[]{well});
                    meta.setWellID(wellID, plateIndex, well);
                    meta.setWellRow(new NonNegativeInteger(Integer.valueOf(row)), plateIndex, well);
                    meta.setWellColumn(new NonNegativeInteger(Integer.valueOf(column)), plateIndex, well);
                    for (int fov = 0; fov < 2; ++fov) {
                        String imageName = rowChar + ":" + Integer.toString(column + 1) + ":FOV:" + Integer.toString(fov + 1);
                        String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{well, fov});
                        meta.setImageID(imageID, series);
                        meta.setImageName(imageName, series);
                        String pixelsID = MetadataTools.createLSID((String)"Pixels", (int[])new int[]{row, well, fov});
                        meta.setPixelsID(pixelsID, series);
                        meta.setPixelsBinDataBigEndian(Boolean.TRUE, series, 0);
                        meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, series);
                        meta.setPixelsType(PixelType.fromString((String)FormatTools.getPixelTypeString((int)pixelType)), series);
                        meta.setPixelsSizeX(pwidth, series);
                        meta.setPixelsSizeY(pheight, series);
                        meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), series);
                        meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), series);
                        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(3)), series);
                        String channelID = MetadataTools.createLSID((String)"Channel", (int[])new int[]{well, fov});
                        meta.setChannelID(channelID, series, 0);
                        meta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), series, 0);
                        String wellSampleID = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{well, fov});
                        meta.setWellSampleID(wellSampleID, 0, well, fov);
                        meta.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(series)), 0, well, fov);
                        meta.setWellSampleImageRef(imageID, 0, well, fov);
                        ++series;
                    }
                    ++well;
                }
                rowChar = (char)(rowChar + 1);
            }
            return meta;
        }
        catch (DependencyException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (EnumerationException e) {
            exception = e;
        }
        System.err.println("Failed to populate OME-XML metadata object.");
        exception.printStackTrace();
        return null;
    }

    private CoreMetadata createModuloAnn() {
        CoreMetadata modlo = new CoreMetadata();
        modlo.moduloT.type = "Lifetime";
        modlo.moduloT.unit = "ps";
        modlo.moduloT.typeDescription = "Gated";
        modlo.moduloT.labels = new String[3];
        for (int i = 0; i < 3; ++i) {
            modlo.moduloT.labels[i] = Integer.toString(i * 1000);
        }
        return modlo;
    }

    private void savePlane(int width, int height, int pixelType, int index, int series) {
        byte[] plane = this.createImage(width, height, pixelType, index, series);
        Throwable exception = null;
        try {
            this.writer.saveBytes(index, plane);
        }
        catch (FormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            System.err.println("Failed to save plane.");
            exception.printStackTrace();
        }
    }

    private byte[] createImage(int width, int height, int pixelType, int index, int series) {
        int bpp = FormatTools.getBytesPerPixel((int)pixelType);
        byte[] img = new byte[width * height * bpp];
        ByteBuffer bb = ByteBuffer.wrap(img);
        bb.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < img.length; i += bpp) {
            bb.putShort(i, (short)200);
        }
        switch (index) {
            case 0: {
                bb.putShort(series * bpp, (short)1000);
                break;
            }
            case 1: {
                bb.putShort(series * bpp, (short)700);
                break;
            }
            case 2: {
                bb.putShort(series * bpp, (short)300);
            }
        }
        return img;
    }

    private void cleanup() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close file writer. " + e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        String fileName = args[0];
        File file = new File(fileName);
        Object exception = null;
        if (file.exists()) {
            file.delete();
        }
        FileExportSPW exporter = new FileExportSPW(fileName);
        exporter.export();
    }
}

