/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.Codec;
import loci.formats.codec.CompressionType;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;

public class PrecompressedTileReaderWriter {
    private IFormatReader reader;
    private IFormatWriter writer;
    private String inputFile;
    private String outputFile;
    private String compression;

    public PrecompressedTileReaderWriter(String inputFile, String outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
    }

    private void initialize() throws DependencyException, FormatException, IOException, ServiceException {
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata omexml = service.createOMEXMLMetadata();
        ImageReader baseReader = new ImageReader();
        baseReader.setFlattenedResolutions(false);
        baseReader.setMetadataStore((MetadataStore)omexml);
        baseReader.setId(this.inputFile);
        this.reader = baseReader.getReader();
        MetadataTools.populatePixelsOnly((MetadataStore)omexml, (IFormatReader)this.reader);
        IFormatReader tileReader = this.reader;
        CompressionType type = CompressionType.get((Codec)tileReader.getTileCodec(0));
        this.compression = type.getCompression();
        ImageWriter baseWriter = new ImageWriter();
        baseWriter.setWriteSequentially(true);
        baseWriter.setMetadataRetrieve((MetadataRetrieve)omexml);
        baseWriter.setTileSizeX(this.reader.getOptimalTileWidth());
        baseWriter.setTileSizeY(this.reader.getOptimalTileHeight());
        baseWriter.setId(this.outputFile);
        this.writer = baseWriter.getWriter();
        this.writer.setCompression(this.compression);
    }

    public void readWriteTiles() throws FormatException, IOException {
        byte[] buf = null;
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            this.writer.setSeries(series);
            for (int res = 0; res < this.reader.getResolutionCount(); ++res) {
                int image;
                this.reader.setResolution(res);
                this.writer.setResolution(res);
                int tileWidth = this.reader.getOptimalTileWidth();
                int tileHeight = this.reader.getOptimalTileHeight();
                int tw = this.writer.setTileSizeX(tileWidth);
                int th = this.writer.setTileSizeY(tileHeight);
                if (!FormatTools.canUsePrecompressedTiles((IFormatReader)this.reader, (IFormatWriter)this.writer, (int)series, (int)res)) {
                    System.out.println("Cannot use precompressed tiles for series " + series + ", resolution " + res);
                    this.writer.setInterleaved(this.reader.isInterleaved());
                    for (image = 0; image < this.reader.getImageCount(); ++image) {
                        for (int y = 0; y < this.reader.getSizeY(); y += th) {
                            int height = Math.min(th, this.reader.getSizeY() - y);
                            for (int x = 0; x < this.reader.getSizeX(); x += tw) {
                                int width = Math.min(tw, this.reader.getSizeX() - x);
                                buf = this.reader.openBytes(image, x, y, width, height);
                                this.writer.saveBytes(image, buf, x, y, width, height);
                            }
                        }
                    }
                    continue;
                }
                this.writer.setInterleaved(this.reader.isInterleaved() || this.compression.startsWith("JPEG"));
                for (image = 0; image < this.reader.getImageCount(); ++image) {
                    IFormatReader tileReader = this.reader;
                    int nXTiles = tileReader.getTileColumns(image);
                    int nYTiles = tileReader.getTileRows(image);
                    for (int y = 0; y < nYTiles; ++y) {
                        int tileY = y * tileHeight;
                        int height = Math.min(tileHeight, this.reader.getSizeY() - tileY);
                        for (int x = 0; x < nXTiles; ++x) {
                            int tileX = x * tileWidth;
                            int width = Math.min(tileWidth, this.reader.getSizeX() - tileX);
                            buf = tileReader.openCompressedBytes(image, x, y);
                            this.writer.saveCompressedBytes(image, buf, tileX, tileY, width, height);
                        }
                    }
                }
            }
        }
    }

    private void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close reader.");
            e.printStackTrace();
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close writer.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        PrecompressedTileReaderWriter tiledReadWriter = new PrecompressedTileReaderWriter(args[0], args[1]);
        tiledReadWriter.initialize();
        try {
            tiledReadWriter.readWriteTiles();
        }
        finally {
            tiledReadWriter.cleanup();
        }
    }
}

