/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.services.POIService;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class POIServiceTest {
    private POIService service;
    private static final String TEST_XLS = "test.xls";
    private static final String WORKBOOK_DOCUMENT = "Root Entry" + File.separator + "Workbook";
    private static final int WORKBOOK_LENGTH = 9604;

    @BeforeMethod
    public void setUp() throws DependencyException, IOException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (POIService)sf.getInstance(POIService.class);
        URL file = this.getClass().getResource(TEST_XLS);
        this.service.initialize(file.getPath());
    }

    @Test
    public void testDocuments() {
        Vector documents = this.service.getDocumentList();
        for (String document : documents) {
            if (!document.equals(WORKBOOK_DOCUMENT)) continue;
            return;
        }
        AssertJUnit.fail((String)("Unable to find document: " + WORKBOOK_DOCUMENT));
    }

    @Test
    public void testWorkbookDocumentAsStream() throws IOException {
        RandomAccessInputStream stream = this.service.getDocumentStream(WORKBOOK_DOCUMENT);
        AssertJUnit.assertNotNull((Object)stream);
        AssertJUnit.assertEquals((long)9604L, (long)stream.length());
    }

    @Test
    public void testWorkbookDocumentBytes() throws IOException {
        byte[] bytes = this.service.getDocumentBytes(WORKBOOK_DOCUMENT);
        AssertJUnit.assertNotNull((Object)bytes);
        AssertJUnit.assertEquals((int)9604, (int)bytes.length);
    }

    @Test
    public void testWorkbookFileSize() {
        AssertJUnit.assertEquals((int)9604, (int)this.service.getFileSize(WORKBOOK_DOCUMENT));
    }
}

