/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import loci.common.DataTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.IniWriter;
import loci.common.Location;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.Modulo;
import loci.formats.ReaderWrapper;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.tests.testng.TestTools;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.primitives.Timestamp;

public class Configuration {
    public static final int TILE_SIZE = 512;
    private static final String ACCESS_TIME = "access_ms";
    private static final String MEMORY = "mem_mb";
    private static final String TEST = "test";
    private static final String HAS_VALID_XML = "hasValidXML";
    private static final String READER = "reader";
    private static final String SERIES = " series_";
    private static final String RESOLUTION = "resolution_";
    private static final String SIZE_X = "SizeX";
    private static final String SIZE_Y = "SizeY";
    private static final String SIZE_Z = "SizeZ";
    private static final String SIZE_C = "SizeC";
    private static final String SIZE_T = "SizeT";
    private static final String DIMENSION_ORDER = "DimensionOrder";
    private static final String IS_INDEXED = "Indexed";
    private static final String IS_INTERLEAVED = "Interleaved";
    private static final String IS_FALSE_COLOR = "FalseColor";
    private static final String IS_RGB = "RGB";
    private static final String THUMB_SIZE_X = "ThumbSizeX";
    private static final String THUMB_SIZE_Y = "ThumbSizeY";
    private static final String PIXEL_TYPE = "PixelType";
    private static final String IS_LITTLE_ENDIAN = "LittleEndian";
    private static final String MD5 = "MD5";
    private static final String ALTERNATE_MD5 = "Alternate_MD5";
    private static final String TILE_MD5 = "Tile_MD5";
    private static final String TILE_ALTERNATE_MD5 = "Tile_Alternate_MD5";
    private static final String PHYSICAL_SIZE_X = "PhysicalSizeX";
    private static final String PHYSICAL_SIZE_X_UNIT = "PhysicalSizeXUnit";
    private static final String PHYSICAL_SIZE_Y = "PhysicalSizeY";
    private static final String PHYSICAL_SIZE_Y_UNIT = "PhysicalSizeYUnit";
    private static final String PHYSICAL_SIZE_Z = "PhysicalSizeZ";
    private static final String PHYSICAL_SIZE_Z_UNIT = "PhysicalSizeZUnit";
    private static final String TIME_INCREMENT = "TimeIncrement";
    private static final String TIME_INCREMENT_UNIT = "TimeIncrementUnit";
    private static final String LIGHT_SOURCE = "LightSource_";
    private static final String CHANNEL_NAME = "ChannelName_";
    private static final String EXPOSURE_TIME = "ExposureTime_";
    private static final String EXPOSURE_TIME_UNIT = "ExposureTimeUnit_";
    private static final String EMISSION_WAVELENGTH = "EmissionWavelength_";
    private static final String EMISSION_WAVELENGTH_UNIT = "EmissionWavelengthUnit_";
    private static final String EXCITATION_WAVELENGTH = "ExcitationWavelength_";
    private static final String EXCITATION_WAVELENGTH_UNIT = "ExcitationWavelengthUnit_";
    private static final String DETECTOR = "Detector_";
    private static final String NAME = "Name";
    private static final String UNFLATTENED_NAME = "Unflattened_Name";
    private static final String DESCRIPTION = "Description";
    private static final String SERIES_COUNT = "series_count";
    private static final String RESOLUTION_COUNT = "resolution_count";
    private static final String CHANNEL_COUNT = "channel_count";
    private static final String DATE = "Date";
    private static final String DELTA_T = "DeltaT_";
    private static final String X_POSITION = "PositionX_";
    private static final String X_POSITION_UNIT = "PositionXUnit_";
    private static final String Y_POSITION = "PositionY_";
    private static final String Y_POSITION_UNIT = "PositionYUnit_";
    private static final String Z_POSITION = "PositionZ_";
    private static final String Z_POSITION_UNIT = "PositionZUnit_";
    private static final String PLATE = "Plate";
    private static final String PLATE_ACQUISITION = "PlateAcquisition";
    private static final String WELL_ROW = "WellRow";
    private static final String WELL_COLUMN = "WellColumn";
    private static final String WELL_SAMPLE = "WellSample";
    private static final String WELL_SAMPLE_POSITION_X = "WellSamplePositionX";
    private static final String WELL_SAMPLE_POSITION_X_UNIT = "WellSamplePositionXUnit";
    private static final String WELL_SAMPLE_POSITION_Y = "WellSamplePositionY";
    private static final String WELL_SAMPLE_POSITION_Y_UNIT = "WellSamplePositionYUnit";
    private static final String MODULO_Z_START = "ModuloZStart";
    private static final String MODULO_Z_STEP = "ModuloZStep";
    private static final String MODULO_Z_END = "ModuloZEnd";
    private static final String MODULO_Z_TYPE = "ModuloZType";
    private static final String MODULO_C_START = "ModuloCStart";
    private static final String MODULO_C_STEP = "ModuloCStep";
    private static final String MODULO_C_END = "ModuloCEnd";
    private static final String MODULO_C_TYPE = "ModuloCType";
    private static final String MODULO_T_START = "ModuloTStart";
    private static final String MODULO_T_STEP = "ModuloTStep";
    private static final String MODULO_T_END = "ModuloTEnd";
    private static final String MODULO_T_TYPE = "ModuloTType";
    private String dataFile;
    private String configFile;
    private IniList ini;
    private IniTable currentTable;
    private IniTable globalTable;
    private Integer flattenedCount = null;

    public Configuration(String dataFile, String configFile) throws IOException {
        this.dataFile = dataFile;
        this.configFile = configFile;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.configFile), "UTF-8"));){
            IniParser parser = new IniParser();
            parser.setCommentDelimiter(null);
            this.ini = parser.parseINI(reader);
            this.pruneINI();
        }
    }

    public Configuration(IFormatReader reader, String configFile) {
        this.dataFile = reader.getCurrentFile();
        this.configFile = configFile;
        this.populateINI(reader);
    }

    public String getFile() {
        return this.dataFile;
    }

    public long getAccessTimeMillis() {
        String millis = (String)this.globalTable.get((Object)ACCESS_TIME);
        if (millis == null) {
            return -1L;
        }
        return Long.parseLong(millis);
    }

    public int getMemory() {
        String memory = (String)this.globalTable.get((Object)MEMORY);
        if (memory == null) {
            return -1;
        }
        return Integer.parseInt(memory);
    }

    public String getTestComment() {
        String test = (String)this.globalTable.get((Object)TEST);
        int delim = test.indexOf("#");
        if (delim >= 0) {
            return test.substring(delim + 1);
        }
        return null;
    }

    public boolean doTest() {
        String test = (String)this.globalTable.get((Object)TEST);
        int delim = test.indexOf("#");
        if (delim >= 0) {
            test = test.substring(0, delim);
        }
        return Boolean.parseBoolean(test.trim());
    }

    public boolean hasValidXML() {
        if (this.globalTable.get((Object)HAS_VALID_XML) == null) {
            return true;
        }
        return Boolean.parseBoolean((String)this.globalTable.get((Object)HAS_VALID_XML));
    }

    public String getReader() {
        return (String)this.globalTable.get((Object)READER);
    }

    public int getSeriesCount() {
        return this.getSeriesCount(true);
    }

    public int getSeriesCount(boolean flattened) {
        int tableCount = Integer.parseInt((String)this.globalTable.get((Object)SERIES_COUNT));
        if (flattened) {
            if (this.flattenedCount == null) {
                int count = 0;
                for (int i = 0; i < tableCount; ++i) {
                    this.setSeries(i, false);
                    count += this.getResolutionCount();
                }
                this.flattenedCount = count;
            }
            return this.flattenedCount;
        }
        return tableCount;
    }

    public int getSizeX() {
        return Integer.parseInt((String)this.currentTable.get((Object)SIZE_X));
    }

    public int getSizeY() {
        return Integer.parseInt((String)this.currentTable.get((Object)SIZE_Y));
    }

    public int getSizeZ() {
        return Integer.parseInt((String)this.currentTable.get((Object)SIZE_Z));
    }

    public int getSizeC() {
        return Integer.parseInt((String)this.currentTable.get((Object)SIZE_C));
    }

    public int getSizeT() {
        return Integer.parseInt((String)this.currentTable.get((Object)SIZE_T));
    }

    public String getDimensionOrder() {
        return (String)this.currentTable.get((Object)DIMENSION_ORDER);
    }

    public boolean isInterleaved() {
        return Boolean.parseBoolean((String)this.currentTable.get((Object)IS_INTERLEAVED));
    }

    public boolean isIndexed() {
        return Boolean.parseBoolean((String)this.currentTable.get((Object)IS_INDEXED));
    }

    public boolean isFalseColor() {
        return Boolean.parseBoolean((String)this.currentTable.get((Object)IS_FALSE_COLOR));
    }

    public boolean isRGB() {
        return Boolean.parseBoolean((String)this.currentTable.get((Object)IS_RGB));
    }

    public int getThumbSizeX() {
        return Integer.parseInt((String)this.currentTable.get((Object)THUMB_SIZE_X));
    }

    public int getThumbSizeY() {
        return Integer.parseInt((String)this.currentTable.get((Object)THUMB_SIZE_Y));
    }

    public String getPixelType() {
        return (String)this.currentTable.get((Object)PIXEL_TYPE);
    }

    public boolean isLittleEndian() {
        return Boolean.parseBoolean((String)this.currentTable.get((Object)IS_LITTLE_ENDIAN));
    }

    public String getMD5() {
        return (String)this.currentTable.get((Object)MD5);
    }

    public String getAlternateMD5() {
        return (String)this.currentTable.get((Object)ALTERNATE_MD5);
    }

    public String getTileMD5() {
        return (String)this.currentTable.get((Object)TILE_MD5);
    }

    public String getTileAlternateMD5() {
        return (String)this.currentTable.get((Object)TILE_ALTERNATE_MD5);
    }

    public Length getPhysicalSizeX() {
        return this.getPhysicalSize(PHYSICAL_SIZE_X, PHYSICAL_SIZE_X_UNIT);
    }

    public Length getPhysicalSizeY() {
        return this.getPhysicalSize(PHYSICAL_SIZE_Y, PHYSICAL_SIZE_Y_UNIT);
    }

    public Length getPhysicalSizeZ() {
        return this.getPhysicalSize(PHYSICAL_SIZE_Z, PHYSICAL_SIZE_Z_UNIT);
    }

    public Time getTimeIncrement() {
        String timeIncrement = (String)this.currentTable.get((Object)TIME_INCREMENT);
        String timeIncrementUnits = (String)this.currentTable.get((Object)TIME_INCREMENT_UNIT);
        try {
            return timeIncrement == null ? null : FormatTools.getTime((Double)Double.parseDouble(timeIncrement), (String)timeIncrementUnits);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getChannelCount() {
        return Integer.parseInt((String)this.currentTable.get((Object)CHANNEL_COUNT));
    }

    public String getLightSource(int channel) {
        return (String)this.currentTable.get((Object)(LIGHT_SOURCE + channel));
    }

    public String getChannelName(int channel) {
        return (String)this.currentTable.get((Object)(CHANNEL_NAME + channel));
    }

    public boolean hasExposureTime(int channel) {
        return this.currentTable.containsKey((Object)(EXPOSURE_TIME + channel));
    }

    public Time getExposureTime(int channel) {
        String exposure = (String)this.currentTable.get((Object)(EXPOSURE_TIME + channel));
        String exposureUnits = (String)this.currentTable.get((Object)(EXPOSURE_TIME_UNIT + channel));
        try {
            return exposure == null ? null : FormatTools.getTime((Double)Double.parseDouble(exposure), (String)exposureUnits);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Double getDeltaT(int plane) {
        String deltaT = (String)this.currentTable.get((Object)(DELTA_T + plane));
        return deltaT == null ? null : Double.valueOf(Double.parseDouble(deltaT));
    }

    public Double getPositionX(int plane) {
        String pos = (String)this.currentTable.get((Object)(X_POSITION + plane));
        return pos == null ? null : Double.valueOf(Double.parseDouble(pos));
    }

    public String getPositionXUnit(int plane) {
        return (String)this.currentTable.get((Object)(X_POSITION_UNIT + plane));
    }

    public Double getPositionY(int plane) {
        String pos = (String)this.currentTable.get((Object)(Y_POSITION + plane));
        return pos == null ? null : Double.valueOf(Double.parseDouble(pos));
    }

    public String getPositionYUnit(int plane) {
        return (String)this.currentTable.get((Object)(Y_POSITION_UNIT + plane));
    }

    public Double getPositionZ(int plane) {
        String pos = (String)this.currentTable.get((Object)(Z_POSITION + plane));
        return pos == null ? null : Double.valueOf(Double.parseDouble(pos));
    }

    public String getPositionZUnit(int plane) {
        return (String)this.currentTable.get((Object)(Z_POSITION_UNIT + plane));
    }

    public Length getEmissionWavelength(int channel) {
        String wavelength = (String)this.currentTable.get((Object)(EMISSION_WAVELENGTH + channel));
        String emissionUnits = (String)this.currentTable.get((Object)(EMISSION_WAVELENGTH_UNIT + channel));
        try {
            return wavelength == null ? null : FormatTools.getWavelength((Double)Double.parseDouble(wavelength), (String)emissionUnits);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Length getExcitationWavelength(int channel) {
        String wavelength = (String)this.currentTable.get((Object)(EXCITATION_WAVELENGTH + channel));
        String excitationUnits = (String)this.currentTable.get((Object)(EXCITATION_WAVELENGTH_UNIT + channel));
        try {
            return wavelength == null ? null : FormatTools.getWavelength((Double)Double.parseDouble(wavelength), (String)excitationUnits);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getDetector(int channel) {
        return (String)this.currentTable.get((Object)(DETECTOR + channel));
    }

    public String getImageName() {
        return (String)this.currentTable.get((Object)NAME);
    }

    public String getUnflattenedImageName() {
        return (String)this.currentTable.get((Object)UNFLATTENED_NAME);
    }

    public boolean hasImageDescription() {
        return this.currentTable.containsKey((Object)DESCRIPTION);
    }

    public String getImageDescription() {
        return (String)this.currentTable.get((Object)DESCRIPTION);
    }

    public String getDate() {
        return (String)this.currentTable.get((Object)DATE);
    }

    public int getResolutionCount() {
        return this.getInt(RESOLUTION_COUNT, 1);
    }

    public int getPlate() {
        return this.getInt(PLATE, Integer.MIN_VALUE);
    }

    public int getPlateAcquisition() {
        return this.getInt(PLATE_ACQUISITION, -1);
    }

    public int getWellRow() {
        return this.getInt(WELL_ROW, -1);
    }

    public int getWellColumn() {
        return this.getInt(WELL_COLUMN, -1);
    }

    public int getWellSample() {
        return this.getInt(WELL_SAMPLE, -1);
    }

    public Length getWellSamplePositionX() {
        return this.getPhysicalSize(WELL_SAMPLE_POSITION_X, WELL_SAMPLE_POSITION_X_UNIT);
    }

    public Length getWellSamplePositionY() {
        return this.getPhysicalSize(WELL_SAMPLE_POSITION_Y, WELL_SAMPLE_POSITION_Y_UNIT);
    }

    public Double getModuloZStart() {
        String start = (String)this.currentTable.get((Object)MODULO_Z_START);
        return start == null ? null : Double.valueOf(Double.parseDouble(start));
    }

    public Double getModuloZStep() {
        String step = (String)this.currentTable.get((Object)MODULO_Z_STEP);
        return step == null ? null : Double.valueOf(Double.parseDouble(step));
    }

    public Double getModuloZEnd() {
        String end = (String)this.currentTable.get((Object)MODULO_Z_END);
        return end == null ? null : Double.valueOf(Double.parseDouble(end));
    }

    public String getModuloZType() {
        return (String)this.currentTable.get((Object)MODULO_Z_TYPE);
    }

    public Double getModuloCStart() {
        String start = (String)this.currentTable.get((Object)MODULO_C_START);
        return start == null ? null : Double.valueOf(Double.parseDouble(start));
    }

    public Double getModuloCStep() {
        String step = (String)this.currentTable.get((Object)MODULO_C_STEP);
        return step == null ? null : Double.valueOf(Double.parseDouble(step));
    }

    public Double getModuloCEnd() {
        String end = (String)this.currentTable.get((Object)MODULO_C_END);
        return end == null ? null : Double.valueOf(Double.parseDouble(end));
    }

    public String getModuloCType() {
        return (String)this.currentTable.get((Object)MODULO_C_TYPE);
    }

    public Double getModuloTStart() {
        String start = (String)this.currentTable.get((Object)MODULO_T_START);
        return start == null ? null : Double.valueOf(Double.parseDouble(start));
    }

    public Double getModuloTStep() {
        String step = (String)this.currentTable.get((Object)MODULO_T_STEP);
        return step == null ? null : Double.valueOf(Double.parseDouble(step));
    }

    public Double getModuloTEnd() {
        String end = (String)this.currentTable.get((Object)MODULO_T_END);
        return end == null ? null : Double.valueOf(Double.parseDouble(end));
    }

    public String getModuloTType() {
        return (String)this.currentTable.get((Object)MODULO_T_TYPE);
    }

    public void setSeries(int series) throws IndexOutOfBoundsException {
        this.setSeries(series, true);
    }

    public void setSeries(int series, boolean flattened) throws IndexOutOfBoundsException {
        block5: {
            int s = series;
            int r = 0;
            int index = series;
            if (flattened && this.getSeriesCount(true) != this.getSeriesCount(false)) {
                index = 0;
                s = 0;
                while (index < series) {
                    this.setSeries(s, false);
                    int resolutionCount = this.getResolutionCount();
                    if (resolutionCount + index <= series) {
                        index += resolutionCount;
                        ++s;
                        continue;
                    }
                    r = series - index;
                    index += r;
                }
            }
            try {
                this.setResolution(s, r);
            }
            catch (IndexOutOfBoundsException e) {
                Location file = new Location(this.dataFile);
                String tableName = file.getName() + SERIES + index;
                this.currentTable = this.ini.getTable(tableName);
                if (this.currentTable != null) break block5;
                throw new IndexOutOfBoundsException("Invalid table name: " + tableName);
            }
        }
    }

    public void setResolution(int series, int resolution) throws IndexOutOfBoundsException {
        Location file = new Location(this.dataFile);
        String tableName = file.getName() + SERIES + series + " " + RESOLUTION + resolution;
        this.currentTable = this.ini.getTable(tableName);
        if (this.currentTable == null && resolution == 0) {
            this.currentTable = this.ini.getTable(file.getName() + SERIES + series);
        }
        if (this.currentTable == null) {
            throw new IndexOutOfBoundsException("Invalid table name: " + tableName);
        }
    }

    public void saveToFile() throws IOException {
        IniWriter writer = new IniWriter();
        writer.saveINI(this.ini, this.configFile, true, true);
    }

    public IniList getINI() {
        return this.ini;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration thatConfig = (Configuration)o;
        return this.getINI().equals((Object)thatConfig.getINI());
    }

    public int hashCode() {
        return this.getINI().hashCode();
    }

    private void populateINI(IFormatReader reader) {
        IMetadata retrieve = (IMetadata)reader.getMetadataStore();
        this.ini = new IniList();
        IniTable globalTable = new IniTable();
        this.putTableName(globalTable, reader, " global");
        int seriesCount = reader.getSeriesCount();
        ImageReader unflattenedReader = new ImageReader();
        unflattenedReader.setMetadataStore((MetadataStore)MetadataTools.createOMEXMLMetadata());
        unflattenedReader.setFlattenedResolutions(false);
        unflattenedReader.setMetadataOptions((MetadataOptions)new DynamicMetadataOptions());
        try {
            unflattenedReader.setId(reader.getCurrentFile());
        }
        catch (IOException | FormatException throwable) {
            // empty catch block
        }
        seriesCount = unflattenedReader.getSeriesCount();
        IMetadata unflattenedRetrieve = (IMetadata)unflattenedReader.getMetadataStore();
        globalTable.put((Object)SERIES_COUNT, (Object)String.valueOf(seriesCount));
        IFormatReader r = reader;
        if (r instanceof ImageReader) {
            r = ((ImageReader)r).getReader();
        } else if (r instanceof ReaderWrapper) {
            try {
                r = ((ReaderWrapper)r).unwrap();
            }
            catch (FormatException formatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        globalTable.put((Object)READER, (Object)TestTools.shortClassName(r));
        globalTable.put((Object)TEST, (Object)"true");
        globalTable.put((Object)MEMORY, (Object)String.valueOf(TestTools.getUsedMemory()));
        long t0 = System.currentTimeMillis();
        if (this.canOpenImages(reader)) {
            try {
                reader.openBytes(0);
            }
            catch (FormatException formatException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long t1 = System.currentTimeMillis();
        globalTable.put((Object)ACCESS_TIME, (Object)String.valueOf(t1 - t0));
        this.ini.add((Object)globalTable);
        for (int series = 0; series < seriesCount; ++series) {
            unflattenedReader.setSeries(series);
            int resolutionCount = unflattenedReader.getResolutionCount();
            for (int resolution = 0; resolution < resolutionCount; ++resolution) {
                String date;
                Timestamp acquisition;
                Modulo moduloT;
                Modulo moduloC;
                unflattenedReader.setResolution(resolution);
                int index = unflattenedReader.getCoreIndex();
                reader.setCoreIndex(index);
                IniTable seriesTable = new IniTable();
                this.putTableName(seriesTable, (IFormatReader)unflattenedReader, SERIES + series + " " + RESOLUTION + resolution);
                if (resolution == 0) {
                    seriesTable.put((Object)RESOLUTION_COUNT, (Object)String.valueOf(resolutionCount));
                }
                seriesTable.put((Object)SIZE_X, (Object)String.valueOf(reader.getSizeX()));
                seriesTable.put((Object)SIZE_Y, (Object)String.valueOf(reader.getSizeY()));
                seriesTable.put((Object)SIZE_Z, (Object)String.valueOf(reader.getSizeZ()));
                seriesTable.put((Object)SIZE_C, (Object)String.valueOf(reader.getSizeC()));
                seriesTable.put((Object)SIZE_T, (Object)String.valueOf(reader.getSizeT()));
                seriesTable.put((Object)DIMENSION_ORDER, (Object)reader.getDimensionOrder());
                seriesTable.put((Object)IS_INTERLEAVED, (Object)String.valueOf(reader.isInterleaved()));
                seriesTable.put((Object)IS_INDEXED, (Object)String.valueOf(reader.isIndexed()));
                seriesTable.put((Object)IS_FALSE_COLOR, (Object)String.valueOf(reader.isFalseColor()));
                seriesTable.put((Object)IS_RGB, (Object)String.valueOf(reader.isRGB()));
                seriesTable.put((Object)THUMB_SIZE_X, (Object)String.valueOf(reader.getThumbSizeX()));
                seriesTable.put((Object)THUMB_SIZE_Y, (Object)String.valueOf(reader.getThumbSizeY()));
                seriesTable.put((Object)PIXEL_TYPE, (Object)FormatTools.getPixelTypeString((int)reader.getPixelType()));
                seriesTable.put((Object)IS_LITTLE_ENDIAN, (Object)String.valueOf(reader.isLittleEndian()));
                seriesTable.put((Object)CHANNEL_COUNT, (Object)String.valueOf(retrieve.getChannelCount(index)));
                Modulo moduloZ = reader.getModuloZ();
                if (moduloZ.length() > 1) {
                    seriesTable.put((Object)MODULO_Z_START, (Object)String.valueOf(moduloZ.start));
                    seriesTable.put((Object)MODULO_Z_STEP, (Object)String.valueOf(moduloZ.step));
                    seriesTable.put((Object)MODULO_Z_END, (Object)String.valueOf(moduloZ.end));
                    seriesTable.put((Object)MODULO_Z_TYPE, (Object)moduloZ.type);
                }
                if ((moduloC = reader.getModuloC()).length() > 1) {
                    seriesTable.put((Object)MODULO_C_START, (Object)String.valueOf(moduloC.start));
                    seriesTable.put((Object)MODULO_C_STEP, (Object)String.valueOf(moduloC.step));
                    seriesTable.put((Object)MODULO_C_END, (Object)String.valueOf(moduloC.end));
                    seriesTable.put((Object)MODULO_C_TYPE, (Object)moduloC.type);
                }
                if ((moduloT = reader.getModuloT()).length() > 1) {
                    seriesTable.put((Object)MODULO_T_START, (Object)String.valueOf(moduloT.start));
                    seriesTable.put((Object)MODULO_T_STEP, (Object)String.valueOf(moduloT.step));
                    seriesTable.put((Object)MODULO_T_END, (Object)String.valueOf(moduloT.end));
                    seriesTable.put((Object)MODULO_T_TYPE, (Object)moduloT.type);
                }
                if (this.canOpenImages(reader)) {
                    try {
                        byte[] plane = reader.openBytes(0);
                        seriesTable.put((Object)MD5, (Object)TestTools.md5(plane));
                    }
                    catch (FormatException plane) {
                    }
                    catch (IOException plane) {
                        // empty catch block
                    }
                }
                try {
                    int w = Math.min(512, reader.getSizeX());
                    int h = Math.min(512, reader.getSizeY());
                    byte[] tile = reader.openBytes(0, 0, 0, w, h);
                    seriesTable.put((Object)TILE_MD5, (Object)TestTools.md5(tile));
                }
                catch (FormatException w) {
                }
                catch (IOException w) {
                    // empty catch block
                }
                String flattenedName = retrieve.getImageName(index);
                seriesTable.put((Object)NAME, (Object)flattenedName);
                String unflattenedName = unflattenedRetrieve.getImageName(series);
                if (!(unflattenedName == null || flattenedName != null && flattenedName.equals(unflattenedName))) {
                    seriesTable.put((Object)UNFLATTENED_NAME, (Object)unflattenedName);
                }
                seriesTable.put((Object)DESCRIPTION, (Object)retrieve.getImageDescription(index));
                Length physicalX = retrieve.getPixelsPhysicalSizeX(index);
                this.putLength(seriesTable, physicalX, PHYSICAL_SIZE_X, PHYSICAL_SIZE_X_UNIT);
                Length physicalY = retrieve.getPixelsPhysicalSizeY(index);
                this.putLength(seriesTable, physicalY, PHYSICAL_SIZE_Y, PHYSICAL_SIZE_Y_UNIT);
                Length physicalZ = retrieve.getPixelsPhysicalSizeZ(index);
                this.putLength(seriesTable, physicalZ, PHYSICAL_SIZE_Z, PHYSICAL_SIZE_Z_UNIT);
                Time timeIncrement = retrieve.getPixelsTimeIncrement(index);
                if (timeIncrement != null) {
                    seriesTable.put((Object)TIME_INCREMENT, (Object)timeIncrement.value().toString());
                    seriesTable.put((Object)TIME_INCREMENT_UNIT, (Object)timeIncrement.unit().getSymbol());
                }
                if ((acquisition = retrieve.getImageAcquisitionDate(index)) != null && (date = (String)acquisition.getValue()) != null) {
                    seriesTable.put((Object)DATE, (Object)date);
                }
                for (int c = 0; c < retrieve.getChannelCount(index); ++c) {
                    seriesTable.put((Object)(CHANNEL_NAME + c), (Object)retrieve.getChannelName(index, c));
                    try {
                        seriesTable.put((Object)(LIGHT_SOURCE + c), (Object)retrieve.getChannelLightSourceSettingsID(index, c));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        int plane = reader.getIndex(0, c, 0);
                        if (plane < retrieve.getPlaneCount(index)) {
                            seriesTable.put((Object)(EXPOSURE_TIME + c), (Object)retrieve.getPlaneExposureTime(index, plane).value().toString());
                            seriesTable.put((Object)(EXPOSURE_TIME_UNIT + c), (Object)retrieve.getPlaneExposureTime(index, plane).unit().getSymbol());
                        }
                    }
                    catch (NullPointerException plane) {
                        // empty catch block
                    }
                    Length emWavelength = retrieve.getChannelEmissionWavelength(index, c);
                    this.putLength(seriesTable, emWavelength, EMISSION_WAVELENGTH + c, EMISSION_WAVELENGTH_UNIT + c);
                    Length exWavelength = retrieve.getChannelExcitationWavelength(index, c);
                    this.putLength(seriesTable, exWavelength, EXCITATION_WAVELENGTH + c, EXCITATION_WAVELENGTH_UNIT + c);
                    try {
                        seriesTable.put((Object)(DETECTOR + c), (Object)retrieve.getDetectorSettingsID(index, c));
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                for (int p = 0; p < reader.getImageCount(); ++p) {
                    try {
                        Time deltaT = retrieve.getPlaneDeltaT(index, p);
                        if (deltaT != null) {
                            seriesTable.put((Object)(DELTA_T + p), (Object)deltaT.value(UNITS.SECOND).toString());
                        }
                        Length xPos = retrieve.getPlanePositionX(index, p);
                        this.putLength(seriesTable, xPos, X_POSITION + p, X_POSITION_UNIT + p);
                        Length yPos = retrieve.getPlanePositionY(index, p);
                        this.putLength(seriesTable, yPos, Y_POSITION + p, Y_POSITION_UNIT + p);
                        Length zPos = retrieve.getPlanePositionZ(index, p);
                        this.putLength(seriesTable, zPos, Z_POSITION + p, Z_POSITION_UNIT + p);
                        continue;
                    }
                    catch (IndexOutOfBoundsException deltaT) {
                        // empty catch block
                    }
                }
                String imageID = retrieve.getImageID(index);
                boolean foundWellSample = false;
                for (int p = 0; !foundWellSample && p < retrieve.getPlateCount(); ++p) {
                    block29: for (int w = 0; !foundWellSample && w < retrieve.getWellCount(p); ++w) {
                        for (int ws = 0; ws < retrieve.getWellSampleCount(p, w); ++ws) {
                            String imageRef = retrieve.getWellSampleImageRef(p, w, ws);
                            if (!imageID.equals(imageRef)) continue;
                            seriesTable.put((Object)PLATE, (Object)String.valueOf(p));
                            seriesTable.put((Object)WELL_ROW, (Object)retrieve.getWellRow(p, w).toString());
                            seriesTable.put((Object)WELL_COLUMN, (Object)retrieve.getWellColumn(p, w).toString());
                            seriesTable.put((Object)WELL_SAMPLE, (Object)String.valueOf(ws));
                            Length positionX = retrieve.getWellSamplePositionX(p, w, ws);
                            Length positionY = retrieve.getWellSamplePositionY(p, w, ws);
                            this.putLength(seriesTable, positionX, WELL_SAMPLE_POSITION_X, WELL_SAMPLE_POSITION_X_UNIT);
                            this.putLength(seriesTable, positionY, WELL_SAMPLE_POSITION_Y, WELL_SAMPLE_POSITION_Y_UNIT);
                            String wellSampleID = retrieve.getWellSampleID(p, w, ws);
                            boolean foundPA = false;
                            block31: for (int pa = 0; !foundPA && pa < retrieve.getPlateAcquisitionCount(p); ++pa) {
                                for (int wsRef = 0; wsRef < retrieve.getWellSampleRefCount(p, pa); ++wsRef) {
                                    String wellSampleRef = retrieve.getPlateAcquisitionWellSampleRef(p, pa, wsRef);
                                    if (!wellSampleID.equals(wellSampleRef)) continue;
                                    seriesTable.put((Object)PLATE_ACQUISITION, (Object)String.valueOf(pa));
                                    foundPA = true;
                                    continue block31;
                                }
                            }
                            continue block29;
                        }
                    }
                }
                this.ini.add((Object)seriesTable);
            }
        }
        if (!unflattenedReader.equals(reader)) {
            try {
                unflattenedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void putTableName(IniTable table, IFormatReader reader, String suffix) {
        Location file = new Location(reader.getCurrentFile());
        table.put((Object)"header", (Object)(file.getName() + suffix));
    }

    private void putLength(IniTable table, Length value, String valueKey, String unitKey) {
        if (value != null) {
            table.put((Object)valueKey, (Object)String.valueOf(value.value().doubleValue()));
            table.put((Object)unitKey, (Object)value.unit().getSymbol());
        }
    }

    private void pruneINI() {
        IniList newIni = new IniList();
        for (IniTable table : this.ini) {
            Location file;
            String tableName = (String)table.get((Object)"header");
            if (!tableName.startsWith((file = new Location(this.dataFile)).getName() + " ")) continue;
            newIni.add((Object)table);
            if (!tableName.endsWith("global")) continue;
            this.globalTable = table;
        }
        this.ini = newIni;
    }

    private int getInt(String key, int defaultValue) {
        int rtn = defaultValue;
        if (this.currentTable.get((Object)key) != null) {
            rtn = Integer.parseInt((String)this.currentTable.get((Object)key));
        }
        return rtn;
    }

    private Length getPhysicalSize(String valueKey, String unitKey) {
        String physicalSize = (String)this.currentTable.get((Object)valueKey);
        String units = (String)this.currentTable.get((Object)unitKey);
        try {
            UnitsLength unit = units == null ? UnitsLength.MICROMETER : UnitsLength.fromString((String)units);
            return physicalSize == null ? null : UnitsLength.create((Number)Double.parseDouble(physicalSize), (UnitsLength)unit);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return null;
    }

    private boolean canOpenImages(IFormatReader reader) {
        try {
            long planeSize = DataTools.safeMultiply32((int[])new int[]{reader.getSizeX(), reader.getSizeY(), reader.getEffectiveSizeC(), reader.getRGBChannelCount(), FormatTools.getBytesPerPixel((int)reader.getPixelType())});
            return planeSize > 0L && TestTools.canFitInMemory(planeSize);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

