/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import loci.tests.testng.FormatReaderTest;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;

public class OrderingListener
implements IMethodInterceptor {
    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        IMethodInstance[] originalMethods = methods.toArray(new IMethodInstance[methods.size()]);
        Arrays.sort(originalMethods, new Comparator<IMethodInstance>(){

            @Override
            public int compare(IMethodInstance m1, IMethodInstance m2) {
                String instance2;
                FormatReaderTest i1 = (FormatReaderTest)m1.getInstances()[0];
                FormatReaderTest i2 = (FormatReaderTest)m2.getInstances()[0];
                String instance1 = i1.getID();
                int instance = instance1.compareTo(instance2 = i2.getID());
                if (instance != 0) {
                    return instance;
                }
                ITestNGMethod method1 = m1.getMethod();
                ITestNGMethod method2 = m2.getMethod();
                return method1.getMethodName().compareTo(method2.getMethodName());
            }
        });
        ArrayList<IMethodInstance> orderedMethods = new ArrayList<IMethodInstance>();
        for (IMethodInstance method : originalMethods) {
            orderedMethods.add(method);
        }
        return orderedMethods;
    }
}

