/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.utests.BaseModelMock;
import loci.formats.utests.SPWModelReaderTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BaseModelReaderTest {
    private BaseModelMock mock;
    private File temporaryFile;
    private IFormatReader reader;
    private IMetadata metadata;

    @BeforeClass
    public void setUp() throws Exception {
        this.mock = new BaseModelMock();
        this.temporaryFile = File.createTempFile(this.getClass().getName(), ".ome");
        SPWModelReaderTest.writeMockToFile(this.mock, this.temporaryFile, true);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.temporaryFile.delete();
    }

    @Test
    public void testSetId() throws Exception {
        this.reader = new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller((IFormatReader)new ImageReader())));
        this.metadata = new OMEXMLMetadataImpl();
        this.reader.setMetadataStore((MetadataStore)this.metadata);
        this.reader.setId(this.temporaryFile.getAbsolutePath());
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testSeriesCount() {
        AssertJUnit.assertEquals((int)1, (int)this.reader.getSeriesCount());
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testCanReadEveryPlane() throws Exception {
        AssertJUnit.assertTrue((boolean)SPWModelReaderTest.canReadEveryPlane(this.reader));
    }
}

