/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.ImageReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ImageReaderTest {
    public static final String KEY = "test.option";
    public static final String VALUE = "foo";

    @DataProvider(name="levels")
    public Object[][] createLevels() {
        return new Object[][]{{MetadataLevel.MINIMUM}, {MetadataLevel.NO_OVERLAYS}, {MetadataLevel.ALL}};
    }

    @Test
    public void testOptionsExplicit() throws Exception {
        DynamicMetadataOptions opt = new DynamicMetadataOptions();
        opt.set(KEY, VALUE);
        ImageReader reader = new ImageReader();
        reader.setMetadataOptions((MetadataOptions)opt);
        reader.setId("test.fake");
        MetadataOptions rOpt = reader.getReader().getMetadataOptions();
        Assert.assertTrue((boolean)(rOpt instanceof DynamicMetadataOptions));
        String v = ((DynamicMetadataOptions)rOpt).get(KEY);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)v, (String)VALUE);
        reader.close();
    }

    @Test(dataProvider="levels")
    public void testOptionsImplicit(MetadataLevel level) throws Exception {
        ImageReader reader = new ImageReader();
        reader.getMetadataOptions().setMetadataLevel(level);
        reader.setId("test.fake");
        MetadataLevel rLevel = reader.getReader().getMetadataOptions().getMetadataLevel();
        Assert.assertEquals((Object)rLevel, (Object)level);
        reader.close();
    }
}

