/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import ch.systemsx.cisd.base.mdarray.MDIntArray;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.services.JHDFService;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JHDFServiceTest {
    private static final String TEST_FILE = "test_jhdf.h5";
    private JHDFService service;

    @BeforeMethod
    public void setUp() throws DependencyException, IOException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (JHDFService)sf.getInstance(JHDFService.class);
        URL file = JHDFServiceTest.class.getResource(TEST_FILE);
        this.service.setFile(file.getPath());
    }

    @Test
    public void testGetFile() {
        AssertJUnit.assertEquals((String)TEST_FILE, (String)new File(this.service.getFile()).getName());
    }

    @Test
    public void testGetShape() {
        int[] shape = this.service.getShape("/member_1/member_3/int_matrix");
        AssertJUnit.assertEquals((int)shape.length, (int)3);
        AssertJUnit.assertEquals((int)shape[0], (int)10);
        AssertJUnit.assertEquals((int)shape[1], (int)9);
        AssertJUnit.assertEquals((int)shape[2], (int)8);
    }

    @Test
    public void testReadString() {
        String[] strings = this.service.readStringArray("/member_2/strings");
        for (int i = 0; i < strings.length; ++i) {
            Assert.assertTrue((boolean)strings[i].equals(String.format("string_%d", i)));
        }
    }

    @Test
    public void testReadIntMatrix() {
        MDIntArray matrix = this.service.readIntArray("/member_1/member_3/int_matrix");
        AssertJUnit.assertEquals((int)matrix.get(2, 1, 0), (int)123);
    }

    @Test
    public void testMember() {
        List member = this.service.getMember("/member_1/");
        AssertJUnit.assertEquals((String)((String)member.get(0)), (String)"member_3");
    }

    @Test
    public void testReadIntBlockArray() {
        MDIntArray matrix = this.service.readIntBlockArray("/member_1/member_3/int_matrix", new int[]{0, 0, 0}, new int[]{10, 1, 8});
        AssertJUnit.assertEquals((int)matrix.get(6, 0, 4), (int)178);
    }
}

